/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore.dev;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.BlobstoreServicePb;
import com.google.appengine.api.blobstore.dev.BlobStorage;
import com.google.appengine.api.blobstore.dev.BlobStorageFactory;
import com.google.appengine.api.blobstore.dev.BlobUploadSession;
import com.google.appengine.api.blobstore.dev.BlobUploadSessionStorage;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.config.GenerationDirectory;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ServiceProvider(value=LocalRpcService.class)
public class LocalBlobstoreService
implements LocalRpcService {
    private static final Logger logger = Logger.getLogger(LocalBlobstoreService.class.getName());
    public static final String BACKING_STORE_PROPERTY = "blobstore.backing_store";
    public static final String NO_STORAGE_PROPERTY = "blobstore.no_storage";
    public static final String PACKAGE = "blobstore";
    static final String UPLOAD_URL_PREFIX = "/_ah/upload/";
    private BlobStorage blobStorage;
    private BlobUploadSessionStorage uploadSessionStorage;

    public String getPackage() {
        return PACKAGE;
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        this.uploadSessionStorage = new BlobUploadSessionStorage();
        String noStorage = properties.get(NO_STORAGE_PROPERTY);
        if (noStorage != null && Boolean.valueOf(noStorage).booleanValue()) {
            BlobStorageFactory.setMemoryBlobStorage();
        } else {
            String filePath = properties.get(BACKING_STORE_PROPERTY);
            File file = filePath != null ? new File(filePath) : GenerationDirectory.getGenerationDirectory((File)context.getAppDir());
            file.mkdirs();
            BlobStorageFactory.setFileBlobStorage(file);
        }
        this.blobStorage = BlobStorageFactory.getBlobStorage();
    }

    public void start() {
    }

    public void stop() {
    }

    public BlobstoreServicePb.CreateUploadURLResponse createUploadURL(LocalRpcService.Status status, BlobstoreServicePb.CreateUploadURLRequest request) {
        String sessionId = this.uploadSessionStorage.createSession(new BlobUploadSession(request.getSuccessPath()));
        BlobstoreServicePb.CreateUploadURLResponse response = new BlobstoreServicePb.CreateUploadURLResponse();
        response.setUrl(UPLOAD_URL_PREFIX + sessionId);
        return response;
    }

    public ApiBasePb.VoidProto deleteBlob(LocalRpcService.Status status, final BlobstoreServicePb.DeleteBlobRequest request) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                for (String blobKeyString : request.blobKeys()) {
                    BlobKey blobKey = new BlobKey(blobKeyString);
                    if (!LocalBlobstoreService.this.blobStorage.hasBlob(blobKey)) continue;
                    try {
                        LocalBlobstoreService.this.blobStorage.deleteBlob(blobKey);
                    }
                    catch (IOException ex) {
                        logger.log(Level.WARNING, "Could not delete blob: " + blobKey, ex);
                        throw new ApiProxy.ApplicationException(BlobstoreServicePb.BlobstoreServiceError.ErrorCode.INTERNAL_ERROR.ordinal(), ex.toString());
                    }
                }
                return null;
            }
        });
        return new ApiBasePb.VoidProto();
    }
}

