/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore.dev;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.dev.BlobInfoStorage;
import com.google.appengine.api.blobstore.dev.BlobStorage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

class MemoryBlobStorage
implements BlobStorage {
    private final Map<BlobKey, byte[]> blobContents = new HashMap<BlobKey, byte[]>();
    private final BlobInfoStorage blobInfoStorage;

    MemoryBlobStorage(BlobInfoStorage blobInfoStorage) {
        this.blobInfoStorage = blobInfoStorage;
    }

    public boolean hasBlob(BlobKey blobKey) {
        return this.blobContents.containsKey(blobKey);
    }

    public OutputStream storeBlob(final BlobKey blobKey) throws IOException {
        return new ByteArrayOutputStream(){

            public void close() throws IOException {
                super.close();
                MemoryBlobStorage.this.blobContents.put(blobKey, this.toByteArray());
            }
        };
    }

    public InputStream fetchBlob(BlobKey blobKey) throws IOException {
        if (this.blobContents.containsKey(blobKey)) {
            return new ByteArrayInputStream(this.blobContents.get(blobKey));
        }
        throw new IOException("Could not find blob: " + blobKey);
    }

    public void deleteBlob(BlobKey blobKey) throws IOException {
        this.blobContents.remove(blobKey);
        this.blobInfoStorage.deleteBlobInfo(blobKey);
    }
}

