/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore.dev;

import com.google.appengine.api.blobstore.BlobInfo;
import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.dev.BlobInfoStorage;
import com.google.appengine.api.blobstore.dev.BlobStorage;
import com.google.appengine.api.blobstore.dev.BlobStorageFactory;
import com.google.appengine.repackaged.com.google.common.io.ByteStreams;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class ServeBlobFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(ServeBlobFilter.class.getName());
    static final String SERVE_HEADER = "X-AppEngine-BlobKey";
    static final String CONTENT_TYPE_HEADER = "Content-type";
    private BlobStorage blobStorage;
    private BlobInfoStorage blobInfoStorage;

    public void init(FilterConfig config) {
        this.blobInfoStorage = BlobStorageFactory.getBlobInfoStorage();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ResponseWrapper wrapper = new ResponseWrapper((HttpServletResponse)response);
        chain.doFilter(request, (ServletResponse)wrapper);
        BlobKey blobKey = wrapper.getBlobKey();
        if (blobKey != null) {
            this.serveBlob(blobKey, wrapper.hasContentType(), (HttpServletResponse)wrapper);
        }
    }

    public void destroy() {
    }

    private BlobStorage getBlobStorage() {
        if (this.blobStorage == null) {
            ApiProxyLocal local = (ApiProxyLocal)ApiProxy.getDelegate();
            local.getService("blobstore");
            this.blobStorage = BlobStorageFactory.getBlobStorage();
        }
        return this.blobStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serveBlob(BlobKey blobKey, boolean hasContentType, HttpServletResponse response) throws IOException {
        if (response.isCommitted()) {
            logger.severe("Asked to send blob " + blobKey + " but response was already committed.");
            return;
        }
        if (!this.getBlobStorage().hasBlob(blobKey)) {
            logger.severe("Could not find blob: " + blobKey);
            response.sendError(404);
            return;
        }
        if (!hasContentType) {
            response.setContentType(this.getContentType(blobKey));
        }
        InputStream inStream = this.getBlobStorage().fetchBlob(blobKey);
        ServletOutputStream outStream = response.getOutputStream();
        try {
            ByteStreams.copy((InputStream)inStream, (OutputStream)outStream);
        }
        finally {
            inStream.close();
            outStream.close();
        }
    }

    private String getContentType(BlobKey blobKey) {
        BlobInfo blobInfo = this.blobInfoStorage.loadBlobInfo(blobKey);
        if (blobInfo != null) {
            return blobInfo.getContentType();
        }
        return "application/octet-stream";
    }

    public static class ResponseWrapper
    extends HttpServletResponseWrapper {
        private BlobKey blobKey;
        private boolean hasContentType;

        public ResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public void setContentType(String contentType) {
            super.setContentType(contentType);
            this.hasContentType = true;
        }

        public void addHeader(String name, String value) {
            if (name.equalsIgnoreCase(ServeBlobFilter.SERVE_HEADER)) {
                this.blobKey = new BlobKey(value);
            } else if (name.equalsIgnoreCase(ServeBlobFilter.CONTENT_TYPE_HEADER)) {
                this.hasContentType = true;
                super.addHeader(name, value);
            } else {
                super.addHeader(name, value);
            }
        }

        public void setHeader(String name, String value) {
            if (name.equalsIgnoreCase(ServeBlobFilter.SERVE_HEADER)) {
                this.blobKey = new BlobKey(value);
            } else if (name.equalsIgnoreCase(ServeBlobFilter.CONTENT_TYPE_HEADER)) {
                this.hasContentType = true;
                super.setHeader(name, value);
            } else {
                super.setHeader(name, value);
            }
        }

        public boolean containsHeader(String name) {
            if (name.equals(ServeBlobFilter.SERVE_HEADER)) {
                return this.blobKey != null;
            }
            return super.containsHeader(name);
        }

        public BlobKey getBlobKey() {
            return this.blobKey;
        }

        public boolean hasContentType() {
            return this.hasContentType;
        }
    }
}

