/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.DataTypeTranslator;
import com.google.appengine.api.datastore.EntityProtoComparators;
import com.google.appengine.api.datastore.dev.LocalCompositeIndexManager;
import com.google.appengine.api.labs.taskqueue.TaskQueuePb;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Predicate;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSource;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.utils.config.GenerationDirectory;
import com.google.storage.onestore.PropertyType;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ServiceProvider(value=LocalRpcService.class)
public class LocalDatastoreService
implements LocalRpcService {
    private static final Logger logger = Logger.getLogger(LocalDatastoreService.class.getName());
    static final int DEFAULT_BATCH_SIZE = 20;
    static final int MAXIMUM_RESULTS_SIZE = 1000;
    public static final String PACKAGE = "datastore_v3";
    public static final String MAX_QUERY_LIFETIME_PROPERTY = "datastore.max_query_lifetime";
    private static final int DEFAULT_MAX_QUERY_LIFETIME = 30000;
    public static final String MAX_TRANSACTION_LIFETIME_PROPERTY = "datastore.max_txn_lifetime";
    private static final int DEFAULT_MAX_TRANSACTION_LIFETIME = 30000;
    public static final String STORE_DELAY_PROPERTY = "datastore.store_delay";
    static final int DEFAULT_STORE_DELAY_MS = 30000;
    public static final String BACKING_STORE_PROPERTY = "datastore.backing_store";
    public static final String NO_STORAGE_PROPERTY = "datastore.no_storage";
    private static final Pattern RESERVED_NAME = Pattern.compile("__.*__");
    static final String ENTITY_GROUP_MESSAGE = "can't operate on multiple entity groups in a single transaction.";
    static final String CONTENTION_MESSAGE = "too much contention on these datastore entities. please try again.";
    static final String HANDLE_NOT_FOUND_MESSAGE_FORMAT = "handle %s not found";
    static final String GET_SCHEMA_START_PAST_END = "start_kind must be <= end_kind";
    private final AtomicLong entityId = new AtomicLong(1L);
    private final AtomicLong queryId = new AtomicLong(0L);
    private String backingStore;
    private Map<String, Profile> profiles = Collections.synchronizedMap(new HashMap());
    private static final long MAX_BATCH_GET_KEYS = 1000000000L;
    private static final long MAX_ACTIONS_PER_TXN = 5L;
    private final Map<Long, LiveQuery> liveQueries = Collections.synchronizedMap(new HashMap());
    private final Map<Long, LiveTxn> liveTxns = Collections.synchronizedMap(new HashMap());
    private int maxQueryLifetimeMs;
    private int maxTransactionLifetimeMs;
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(2);
    private final RemoveStaleQueries removeStaleQueriesTask = new RemoveStaleQueries();
    private final RemoveStaleTransactions removeStaleTransactionsTask = new RemoveStaleTransactions();
    private final PersistDatastore persistDatastoreTask = new PersistDatastore();
    private final AtomicInteger transactionHandleProvider = new AtomicInteger(0);
    private int storeDelayMs;
    private boolean dirty;
    private final ReadWriteLock globalLock = new ReentrantReadWriteLock();
    private boolean noStorage;
    private Thread shutdownHook;

    public void clearProfiles() {
        this.profiles.clear();
    }

    public LocalDatastoreService() {
        this.setMaxQueryLifetime(30000);
        this.setMaxTransactionLifetime(30000);
        this.setStoreDelay(30000);
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        String storeFile = properties.get(BACKING_STORE_PROPERTY);
        if (storeFile == null) {
            File dir = GenerationDirectory.getGenerationDirectory((File)context.getAppDir());
            dir.mkdirs();
            storeFile = dir.getAbsolutePath() + File.separator + "local_db.bin";
        }
        this.setBackingStore(storeFile);
        String noStorageProp = properties.get(NO_STORAGE_PROPERTY);
        if (noStorageProp != null) {
            this.noStorage = Boolean.valueOf(noStorageProp);
        }
        String storeDelayTime = properties.get(STORE_DELAY_PROPERTY);
        this.storeDelayMs = LocalDatastoreService.parseInt(storeDelayTime, this.storeDelayMs, STORE_DELAY_PROPERTY);
        String maxQueryLifetime = properties.get(MAX_QUERY_LIFETIME_PROPERTY);
        this.maxQueryLifetimeMs = LocalDatastoreService.parseInt(maxQueryLifetime, this.maxQueryLifetimeMs, MAX_QUERY_LIFETIME_PROPERTY);
        String maxTxnLifetime = properties.get(MAX_TRANSACTION_LIFETIME_PROPERTY);
        this.maxTransactionLifetimeMs = LocalDatastoreService.parseInt(maxTxnLifetime, this.maxTransactionLifetimeMs, MAX_TRANSACTION_LIFETIME_PROPERTY);
        LocalCompositeIndexManager.getInstance().setAppDir(context.getAppDir());
    }

    private static int parseInt(String valStr, int defaultVal, String propName) {
        if (valStr != null) {
            try {
                return Integer.parseInt(valStr);
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARNING, "Expected a numeric value for property " + propName + "but received, " + valStr + ". Resetting property to the default.");
            }
        }
        return defaultVal;
    }

    public void start() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                LocalDatastoreService.this.start_();
                return null;
            }
        });
    }

    private void start_() {
        if (!this.noStorage) {
            this.load();
        }
        this.scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.scheduler.scheduleWithFixedDelay(this.removeStaleQueriesTask, this.maxQueryLifetimeMs * 5, this.maxQueryLifetimeMs * 5, TimeUnit.MILLISECONDS);
        this.scheduler.scheduleWithFixedDelay(this.removeStaleTransactionsTask, this.maxTransactionLifetimeMs * 5, this.maxTransactionLifetimeMs * 5, TimeUnit.MILLISECONDS);
        if (!this.noStorage) {
            this.scheduler.scheduleWithFixedDelay(this.persistDatastoreTask, this.storeDelayMs, this.storeDelayMs, TimeUnit.MILLISECONDS);
        }
        this.shutdownHook = new Thread(){

            public void run() {
                LocalDatastoreService.this.stop();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public void stop() {
        this.scheduler.shutdown();
        if (!this.noStorage) {
            this.persistDatastoreTask.run();
        }
        this.liveQueries.clear();
        this.liveTxns.clear();
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void setMaxQueryLifetime(int milliseconds) {
        this.maxQueryLifetimeMs = milliseconds;
    }

    public void setMaxTransactionLifetime(int milliseconds) {
        this.maxTransactionLifetimeMs = milliseconds;
    }

    public void setBackingStore(String backingStore) {
        this.backingStore = backingStore;
    }

    public void setStoreDelay(int delayMs) {
        this.storeDelayMs = delayMs;
    }

    public void setNoStorage(boolean noStorage) {
        this.noStorage = noStorage;
    }

    public String getPackage() {
        return PACKAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.GetResponse get(LocalRpcService.Status status, DatastorePb.GetRequest request) {
        DatastorePb.GetResponse response = new DatastorePb.GetResponse();
        LiveTxn liveTxn = null;
        for (OnestoreEntity.Reference key : request.keys()) {
            Profile profile;
            String app = key.getApp();
            OnestoreEntity.Path groupPath = this.getGroup(key);
            OnestoreEntity.Path.Element lastPath = (OnestoreEntity.Path.Element)LocalDatastoreService.getLast(key.getPath().elements());
            DatastorePb.GetResponse.Entity group = response.addEntity();
            Profile profile2 = profile = this.getOrCreateProfile(app);
            synchronized (profile2) {
                OnestoreEntity.EntityProto entity;
                Profile.EntityGroup eg = profile.getGroup(groupPath);
                if (request.hasTransaction()) {
                    if (liveTxn == null) {
                        liveTxn = LocalDatastoreService.safeGetFromExpiringMap(this.liveTxns, request.getTransaction().getHandle());
                    }
                    eg.addTransaction(liveTxn);
                }
                if ((entity = eg.get(liveTxn, key)) != null) {
                    group.getMutableEntity().copyFrom((ProtocolMessage)entity);
                }
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.PutResponse put(LocalRpcService.Status status, DatastorePb.PutRequest request) {
        try {
            this.globalLock.readLock().lock();
            DatastorePb.PutResponse putResponse = this.putImpl(status, request);
            return putResponse;
        }
        finally {
            this.globalLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.PutResponse putImpl(LocalRpcService.Status status, DatastorePb.PutRequest request) {
        OnestoreEntity.Reference key;
        DatastorePb.PutResponse response = new DatastorePb.PutResponse();
        ArrayList<OnestoreEntity.EntityProto> clones = new ArrayList<OnestoreEntity.EntityProto>();
        String app = null;
        Profile profile = null;
        LiveTxn liveTxn = null;
        for (OnestoreEntity.EntityProto entity : request.entitys()) {
            this.validateEntityProto(entity);
            OnestoreEntity.EntityProto clone = (OnestoreEntity.EntityProto)entity.clone();
            clones.add(clone);
            assert (clone.hasKey());
            key = clone.getKey();
            assert (key.getPath().elementSize() > 0);
            if (app == null) {
                app = key.getApp();
                profile = this.getOrCreateProfile(app);
            }
            clone.getMutableKey().setApp(app);
            OnestoreEntity.Path.Element lastPath = (OnestoreEntity.Path.Element)LocalDatastoreService.getLast(key.getPath().elements());
            if (!lastPath.hasId() && !lastPath.hasName()) {
                lastPath.setId(this.entityId.getAndIncrement());
            }
            if (clone.getEntityGroup().elementSize() == 0) {
                OnestoreEntity.Path group = clone.getMutableEntityGroup();
                OnestoreEntity.Path.Element root = (OnestoreEntity.Path.Element)key.getPath().elements().get(0);
                OnestoreEntity.Path.Element pathElement = group.addElement();
                pathElement.setType(root.getType());
                if (root.hasName()) {
                    pathElement.setName(root.getName());
                    continue;
                }
                pathElement.setId(root.getId());
                continue;
            }
            assert (clone.hasEntityGroup() && clone.getEntityGroup().elementSize() > 0);
        }
        Profile profile2 = profile;
        synchronized (profile2) {
            for (OnestoreEntity.EntityProto clone : clones) {
                key = clone.getKey();
                String kind = ((OnestoreEntity.Path.Element)LocalDatastoreService.getLast(key.getPath().elements())).getType();
                Extent extent = this.getOrCreateExtent(profile, kind);
                Profile.EntityGroup eg = profile.getGroup(clone.getEntityGroup());
                if (request.hasTransaction()) {
                    if (liveTxn == null) {
                        liveTxn = LocalDatastoreService.safeGetFromExpiringMap(this.liveTxns, request.getTransaction().getHandle());
                    }
                    eg.addTransaction(liveTxn);
                    liveTxn.addWrittenEntity(clone);
                } else {
                    eg.incrementVersion();
                    extent.getEntities().put(key, clone);
                    this.dirty = true;
                }
                response.mutableKeys().add(clone.getKey());
            }
        }
        return response;
    }

    private void validateEntityProto(OnestoreEntity.EntityProto entity) {
        for (OnestoreEntity.Property prop : entity.propertys()) {
            this.validateProperty(prop);
        }
        for (OnestoreEntity.Property prop : entity.rawPropertys()) {
            this.validateProperty(prop);
        }
    }

    private void validateProperty(OnestoreEntity.Property prop) {
        if (RESERVED_NAME.matcher(prop.getName()).matches()) {
            throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.BAD_REQUEST.getValue(), String.format("'%s' matches the pattern for reserved property names and can therefore not be used.", prop.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.DeleteResponse delete(LocalRpcService.Status status, DatastorePb.DeleteRequest request) {
        try {
            this.globalLock.readLock().lock();
            DatastorePb.DeleteResponse deleteResponse = this.deleteImpl(status, request);
            return deleteResponse;
        }
        finally {
            this.globalLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiBasePb.VoidProto addAction(LocalRpcService.Status status, TaskQueuePb.TaskQueueAddRequest request) {
        try {
            this.globalLock.readLock().lock();
            this.addActionImpl(status, request);
        }
        finally {
            this.globalLock.readLock().unlock();
        }
        return new ApiBasePb.VoidProto();
    }

    private OnestoreEntity.Path getGroup(OnestoreEntity.Reference key) {
        OnestoreEntity.Path path = key.getPath();
        OnestoreEntity.Path group = new OnestoreEntity.Path();
        group.addElement(path.getElement(0));
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.DeleteResponse deleteImpl(LocalRpcService.Status status, DatastorePb.DeleteRequest request) {
        LiveTxn liveTxn = null;
        for (OnestoreEntity.Reference key : request.keys()) {
            String app = key.getApp();
            OnestoreEntity.Path group = this.getGroup(key);
            Profile profile = this.getOrCreateProfile(app);
            if (request.hasTransaction()) {
                if (liveTxn == null) {
                    liveTxn = LocalDatastoreService.safeGetFromExpiringMap(this.liveTxns, request.getTransaction().getHandle());
                }
                Profile profile2 = profile;
                synchronized (profile2) {
                    Profile.EntityGroup eg = profile.getGroup(group);
                    eg.addTransaction(liveTxn);
                    liveTxn.addDeletedEntity(key);
                    continue;
                }
            }
            OnestoreEntity.Path.Element lastPath = (OnestoreEntity.Path.Element)LocalDatastoreService.getLast(key.getPath().elements());
            String kind = lastPath.getType();
            Map<String, Extent> extents = profile.getExtents();
            Extent extent = extents.get(kind);
            if (extent == null) continue;
            Profile profile3 = profile;
            synchronized (profile3) {
                Profile.EntityGroup eg = profile.getGroup(group);
                if (extent.getEntities().containsKey(key)) {
                    eg.incrementVersion();
                    extent.getEntities().remove(key);
                    this.dirty = true;
                }
            }
        }
        return new DatastorePb.DeleteResponse();
    }

    private void addActionImpl(LocalRpcService.Status status, TaskQueuePb.TaskQueueAddRequest request) {
        LiveTxn liveTxn = LocalDatastoreService.safeGetFromExpiringMap(this.liveTxns, request.getTransaction().getHandle());
        liveTxn.addAction(((TaskQueuePb.TaskQueueAddRequest)request.clone()).clearTransaction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.QueryResult runQuery(LocalRpcService.Status status, DatastorePb.Query query) {
        int offset;
        Object liveTxn;
        Profile profile;
        final LocalCompositeIndexManager.ValidatedQuery validatedQuery = new LocalCompositeIndexManager.ValidatedQuery(query);
        query = validatedQuery.getQuery();
        String app = query.getApp();
        Profile profile2 = profile = this.getOrCreateProfile(app);
        synchronized (profile2) {
            if (query.hasTransaction()) {
                OnestoreEntity.Path groupPath = this.getGroup(query.getAncestor());
                Profile.EntityGroup eg = profile.getGroup(groupPath);
                liveTxn = LocalDatastoreService.safeGetFromExpiringMap(this.liveTxns, query.getTransaction().getHandle());
                eg.addTransaction((LiveTxn)liveTxn);
            }
        }
        Iterable<Object> queryEntities = null;
        Map<String, Extent> extents = profile.getExtents();
        Extent extent = extents.get(query.getKind());
        if (extent != null) {
            liveTxn = extent;
            synchronized (liveTxn) {
                queryEntities = new ArrayList<OnestoreEntity.EntityProto>(extent.getEntities().values());
            }
        }
        if (queryEntities == null) {
            queryEntities = Collections.emptyList();
        }
        if (query.hasAncestor()) {
            final List ancestorPath = query.getAncestor().getPath().elements();
            queryEntities = Iterables.filter(queryEntities, (Predicate)new Predicate<OnestoreEntity.EntityProto>(){

                public boolean apply(OnestoreEntity.EntityProto entity) {
                    List path = entity.getKey().getPath().elements();
                    return path.size() >= ancestorPath.size() && ((Object)path.subList(0, ancestorPath.size())).equals(ancestorPath);
                }
            });
        }
        ArrayList<OnestoreEntity.EntityProto> filteredResults = new ArrayList<OnestoreEntity.EntityProto>();
        block6: for (OnestoreEntity.EntityProto queryEntity : queryEntities) {
            for (DatastorePb.Query.Filter filter : query.filters()) {
                OnestoreEntity.Property filterProperty = filter.getProperty(0);
                Comparable filterValue = DataTypeTranslator.getComparablePropertyValue((OnestoreEntity.Property)filterProperty);
                assert (filter.getOpEnum() != DatastorePb.Query.Filter.Operator.IN);
                Collection entityProps = DataTypeTranslator.findIndexedPropertiesOnPb((OnestoreEntity.EntityProto)queryEntity, (String)filterProperty.getName());
                if (entityProps.isEmpty()) continue block6;
                boolean atLeastOneValueMatches = false;
                for (OnestoreEntity.Property entityProp : entityProps) {
                    Comparable singleValue = DataTypeTranslator.getComparablePropertyValue((OnestoreEntity.Property)entityProp);
                    if (!this.matches(singleValue, filterValue, filter.getOpEnum())) continue;
                    atLeastOneValueMatches = true;
                    break;
                }
                if (atLeastOneValueMatches) continue;
                continue block6;
            }
            filteredResults.add(queryEntity);
        }
        HashSet<String> orderProperties = new HashSet<String>();
        for (DatastorePb.Query.Order order : query.orders()) {
            orderProperties.add(order.getProperty());
        }
        Iterator protoIt = filteredResults.iterator();
        while (protoIt.hasNext()) {
            OnestoreEntity.EntityProto proto = (OnestoreEntity.EntityProto)protoIt.next();
            HashMap entityProperties = new HashMap();
            DataTypeTranslator.extractIndexedPropertiesFromPb((OnestoreEntity.EntityProto)proto, entityProperties);
            DataTypeTranslator.extractImplicitPropertiesFromPb((OnestoreEntity.EntityProto)proto, entityProperties);
            if (entityProperties.keySet().containsAll(orderProperties)) continue;
            protoIt.remove();
        }
        EntityProtoComparators.EntityProtoComparator sortComparator = new EntityProtoComparators.EntityProtoComparator(validatedQuery.getQuery().orders());
        Collections.sort(filteredResults, sortComparator);
        long cursor = this.queryId.getAndIncrement();
        LiveQuery liveQuery = new LiveQuery(filteredResults, System.currentTimeMillis(), query, orderProperties);
        int n = offset = query.hasStartKey() ? LocalDatastoreService.getQueryOffsetFromStartKey(query, filteredResults, (Comparator<OnestoreEntity.EntityProto>)sortComparator) : 0;
        if (query.hasOffset()) {
            offset += query.getOffset();
        }
        int limit = query.hasLimit() ? query.getLimit() : filteredResults.size();
        liveQuery.offsetAndLimit(offset, limit);
        this.liveQueries.put(cursor, liveQuery);
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                LocalCompositeIndexManager.getInstance().processQuery(validatedQuery.getQuery());
                return null;
            }
        });
        int count = 0;
        count = query.hasCount() ? query.getCount() : (query.hasLimit() ? query.getLimit() : 20);
        DatastorePb.NextRequest nextReq = new DatastorePb.NextRequest();
        nextReq.setCompile(query.isCompile());
        nextReq.getMutableCursor().setCursor(cursor);
        nextReq.setCount(count);
        return this.next(status, nextReq);
    }

    static int getQueryOffsetFromStartKey(DatastorePb.Query query, List<OnestoreEntity.EntityProto> filteredResults, Comparator<OnestoreEntity.EntityProto> sortComparator) {
        int comp;
        OnestoreEntity.EntityProto savedEntity = new OnestoreEntity.EntityProto();
        savedEntity.merge(new ProtocolSource(query.getStartKeyAsBytes()));
        int low = 0;
        int high = filteredResults.size() - 1;
        int mid = (low + high) / 2;
        while (low < high) {
            comp = sortComparator.compare(savedEntity, filteredResults.get(mid));
            if (comp > 0) {
                low = mid + 1;
            } else {
                if (comp >= 0) break;
                high = mid - 1;
            }
            mid = (low + high) / 2;
        }
        if ((comp = sortComparator.compare(savedEntity, filteredResults.get(mid))) > 0 || comp == 0 && !query.isStartInclusive()) {
            ++mid;
        }
        return mid;
    }

    private static <T> T safeGetFromExpiringMap(Map<Long, T> map, long key) {
        T value = map.get(key);
        if (value == null) {
            throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.INTERNAL_ERROR.getValue(), String.format(HANDLE_NOT_FOUND_MESSAGE_FORMAT, key));
        }
        return value;
    }

    public DatastorePb.QueryResult next(LocalRpcService.Status status, DatastorePb.NextRequest request) {
        DatastorePb.QueryResult result = new DatastorePb.QueryResult();
        long cursorId = request.getCursor().getCursor();
        LiveQuery liveQuery = LocalDatastoreService.safeGetFromExpiringMap(this.liveQueries, cursorId);
        int count = request.hasCount() ? request.getCount() : 20;
        int end = Math.min(1000, count);
        for (OnestoreEntity.EntityProto proto : liveQuery.nextResults(end)) {
            result.addResult(proto);
        }
        result.getMutableCursor().setCursor(cursorId);
        result.setMoreResults(liveQuery.sizeRemaining() > 0);
        result.setKeysOnly(liveQuery.isKeysOnly());
        if (request.isCompile()) {
            result.setCompiledQuery(liveQuery.compile());
        }
        return result;
    }

    public ApiBasePb.Integer64Proto count(LocalRpcService.Status status, DatastorePb.Query request) {
        LocalRpcService.Status queryStatus = new LocalRpcService.Status();
        DatastorePb.QueryResult queryResult = this.runQuery(queryStatus, request);
        long cursor = queryResult.getCursor().getCursor();
        int sizeRemaining = LocalDatastoreService.safeGetFromExpiringMap(this.liveQueries, cursor).sizeRemaining();
        this.liveQueries.remove(cursor);
        ApiBasePb.Integer64Proto results = new ApiBasePb.Integer64Proto();
        results.setValue((long)(sizeRemaining + queryResult.resultSize()));
        return results;
    }

    public ApiBasePb.VoidProto deleteCursor(LocalRpcService.Status status, DatastorePb.Cursor request) {
        this.liveQueries.remove(request.getCursor());
        return new ApiBasePb.VoidProto();
    }

    public DatastorePb.QueryExplanation explain(LocalRpcService.Status status, DatastorePb.Query req) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public DatastorePb.Transaction beginTransaction(LocalRpcService.Status status, ApiBasePb.VoidProto req) {
        DatastorePb.Transaction txn = new DatastorePb.Transaction().setHandle((long)this.transactionHandleProvider.getAndIncrement());
        this.liveTxns.put(txn.getHandle(), new LiveTxn(System.currentTimeMillis(), txn.getHandle()));
        return txn;
    }

    private void removeLiveTxn(LiveTxn liveTxn) {
        liveTxn.close();
        this.liveTxns.remove(liveTxn.getHandle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.CommitResponse commit(LocalRpcService.Status status, DatastorePb.Transaction req) {
        final LiveTxn liveTxn = LocalDatastoreService.safeGetFromExpiringMap(this.liveTxns, req.getHandle());
        final Profile profile = this.profiles.get(liveTxn.getApp());
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                LocalDatastoreService.this.removeLiveTxn(liveTxn);
                if (liveTxn.isDirty()) {
                    try {
                        LocalDatastoreService.this.globalLock.readLock().lock();
                        LocalDatastoreService.this.commitImpl(liveTxn, profile);
                    }
                    finally {
                        LocalDatastoreService.this.globalLock.readLock().unlock();
                    }
                }
                for (TaskQueuePb.TaskQueueAddRequest action : liveTxn.getActions()) {
                    try {
                        ApiProxy.makeSyncCall((String)"taskqueue", (String)"Add", (byte[])action.toByteArray());
                    }
                    catch (ApiProxy.ApplicationException e) {
                        logger.log(Level.WARNING, "Transactional task: " + action + " has been dropped.", e);
                    }
                }
            }
        };
        if (profile != null) {
            Profile profile2 = profile;
            synchronized (profile2) {
                runnable.run();
            }
        } else {
            runnable.run();
        }
        return new DatastorePb.CommitResponse();
    }

    private void commitImpl(LiveTxn liveTxn, Profile profile) {
        String kind;
        OnestoreEntity.Path.Element lastPath;
        Profile.EntityGroup eg = liveTxn.getEntityGroup();
        liveTxn.checkEntityGroupVersion();
        eg.incrementVersion();
        for (OnestoreEntity.EntityProto entity : liveTxn.getWrittenEntities()) {
            lastPath = (OnestoreEntity.Path.Element)LocalDatastoreService.getLast(entity.getKey().getPath().elements());
            kind = lastPath.getType();
            Extent extent = this.getOrCreateExtent(profile, kind);
            extent.getEntities().put(entity.getKey(), entity);
        }
        for (OnestoreEntity.Reference key : liveTxn.getDeletedKeys()) {
            lastPath = (OnestoreEntity.Path.Element)LocalDatastoreService.getLast(key.getPath().elements());
            kind = lastPath.getType();
            Map<String, Extent> extents = profile.getExtents();
            Extent extent = extents.get(kind);
            if (extent == null) continue;
            extent.getEntities().remove(key);
        }
        this.dirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiBasePb.VoidProto rollback(LocalRpcService.Status status, DatastorePb.Transaction req) {
        final LiveTxn liveTxn = LocalDatastoreService.safeGetFromExpiringMap(this.liveTxns, req.getHandle());
        Profile profile = this.profiles.get(liveTxn.getApp());
        Runnable runnable = new Runnable(){

            public void run() {
                LocalDatastoreService.this.removeLiveTxn(liveTxn);
            }
        };
        if (profile != null) {
            Profile profile2 = profile;
            synchronized (profile2) {
                runnable.run();
            }
        } else {
            runnable.run();
        }
        return new ApiBasePb.VoidProto();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.Schema getSchema(LocalRpcService.Status status, DatastorePb.GetSchemaRequest req) {
        Map<String, Extent> extents;
        if (req.hasStartKind() && req.hasEndKind()) {
            Preconditions.checkArgument((req.getStartKind().compareTo(req.getEndKind()) <= 0 ? 1 : 0) != 0, (Object)GET_SCHEMA_START_PAST_END);
        }
        DatastorePb.Schema schema = new DatastorePb.Schema();
        Profile profile = this.getOrCreateProfile(req.getApp());
        Map<String, Extent> map = extents = profile.getExtents();
        synchronized (map) {
            for (Map.Entry<String, Extent> entry : extents.entrySet()) {
                String kind = entry.getKey();
                if (req.hasStartKind() && kind.compareTo(req.getStartKind()) < 0 || req.hasEndKind() && kind.compareTo(req.getEndKind()) > 0 || entry.getValue().getEntities().isEmpty()) continue;
                OnestoreEntity.EntityProto allPropsProto = new OnestoreEntity.EntityProto();
                schema.addKind(allPropsProto);
                OnestoreEntity.Path path = new OnestoreEntity.Path();
                path.addElement().setType(kind);
                allPropsProto.setKey(new OnestoreEntity.Reference().setApp(req.getApp()).setPath(path));
                allPropsProto.getMutableEntityGroup();
                if (!req.isProperties()) continue;
                HashMap<String, OnestoreEntity.Property> allProps = new HashMap<String, OnestoreEntity.Property>();
                for (OnestoreEntity.EntityProto entity : entry.getValue().getEntities().values()) {
                    for (OnestoreEntity.Property prop : entity.propertys()) {
                        OnestoreEntity.Property schemaProp = (OnestoreEntity.Property)allProps.get(prop.getName());
                        if (schemaProp == null) {
                            schemaProp = allPropsProto.addProperty().setName(prop.getName()).setMultiple(false);
                            allProps.put(prop.getName(), schemaProp);
                        }
                        PropertyType type = PropertyType.getType((OnestoreEntity.PropertyValue)prop.getValue());
                        schemaProp.getMutableValue().mergeFrom(type.placeholderValue);
                    }
                }
            }
        }
        schema.setMoreResults(false);
        return schema;
    }

    public ApiBasePb.Integer64Proto createIndex(LocalRpcService.Status status, OnestoreEntity.CompositeIndex req) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public ApiBasePb.VoidProto updateIndex(LocalRpcService.Status status, OnestoreEntity.CompositeIndex req) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public DatastorePb.CompositeIndices getIndices(LocalRpcService.Status status, ApiBasePb.StringProto req) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public ApiBasePb.VoidProto deleteIndex(LocalRpcService.Status status, OnestoreEntity.CompositeIndex req) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.AllocateIdsResponse allocateIds(LocalRpcService.Status status, DatastorePb.AllocateIdsRequest req) {
        try {
            this.globalLock.readLock().lock();
            DatastorePb.AllocateIdsResponse allocateIdsResponse = this.allocateIdsImpl(req);
            return allocateIdsResponse;
        }
        finally {
            this.globalLock.readLock().unlock();
        }
    }

    private DatastorePb.AllocateIdsResponse allocateIdsImpl(DatastorePb.AllocateIdsRequest req) {
        if (req.getSize() > 1000000000L) {
            throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.BAD_REQUEST.getValue(), "cannot get more than 1000000000 keys in a single call");
        }
        long start = this.entityId.getAndAdd(req.getSize());
        return new DatastorePb.AllocateIdsResponse().setStart(start).setEnd(start + req.getSize() - 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Profile getOrCreateProfile(String app) {
        Map<String, Profile> map = this.profiles;
        synchronized (map) {
            Profile profile = this.profiles.get(app);
            if (profile == null) {
                profile = new Profile();
                this.profiles.put(app, profile);
            }
            return profile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Extent getOrCreateExtent(Profile profile, String kind) {
        Map<String, Extent> extents;
        Map<String, Extent> map = extents = profile.getExtents();
        synchronized (map) {
            Extent e = extents.get(kind);
            if (e == null) {
                e = new Extent();
                extents.put(kind, e);
            }
            return e;
        }
    }

    private boolean matches(Comparable<Object> value1, Comparable<Object> value2, DatastorePb.Query.Filter.Operator op) {
        switch (op) {
            case EQUAL: {
                return EntityProtoComparators.MULTI_TYPE_COMPARATOR.compare(value1, value2) == 0;
            }
            case GREATER_THAN: {
                return EntityProtoComparators.MULTI_TYPE_COMPARATOR.compare(value1, value2) > 0;
            }
            case GREATER_THAN_OR_EQUAL: {
                return EntityProtoComparators.MULTI_TYPE_COMPARATOR.compare(value1, value2) >= 0;
            }
            case LESS_THAN: {
                return EntityProtoComparators.MULTI_TYPE_COMPARATOR.compare(value1, value2) < 0;
            }
            case LESS_THAN_OR_EQUAL: {
                return EntityProtoComparators.MULTI_TYPE_COMPARATOR.compare(value1, value2) <= 0;
            }
        }
        throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.INTERNAL_ERROR.getValue(), "Unable to perform filter using operator " + op);
    }

    private void load() {
        File backingStoreFile = new File(this.backingStore);
        String path = backingStoreFile.getAbsolutePath();
        if (!backingStoreFile.exists()) {
            logger.log(Level.INFO, "The backing store, " + path + ", does not exist. " + "It will be created.");
            return;
        }
        try {
            Map profilesOnDisk;
            long start = System.currentTimeMillis();
            ObjectInputStream objectIn = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.backingStore)));
            this.entityId.set(objectIn.readLong());
            this.profiles = profilesOnDisk = (Map)objectIn.readObject();
            objectIn.close();
            long end = System.currentTimeMillis();
            logger.log(Level.INFO, "Time to load datastore: " + (end - start) + " ms");
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, "Failed to find the backing store, " + path);
        }
        catch (IOException e) {
            logger.log(Level.INFO, "Failed to load from the backing store, " + path, e);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.INFO, "Failed to load from the backing store, " + path, e);
        }
    }

    private static <T> T getLast(List<T> list) {
        return list.get(list.size() - 1);
    }

    static void pruneHasCreationTimeMap(long now, int maxLifetimeMs, Map<Long, ? extends HasCreationTime> hasCreationTimeMap) {
        long deadline = now - (long)maxLifetimeMs;
        Iterator<Map.Entry<Long, ? extends HasCreationTime>> queryIt = hasCreationTimeMap.entrySet().iterator();
        while (queryIt.hasNext()) {
            Map.Entry<Long, ? extends HasCreationTime> entry = queryIt.next();
            HasCreationTime query = entry.getValue();
            if (query.getCreationTime() >= deadline) continue;
            queryIt.remove();
        }
    }

    void removeStaleQueriesNow() {
        this.removeStaleQueriesTask.run();
    }

    void removeStaleTxnsNow() {
        this.removeStaleTransactionsTask.run();
    }

    private class PersistDatastore
    implements Runnable {
        private PersistDatastore() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                LocalDatastoreService.this.globalLock.writeLock().lock();
                this.privilegedPersist();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Unable to save the datastore", e);
            }
            finally {
                LocalDatastoreService.this.globalLock.writeLock().unlock();
            }
        }

        private void privilegedPersist() throws IOException {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws IOException {
                        PersistDatastore.this.persist();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable t = e.getCause();
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw new RuntimeException(t);
            }
        }

        private void persist() throws IOException {
            if (!LocalDatastoreService.this.dirty) {
                return;
            }
            long start = System.currentTimeMillis();
            ObjectOutputStream objectOut = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(LocalDatastoreService.this.backingStore)));
            objectOut.writeLong(LocalDatastoreService.this.entityId.get());
            objectOut.writeObject(LocalDatastoreService.this.profiles);
            objectOut.close();
            LocalDatastoreService.this.dirty = false;
            long end = System.currentTimeMillis();
            logger.log(Level.INFO, "Time to persist datastore: " + (end - start) + " ms");
        }
    }

    private class RemoveStaleTransactions
    implements Runnable {
        private RemoveStaleTransactions() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = LocalDatastoreService.this.liveTxns;
            synchronized (map) {
                LocalDatastoreService.pruneHasCreationTimeMap(System.currentTimeMillis(), LocalDatastoreService.this.maxTransactionLifetimeMs, LocalDatastoreService.this.liveTxns);
            }
        }
    }

    private class RemoveStaleQueries
    implements Runnable {
        private RemoveStaleQueries() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = LocalDatastoreService.this.liveQueries;
            synchronized (map) {
                LocalDatastoreService.pruneHasCreationTimeMap(System.currentTimeMillis(), LocalDatastoreService.this.maxQueryLifetimeMs, LocalDatastoreService.this.liveQueries);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LiveTxn
    extends HasCreationTime {
        private Profile.EntityGroup entityGroup;
        private Long entityGroupVersion;
        private final Map<OnestoreEntity.Reference, OnestoreEntity.EntityProto> written = new HashMap<OnestoreEntity.Reference, OnestoreEntity.EntityProto>();
        private final Set<OnestoreEntity.Reference> deleted = new HashSet<OnestoreEntity.Reference>();
        private final List<TaskQueuePb.TaskQueueAddRequest> actions = new ArrayList<TaskQueuePb.TaskQueueAddRequest>();
        private final long handle;
        private String app;

        public LiveTxn(long creationTime, long handle) {
            super(creationTime);
            this.handle = handle;
        }

        public synchronized void setEntityGroup(Profile.EntityGroup newEntityGroup) {
            if (newEntityGroup == null) {
                throw new NullPointerException("entityGroup cannot be null");
            }
            if (this.entityGroupVersion == null) {
                this.entityGroupVersion = newEntityGroup.getVersion();
                this.entityGroup = newEntityGroup;
            }
            if (!newEntityGroup.equals(this.entityGroup)) {
                throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.BAD_REQUEST.getValue(), "can't operate on multiple entity groups in a single transaction. found both " + this.entityGroup + " and " + newEntityGroup);
            }
        }

        public synchronized Profile.EntityGroup getEntityGroup() {
            return this.entityGroup;
        }

        public synchronized void checkEntityGroupVersion() {
            if (!this.entityGroupVersion.equals(this.entityGroup.getVersion())) {
                throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.CONCURRENT_TRANSACTION.getValue(), LocalDatastoreService.CONTENTION_MESSAGE);
            }
        }

        public synchronized Long getEntityGroupVersion() {
            return this.entityGroupVersion;
        }

        public synchronized void addWrittenEntity(OnestoreEntity.EntityProto entity) {
            OnestoreEntity.Reference key = entity.getKey();
            this.app = key.getApp();
            this.written.put(key, entity);
            this.deleted.remove(key);
        }

        public synchronized void addDeletedEntity(OnestoreEntity.Reference key) {
            this.app = key.getApp();
            this.deleted.add(key);
            this.written.remove(key);
        }

        public synchronized void addAction(TaskQueuePb.TaskQueueAddRequest action) {
            if ((long)this.actions.size() >= 5L) {
                throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.BAD_REQUEST.getValue(), "Too many messages, maximum allowed: 5");
            }
            this.actions.add(action);
        }

        public synchronized Collection<OnestoreEntity.EntityProto> getWrittenEntities() {
            return new ArrayList<OnestoreEntity.EntityProto>(this.written.values());
        }

        public synchronized Collection<OnestoreEntity.Reference> getDeletedKeys() {
            return new ArrayList<OnestoreEntity.Reference>(this.deleted);
        }

        public synchronized Collection<TaskQueuePb.TaskQueueAddRequest> getActions() {
            return new ArrayList<TaskQueuePb.TaskQueueAddRequest>(this.actions);
        }

        public synchronized String getApp() {
            return this.app;
        }

        public synchronized boolean isDirty() {
            return this.written.size() + this.deleted.size() > 0;
        }

        public synchronized void close() {
            if (this.entityGroup != null) {
                this.entityGroup.removeTransaction(this);
            }
        }

        public long getHandle() {
            return this.handle;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LiveQuery
    extends HasCreationTime {
        private final Set<String> orderProperties;
        private final DatastorePb.Query query;
        private List<OnestoreEntity.EntityProto> entities;
        private OnestoreEntity.EntityProto lastResult = null;
        private int originalSize;

        public LiveQuery(List<OnestoreEntity.EntityProto> entities, long creationTime, DatastorePb.Query query, Set<String> orderProperties) {
            super(creationTime);
            this.orderProperties = orderProperties;
            this.originalSize = entities.size();
            if (entities == null) {
                throw new NullPointerException("entities cannot be null");
            }
            this.query = query;
            this.entities = entities;
        }

        public int sizeRemaining() {
            return this.entities.size();
        }

        public List<OnestoreEntity.EntityProto> nextResults(int end) {
            ArrayList<OnestoreEntity.EntityProto> result;
            List<OnestoreEntity.EntityProto> subList = this.entities.subList(0, Math.min(end, this.entities.size()));
            if (subList.size() > 0) {
                this.lastResult = subList.get(subList.size() - 1);
            }
            if (this.query.isKeysOnly()) {
                result = new ArrayList();
                for (OnestoreEntity.EntityProto entity : subList) {
                    result.add(((OnestoreEntity.EntityProto)entity.clone()).clearOwner().clearProperty().clearRawProperty());
                }
            } else {
                result = new ArrayList<OnestoreEntity.EntityProto>(subList);
            }
            subList.clear();
            return result;
        }

        public void offsetAndLimit(int offset, int limit) {
            int fromIndex = Math.min(offset, this.entities.size());
            int toIndex = Math.min(fromIndex + limit, this.entities.size());
            if (fromIndex > 0) {
                this.lastResult = this.entities.get(fromIndex - 1);
            }
            if (fromIndex != 0 || toIndex != this.entities.size()) {
                this.entities = new ArrayList<OnestoreEntity.EntityProto>(this.entities.subList(fromIndex, toIndex));
            }
            this.originalSize = this.entities.size();
        }

        public boolean isKeysOnly() {
            return this.query.isKeysOnly();
        }

        public DatastorePb.CompiledQuery compile() {
            DatastorePb.CompiledQuery result = new DatastorePb.CompiledQuery();
            DatastorePb.CompiledQuery.PrimaryScan scan = result.getMutablePrimaryScan();
            scan.setIndexNameAsBytes(this.query.toByteArray());
            if (this.lastResult != null) {
                OnestoreEntity.EntityProto savedEntity = new OnestoreEntity.EntityProto();
                savedEntity.getMutableKey().copyFrom((ProtocolMessage)this.lastResult.getKey());
                for (OnestoreEntity.Property prop : this.lastResult.propertys()) {
                    if (!this.orderProperties.contains(prop.getName())) continue;
                    savedEntity.addProperty((OnestoreEntity.Property)new OnestoreEntity.Property().copyFrom((ProtocolMessage)prop));
                }
                scan.setStartKeyAsBytes(savedEntity.toByteArray());
                scan.setStartInclusive(false);
                if (this.query.hasLimit()) {
                    int resultsReturned = this.originalSize - this.entities.size();
                    result.setLimit(this.query.getLimit() - resultsReturned);
                }
            } else {
                if (this.query.hasOffset()) {
                    throw new IllegalStateException();
                }
                if (this.query.hasLimit()) {
                    result.setLimit(this.query.getLimit());
                }
            }
            return result;
        }
    }

    static abstract class HasCreationTime {
        private final long creationTime;

        HasCreationTime(long creationTime) {
            this.creationTime = creationTime;
        }

        long getCreationTime() {
            return this.creationTime;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Extent
    implements Serializable {
        private Map<OnestoreEntity.Reference, OnestoreEntity.EntityProto> entities = new LinkedHashMap<OnestoreEntity.Reference, OnestoreEntity.EntityProto>();

        private Extent() {
        }

        public Map<OnestoreEntity.Reference, OnestoreEntity.EntityProto> getEntities() {
            return this.entities;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Profile
    implements Serializable {
        private final Map<String, Extent> extents = Collections.synchronizedMap(new HashMap());
        private transient Map<OnestoreEntity.Path, EntityGroup> groups;

        private Profile() {
        }

        public Map<String, Extent> getExtents() {
            return this.extents;
        }

        public synchronized EntityGroup getGroup(OnestoreEntity.Path path) {
            EntityGroup group;
            if (this.groups == null) {
                this.groups = new HashMap<OnestoreEntity.Path, EntityGroup>();
            }
            if ((group = this.groups.get(path)) == null) {
                group = new EntityGroup(path);
                this.groups.put(path, group);
            }
            return group;
        }

        private class EntityGroup {
            private final OnestoreEntity.Path path;
            private final AtomicLong version = new AtomicLong();
            private final WeakHashMap<LiveTxn, Profile> snapshots = new WeakHashMap();

            private EntityGroup(OnestoreEntity.Path path) {
                this.path = path;
            }

            public long getVersion() {
                return this.version.get();
            }

            public void incrementVersion() {
                long oldVersion = this.version.getAndIncrement();
                Profile snapshot = null;
                for (LiveTxn txn : this.snapshots.keySet()) {
                    if (txn.getEntityGroupVersion() != oldVersion) continue;
                    if (snapshot == null) {
                        snapshot = this.takeSnapshot();
                    }
                    this.snapshots.put(txn, snapshot);
                }
            }

            public OnestoreEntity.EntityProto get(LiveTxn liveTxn, OnestoreEntity.Reference key) {
                OnestoreEntity.Path.Element lastPath;
                Profile profile = this.getSnapshot(liveTxn);
                Map<String, Extent> extents = profile.getExtents();
                Extent extent = extents.get((lastPath = (OnestoreEntity.Path.Element)LocalDatastoreService.getLast(key.getPath().elements())).getType());
                if (extent != null) {
                    Map<OnestoreEntity.Reference, OnestoreEntity.EntityProto> entities = extent.getEntities();
                    return entities.get(key);
                }
                return null;
            }

            public void addTransaction(LiveTxn txn) {
                txn.setEntityGroup(this);
                if (!this.snapshots.containsKey(txn)) {
                    this.snapshots.put(txn, null);
                }
            }

            public void removeTransaction(LiveTxn txn) {
                this.snapshots.remove(txn);
            }

            private Profile getSnapshot(LiveTxn txn) {
                if (txn == null) {
                    return Profile.this;
                }
                Profile snapshot = this.snapshots.get(txn);
                if (snapshot == null) {
                    return Profile.this;
                }
                return snapshot;
            }

            private Profile takeSnapshot() {
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    oos.writeObject(Profile.this);
                    oos.close();
                    ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
                    ObjectInputStream ois = new ObjectInputStream(bis);
                    return (Profile)ois.readObject();
                }
                catch (IOException ex) {
                    throw new RuntimeException("Unable to take transaction snapshot.", ex);
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException("Unable to take transaction snapshot.", ex);
                }
            }

            public String toString() {
                return this.path.toString();
            }
        }
    }
}

