/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.taskqueue.dev;

import com.google.appengine.api.labs.taskqueue.QueueConstants;
import com.google.appengine.api.labs.taskqueue.TaskQueuePb;
import com.google.appengine.api.labs.taskqueue.dev.DevQueue;
import com.google.appengine.api.labs.taskqueue.dev.QueueStateInfo;
import com.google.appengine.api.labs.taskqueue.dev.UrlFetchJob;
import com.google.appengine.api.urlfetch.dev.LocalURLFetchService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.config.QueueXml;
import com.google.apphosting.utils.config.QueueXmlReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ServiceProvider(value=LocalRpcService.class)
public class LocalTaskQueue
implements LocalRpcService {
    private static final Logger logger = Logger.getLogger(LocalTaskQueue.class.getName());
    static final String SERVER_URL_KEY = "com.google.appengine.server_url_key";
    public static final String PACKAGE = "taskqueue";
    public static final String DISABLE_AUTO_TASK_EXEC_PROP = "task_queue.disable_auto_task_execution";
    private final Map<String, DevQueue> queues = Collections.synchronizedMap(new TreeMap());
    private final AtomicInteger taskNameGenerator = new AtomicInteger(0);
    private QueueXml queueXml;
    private Scheduler scheduler;
    private boolean disableAutoTaskExecution = false;

    public void init(LocalServiceContext context, Map<String, String> properties) {
        QueueXmlReader reader = new QueueXmlReader(context.getAppDir().getPath());
        this.queueXml = reader.readQueueXml();
        logger.log(Level.INFO, "LocalTaskQueue is initialized");
        if (Boolean.valueOf(properties.get(DISABLE_AUTO_TASK_EXEC_PROP)).booleanValue()) {
            this.disableAutoTaskExecution = true;
            logger.log(Level.INFO, "Automatic task execution is disabled.");
        }
    }

    void setQueueXml(QueueXml queueXml) {
        this.queueXml = queueXml;
    }

    public void start() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                LocalTaskQueue.this.start_();
                return null;
            }
        });
    }

    private void start_() {
        Thread shutdownHook = new Thread(){

            public void run() {
                LocalTaskQueue.this.stop();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        LocalURLFetchService fetchService = new LocalURLFetchService();
        fetchService.setTimeoutInMs(30000);
        fetchService.start();
        UrlFetchJob.setFetchService(fetchService);
        this.scheduler = LocalTaskQueue.startScheduler(this.disableAutoTaskExecution);
        if (this.queueXml != null) {
            for (QueueXml.Entry entry : this.queueXml.getEntries()) {
                this.queues.put(entry.getName(), new DevQueue(entry, this.taskNameGenerator, this.scheduler));
            }
        }
        if (this.queues.get("default") == null) {
            QueueXml.Entry entry = QueueXml.defaultEntry();
            this.queues.put(entry.getName(), new DevQueue(entry, this.taskNameGenerator, this.scheduler));
        }
    }

    public void stop() {
        this.queues.clear();
        LocalTaskQueue.stopScheduler(this.scheduler);
        UrlFetchJob.getFetchService().stop();
    }

    public String getPackage() {
        return PACKAGE;
    }

    long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    private long currentTimeUsec() {
        return this.currentTimeMillis() * 1000L;
    }

    void validateAddRequest(TaskQueuePb.TaskQueueAddRequest addRequest) {
        String taskName = addRequest.getTaskName();
        if (taskName != null && taskName.length() != 0 && !QueueConstants.TASK_NAME_PATTERN.matcher(taskName).matches()) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_TASK_NAME.getValue());
        }
        String queueName = addRequest.getQueueName();
        if (queueName == null || queueName.length() == 0 || !QueueConstants.QUEUE_NAME_PATTERN.matcher(queueName).matches()) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_QUEUE_NAME.getValue());
        }
        String url = addRequest.getUrl();
        if (!addRequest.hasUrl() || url.length() == 0 || url.charAt(0) != '/' || url.length() > QueueConstants.maxUrlLength()) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_URL.getValue());
        }
        if (addRequest.getEtaUsec() < 0L) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_ETA.getValue());
        }
        if (addRequest.getEtaUsec() - this.currentTimeUsec() > LocalTaskQueue.getMaxEtaDeltaUsec()) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_ETA.getValue());
        }
    }

    static long getMaxEtaDeltaUsec() {
        return QueueConstants.getMaxEtaDeltaMillis() * 1000L;
    }

    public TaskQueuePb.TaskQueueAddResponse add(LocalRpcService.Status status, TaskQueuePb.TaskQueueAddRequest addRequest) {
        ApiProxy.Environment env = ApiProxy.getCurrentEnvironment();
        String url = (String)env.getAttributes().get(SERVER_URL_KEY);
        if (url == null) {
            throw new IllegalStateException("Current enviornment must have the server url available via the com.google.appengine.server_url_key attribute.");
        }
        this.validateAddRequest(addRequest);
        DevQueue queue = this.getQueueByName(addRequest.getQueueName());
        if (addRequest.hasTransaction()) {
            TaskQueuePb.TaskQueueAddResponse addResponse = new TaskQueuePb.TaskQueueAddResponse();
            if (!addRequest.hasTaskName() || addRequest.getTaskName().equals("")) {
                addRequest = ((TaskQueuePb.TaskQueueAddRequest)addRequest.clone()).setTaskName(queue.genTaskName());
                addResponse.setChosenTaskName(addRequest.getTaskName());
            }
            try {
                ApiProxy.makeSyncCall((String)"datastore_v3", (String)"addAction", (byte[])addRequest.toByteArray());
            }
            catch (ApiProxy.ApplicationException exception) {
                throw new ApiProxy.ApplicationException(exception.getApplicationError() + TaskQueuePb.TaskQueueServiceError.ErrorCode.DATASTORE_ERROR.getValue(), exception.getErrorDetail());
            }
            return addResponse;
        }
        return queue.add(addRequest, url);
    }

    public Map<String, QueueStateInfo> getQueueStateInfo() {
        TreeMap<String, QueueStateInfo> queueStateInfo = new TreeMap<String, QueueStateInfo>();
        for (Map.Entry<String, DevQueue> entry : this.queues.entrySet()) {
            String queueName = entry.getKey();
            queueStateInfo.put(queueName, entry.getValue().getStateInfo());
        }
        return queueStateInfo;
    }

    private DevQueue getQueueByName(String queueName) {
        DevQueue queue = this.queues.get(queueName);
        if (queue == null) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.UNKNOWN_QUEUE.getValue());
        }
        return queue;
    }

    public void flushQueue(String queueName) {
        DevQueue queue = this.getQueueByName(queueName);
        queue.flush();
    }

    public boolean deleteTask(String queueName, String taskName) {
        DevQueue queue = this.getQueueByName(queueName);
        return queue.deleteTask(taskName);
    }

    static Scheduler startScheduler(boolean disableAutoTaskExecution) {
        try {
            Scheduler scheduler = StdSchedulerFactory.getDefaultScheduler();
            if (!disableAutoTaskExecution) {
                scheduler.start();
            }
            return scheduler;
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    static void stopScheduler(Scheduler scheduler) {
        try {
            scheduler.shutdown(false);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean runTask(String queueName, String taskName) {
        DevQueue queue = this.getQueueByName(queueName);
        return queue.runTask(taskName);
    }
}

