/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.taskqueue.dev;

import com.google.appengine.api.labs.taskqueue.TaskQueuePb;
import com.google.appengine.api.labs.taskqueue.dev.UrlFetchJobDetail;
import com.google.appengine.api.urlfetch.URLFetchServicePb;
import com.google.appengine.api.urlfetch.dev.LocalURLFetchService;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.tools.development.LocalRpcService;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class UrlFetchJob
implements Job {
    static final String X_GOOGLE_DEV_APPSERVER_SKIPADMINCHECK = "X-Google-DevAppserver-SkipAdminCheck";
    private static LocalURLFetchService fetchService;

    static URLFetchServicePb.URLFetchRequest.RequestMethod translateRequestMethod(TaskQueuePb.TaskQueueAddRequest.RequestMethod rm) {
        return URLFetchServicePb.URLFetchRequest.RequestMethod.valueOf((String)rm.name());
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        UrlFetchJobDetail jd = (UrlFetchJobDetail)context.getJobDetail();
        URLFetchServicePb.URLFetchRequest fetchReq = this.newFetchRequest(jd.getAddRequest(), jd.getServerUrl());
        this.execute(fetchReq);
    }

    void execute(URLFetchServicePb.URLFetchRequest fetchReq) throws JobExecutionException {
        LocalRpcService.Status status = new LocalRpcService.Status();
        URLFetchServicePb.URLFetchResponse fetchResp = fetchService.fetch(status, fetchReq);
    }

    URLFetchServicePb.URLFetchRequest newFetchRequest(TaskQueuePb.TaskQueueAddRequest addReq, String serverUrl) {
        URLFetchServicePb.URLFetchRequest.Builder requestProto = URLFetchServicePb.URLFetchRequest.newBuilder();
        requestProto.setUrl(serverUrl + addReq.getUrl());
        if (addReq.hasBody()) {
            requestProto.setPayload(ByteString.copyFrom((byte[])addReq.getBodyAsBytes()));
        }
        requestProto.setMethod(UrlFetchJob.translateRequestMethod(addReq.getMethodEnum()));
        for (TaskQueuePb.TaskQueueAddRequest.Header header : addReq.headers()) {
            requestProto.addHeader(this.buildHeader(header.getKey(), header.getValue()));
        }
        requestProto.addHeader(this.buildHeader(X_GOOGLE_DEV_APPSERVER_SKIPADMINCHECK, "true"));
        if (requestProto.getMethod() == URLFetchServicePb.URLFetchRequest.RequestMethod.PUT) {
            requestProto.setFollowRedirects(false);
        }
        return requestProto.build();
    }

    private URLFetchServicePb.URLFetchRequest.Header.Builder buildHeader(String key, String value) {
        URLFetchServicePb.URLFetchRequest.Header.Builder headerProto = URLFetchServicePb.URLFetchRequest.Header.newBuilder();
        headerProto.setKey(key);
        headerProto.setValue(value);
        return headerProto;
    }

    static void setFetchService(LocalURLFetchService fetchService) {
        UrlFetchJob.fetchService = fetchService;
    }

    static LocalURLFetchService getFetchService() {
        return fetchService;
    }
}

