/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.mail.dev;

import com.google.appengine.api.mail.MailService;
import com.google.appengine.api.mail.MailServicePb;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiBasePb;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ServiceProvider(value=LocalRpcService.class)
public class LocalMailService
implements LocalRpcService {
    public static final String PACKAGE = "mail";
    private static final Logger logger = Logger.getLogger(LocalMailService.class.getName());
    public static final String LOG_MAIL_BODY_PROPERTY = "mail.log_mail_body";
    static final boolean DEFAULT_LOG_MAIL_BODY = false;
    public static final String LOG_MAIL_LEVEL_PROPERTY = "mail.log_mail_level";
    static final Level DEFAULT_LOG_MAIL_LEVEL = Level.INFO;
    boolean logMailBody = false;
    Level logMailLevel = DEFAULT_LOG_MAIL_LEVEL;
    private List<MailServicePb.MailMessage> sentMessages = Collections.synchronizedList(new ArrayList());

    public String getPackage() {
        return PACKAGE;
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        String logMailBodyStr = properties.get(LOG_MAIL_BODY_PROPERTY);
        this.logMailBody = logMailBodyStr != null ? Boolean.valueOf(logMailBodyStr) : false;
        String logLevelStr = properties.get(LOG_MAIL_LEVEL_PROPERTY);
        this.logMailLevel = logLevelStr != null ? Level.parse(logLevelStr) : DEFAULT_LOG_MAIL_LEVEL;
    }

    public void start() {
    }

    public void stop() {
        this.sentMessages.clear();
    }

    public ApiBasePb.VoidProto send(LocalRpcService.Status status, MailServicePb.MailMessage msg) {
        this.sentMessages.add(msg);
        this.logMailMessage("send", msg);
        return new ApiBasePb.VoidProto();
    }

    public ApiBasePb.VoidProto sendToAdmins(LocalRpcService.Status status, MailServicePb.MailMessage msg) {
        this.sentMessages.add(msg);
        this.logMailMessage("sendToAdmins", msg);
        return new ApiBasePb.VoidProto();
    }

    void log(String logMsg) {
        logger.log(this.logMailLevel, logMsg);
    }

    void logMailMessage(String method, MailServicePb.MailMessage msg) {
        this.log(String.format("%s.%s", MailService.class.getSimpleName(), method));
        this.log(String.format("  From: %s", msg.getSender()));
        for (String to : msg.tos()) {
            this.log(String.format("  To: %s", to));
        }
        for (String cc : msg.ccs()) {
            this.log(String.format("  Cc: %s", cc));
        }
        for (String bcc : msg.bccs()) {
            this.log(String.format("  Bcc: %s", bcc));
        }
        if (msg.hasReplyTo()) {
            this.log(String.format("  Reply-to: %s", msg.getReplyTo()));
        }
        this.log(String.format("  Subject: %s", msg.getSubject()));
        if (msg.hasTextBody()) {
            this.log("  Body:");
            this.log("    Content-type: text/plain");
            this.log(String.format("    Data length: %d", msg.getTextBody().length()));
            if (this.logMailBody) {
                this.log(String.format("-----\n%s\n-----", msg.getTextBody()));
            }
        }
        if (msg.hasHtmlBody()) {
            this.log("  Body:");
            this.log("    Content-type: text/html");
            this.log(String.format("    Data length: %d", msg.getHtmlBody().length()));
            if (this.logMailBody) {
                this.log(String.format("-----\n%s\n-----", msg.getHtmlBody()));
            }
        }
        for (MailServicePb.MailAttachment attachment : msg.attachments()) {
            this.log("  Attachment:");
            this.log(String.format("    File name: %s", attachment.getFileName()));
            this.log(String.format("    Data length: %d", attachment.getDataAsBytes().length));
        }
    }

    public List<MailServicePb.MailMessage> getSentMessages() {
        return new ArrayList<MailServicePb.MailMessage>(this.sentMessages);
    }

    public void clearSentMessages() {
        this.sentMessages.clear();
    }
}

