/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.util.Localiser;

public final class DatastoreMappingFactory {
    private static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    private static Map mappingConstructors = new HashMap();
    private static final Class[] ctr_args_classes = new Class[]{JavaTypeMapping.class, MappedStoreManager.class, DatastoreField.class};

    private DatastoreMappingFactory() {
    }

    public static DatastoreMapping createMapping(Class mappingClass, JavaTypeMapping mapping, MappedStoreManager storeMgr, DatastoreField column) {
        Object obj = null;
        try {
            Object[] args = new Object[]{mapping, storeMgr, column};
            Constructor ctr = (Constructor)mappingConstructors.get(mappingClass);
            if (ctr == null) {
                ctr = mappingClass.getConstructor(ctr_args_classes);
                mappingConstructors.put(mappingClass, ctr);
            }
            try {
                obj = ctr.newInstance(args);
            }
            catch (InvocationTargetException e) {
                throw new NucleusException(LOCALISER.msg("041009", (Object)mappingClass.getName(), (Object)e.getTargetException()), e.getTargetException()).setFatal();
            }
            catch (Exception e) {
                throw new NucleusException(LOCALISER.msg("041009", (Object)mappingClass.getName(), (Object)e), e).setFatal();
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new NucleusException(LOCALISER.msg("041007", JavaTypeMapping.class, MappedStoreManager.class, DatastoreField.class, (Object)mappingClass.getName())).setFatal();
        }
        return obj;
    }
}

