/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.tools.admin.AppAdminFactory;
import com.google.appengine.tools.admin.LoginReader;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class LoginReaderFactory {
    private static final String PASSWORD_ECHO_WARNING_MAC = "Warning: in Java 1.5, there is no reliable way to prevent your password\nfrom displaying to the screen.  You should consider using the --passin\nargument, and read the password either from a script or file.  Java 1.6\ncan also resolve this, if you are not using GWT.  (Java 1.6 and GWT\nhosted mode have known incompatibilities on Mac OX X.)\n";
    private static final String PASSWORD_ECHO_WARNING_NOTMAC = "Warning: in Java 1.5, there is no reliable way to prevent your password\nfrom displaying to the screen.  You should consider either using the \n--passin argument, and read the password either from a script or file,\nor upgrade to Java 1.6.\n";
    private static final String SWING_DIALOG_WARNING = "Please sign in. If you cannot see the Swing dialog box you should consider using\nthe --passin argument, and read the password either from a script or file.";

    public static LoginReader createLoginReader(AppAdminFactory.ConnectOptions options, boolean passin, String prefsEmail) {
        if (passin) {
            return new PassinReader(options);
        }
        try {
            ConsoleReader reader = new ConsoleReader(options);
            if (reader.hasConsole()) {
                return reader;
            }
        }
        catch (NoSuchMethodError ex) {
            try {
                return new SwingReader(options, prefsEmail);
            }
            catch (Throwable t) {
                System.out.println(System.getProperty("os.name").startsWith("Mac ") ? PASSWORD_ECHO_WARNING_MAC : PASSWORD_ECHO_WARNING_NOTMAC);
            }
        }
        return new SimpleLoginReader(options);
    }

    public static class SwingReader
    implements LoginReader {
        private String email;
        private String password;
        private AppAdminFactory.ConnectOptions options;
        private String prefsEmail;

        public SwingReader(AppAdminFactory.ConnectOptions options, String prefsEmail) {
            if (GraphicsEnvironment.getLocalGraphicsEnvironment().isHeadlessInstance()) {
                throw new RuntimeException("Cannot use SwingReader in headless mode.");
            }
            this.options = options;
            this.prefsEmail = prefsEmail;
        }

        public String getUsername() {
            return this.email;
        }

        public String getPassword() {
            return this.password;
        }

        public void doPrompt() {
            System.out.println(LoginReaderFactory.SWING_DIALOG_WARNING);
            this.email = this.options.getUserId();
            String initialEmail = this.email == null ? this.prefsEmail : this.email;
            final JTextField emailField = new JTextField(initialEmail, 30);
            JPasswordField passwordField = new JPasswordField(30);
            JOptionPane pane = new JOptionPane(new Object[]{new JLabel("Email:"), emailField, new JLabel("Password:"), passwordField}, 3, 2);
            JDialog dialog = pane.createDialog(null, "Please Sign In");
            emailField.addAncestorListener(new AncestorListener(){

                public void ancestorAdded(AncestorEvent event) {
                    emailField.selectAll();
                    emailField.requestFocus();
                }

                public void ancestorMoved(AncestorEvent event) {
                }

                public void ancestorRemoved(AncestorEvent event) {
                }
            });
            dialog.setVisible(true);
            int result = (Integer)pane.getValue();
            dialog.dispose();
            if (result == 2) {
                System.exit(1);
            } else if (result == 0) {
                this.email = emailField.getText();
                this.password = new String(passwordField.getPassword());
            }
        }
    }

    public static class PassinReader
    extends SimpleLoginReader {
        public PassinReader(AppAdminFactory.ConnectOptions options) {
            super(options);
        }

        public void doPrompt() {
            if (this.count == 0) {
                super.doPrompt();
            }
        }
    }

    public static class ConsoleReader
    extends SimpleLoginReader {
        private Console console = System.console();

        public ConsoleReader(AppAdminFactory.ConnectOptions options) {
            super(options);
        }

        protected String promptForUsername(String prompt) {
            return this.console.readLine(prompt, new Object[0]);
        }

        public String promptForPassword(String prompt) {
            return new String(this.console.readPassword(prompt, new Object[0]));
        }

        public boolean hasConsole() {
            return this.console != null;
        }
    }

    public static class SimpleLoginReader
    implements LoginReader {
        protected int count = 0;
        private String email;
        private String password;
        private AppAdminFactory.ConnectOptions options;

        public SimpleLoginReader(AppAdminFactory.ConnectOptions options) {
            this.options = options;
        }

        public void doPrompt() {
            this.email = this.options.getUserId();
            if (this.email == null || this.count > 0) {
                this.email = this.promptForEmail("Email: ");
            }
            this.password = this.promptForPassword("Password for " + this.email + ": ");
            ++this.count;
        }

        protected String promptForEmail(String prompt) {
            return this.prompt(prompt);
        }

        protected String promptForPassword(String prompt) {
            return this.prompt(prompt);
        }

        protected String prompt(String prompt) {
            System.out.print(prompt);
            System.out.flush();
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            try {
                return in.readLine();
            }
            catch (IOException ioe) {
                return null;
            }
        }

        public String getUsername() {
            return this.email;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

