/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlException;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.CronXml;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;

public class CronYamlReader {
    private static final String FILENAME = "cron.yaml";
    private String appDir;

    public CronYamlReader(String appDir) {
        if (appDir.length() > 0 && appDir.charAt(appDir.length() - 1) != File.separatorChar) {
            appDir = appDir + File.separatorChar;
        }
        this.appDir = appDir;
    }

    public String getFilename() {
        return this.appDir + FILENAME;
    }

    public CronXml parse() {
        if (new File(this.getFilename()).exists()) {
            try {
                return CronYamlReader.parse(new FileReader(this.getFilename()));
            }
            catch (FileNotFoundException ex) {
                throw new AppEngineConfigException("Cannot find file " + this.getFilename());
            }
        }
        return null;
    }

    public static CronXml parse(Reader yaml) {
        YamlReader reader = new YamlReader(yaml);
        reader.getConfig().setPropertyElementType(CronYaml.class, "cron", CronXml.Entry.class);
        try {
            CronYaml cronYaml = (CronYaml)reader.read(CronYaml.class);
            if (cronYaml == null) {
                throw new AppEngineConfigException("Empty cron configuration.");
            }
            return cronYaml.toXml();
        }
        catch (YamlException ex) {
            throw new AppEngineConfigException(ex.getMessage());
        }
    }

    public static CronXml parse(String yaml) {
        return CronYamlReader.parse(new StringReader(yaml));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CronYaml {
        private List<CronXml.Entry> entries;

        public List<CronXml.Entry> getCron() {
            return this.entries;
        }

        public void setCron(List<CronXml.Entry> entries) {
            this.entries = entries;
        }

        public CronXml toXml() {
            CronXml xml = new CronXml();
            if (this.entries != null) {
                for (CronXml.Entry entry : this.entries) {
                    xml.addEntry(entry);
                }
            }
            return xml;
        }
    }
}

