/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlException;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.IndexesXml;
import com.google.apphosting.utils.config.YamlUtils;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;

public class IndexYamlReader {
    public static IndexesXml parse(Reader yaml, IndexesXml xml) {
        YamlReader reader = new YamlReader(yaml);
        reader.getConfig().setPropertyElementType(IndexYaml.class, "indexes", IndexYaml.Index.class);
        reader.getConfig().setPropertyElementType(IndexYaml.Index.class, "properties", IndexYaml.Property.class);
        try {
            IndexYaml indexYaml = (IndexYaml)reader.read(IndexYaml.class);
            if (indexYaml == null) {
                throw new AppEngineConfigException("Empty index configuration.");
            }
            return indexYaml.toXml(xml);
        }
        catch (YamlException ex) {
            throw new AppEngineConfigException(ex.getMessage());
        }
    }

    public static IndexesXml parse(String yaml) {
        return IndexYamlReader.parse(new StringReader(yaml), null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IndexYaml {
        private List<Index> indexes;

        public List<Index> getIndexes() {
            return this.indexes;
        }

        public void setIndexes(List<Index> indexes) {
            this.indexes = indexes;
        }

        public IndexesXml toXml(IndexesXml xml) {
            if (this.indexes == null) {
                throw new AppEngineConfigException("Empty index configuration.");
            }
            if (xml == null) {
                xml = new IndexesXml();
            }
            for (Index yamlIndex : this.indexes) {
                if (yamlIndex.kind == null) {
                    throw new AppEngineConfigException("Index missing required element 'kind'");
                }
                IndexesXml.Index xmlIndex = xml.addNewIndex(yamlIndex.kind, yamlIndex.ancestor);
                if (yamlIndex.properties == null) continue;
                for (Property property : yamlIndex.properties) {
                    if (property.name == null) {
                        throw new AppEngineConfigException("Property is missing required element 'name'.");
                    }
                    xmlIndex.addNewProperty(property.name, property.isAscending());
                }
            }
            return xml;
        }

        public static class Property {
            public String name;
            private String direction = "asc";

            public void setDirection(String direction) {
                if (!"desc".equals(direction) && !"asc".equals(direction)) {
                    throw new AppEngineConfigException("Invalid direction '" + direction + "': expected 'asc' or 'desc'.");
                }
                this.direction = direction;
            }

            public String getDirection() {
                return this.direction;
            }

            public boolean isAscending() {
                return "asc".equals(this.direction);
            }
        }

        public static class Index {
            public String kind;
            protected boolean ancestor;
            public List<Property> properties;

            public void setAncestor(String ancestor) {
                this.ancestor = YamlUtils.parseBoolean(ancestor);
            }

            public String getAncestor() {
                return "" + this.ancestor;
            }
        }
    }
}

