/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.base.Equivalence;
import com.google.appengine.repackaged.com.google.common.base.Equivalences;
import com.google.appengine.repackaged.com.google.common.base.FinalizableReferenceQueue;
import com.google.appengine.repackaged.com.google.common.base.FinalizableSoftReference;
import com.google.appengine.repackaged.com.google.common.base.FinalizableWeakReference;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.AbstractMapEntry;
import com.google.appengine.repackaged.com.google.common.collect.ForwardingConcurrentMap;
import com.google.appengine.repackaged.com.google.common.collect.MapMaker;
import com.google.appengine.repackaged.com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CustomConcurrentHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    final transient int segmentMask;
    final transient int segmentShift;
    final transient Segment[] segments;
    final Equivalence<Object> keyEquivalence;
    final Equivalence<Object> valueEquivalence;
    final Strength keyStrength;
    final Strength valueStrength;
    final long expirationNanos;
    final boolean expires;
    final int maximumSize;
    final boolean evicts;
    final int concurrencyLevel;
    final transient EntryFactory entryFactory;
    static final ValueReference<Object, Object> UNSET = new ValueReference<Object, Object>(){

        @Override
        public Object get() {
            return null;
        }

        @Override
        public ValueReference<Object, Object> copyFor(ReferenceEntry<Object, Object> entry) {
            throw new AssertionError();
        }

        @Override
        public Object waitForValue() {
            throw new AssertionError();
        }
    };
    Set<K> keySet;
    Collection<V> values;
    Set<Map.Entry<K, V>> entrySet;
    private static final long serialVersionUID = 2L;

    CustomConcurrentHashMap(MapMaker builder) {
        int segmentSize;
        int segmentCount;
        this.keyStrength = builder.getKeyStrength();
        this.valueStrength = builder.getValueStrength();
        this.keyEquivalence = builder.getKeyEquivalence();
        this.valueEquivalence = builder.getValueEquivalence();
        this.expirationNanos = builder.getExpirationNanos();
        this.maximumSize = builder.maximumSize;
        this.evicts = this.maximumSize != -1;
        this.expires = this.expirationNanos > 0L;
        this.entryFactory = EntryFactory.getFactory(this.keyStrength, this.expires, this.evicts);
        this.concurrencyLevel = CustomConcurrentHashMap.filterConcurrencyLevel(builder.getConcurrencyLevel());
        int initialCapacity = builder.getInitialCapacity();
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        int segmentShift = 0;
        for (segmentCount = 1; segmentCount < this.concurrencyLevel; segmentCount <<= 1) {
            ++segmentShift;
        }
        this.segmentShift = 32 - segmentShift;
        this.segmentMask = segmentCount - 1;
        this.segments = this.newSegmentArray(segmentCount);
        int segmentCapacity = initialCapacity / segmentCount;
        if (segmentCapacity * segmentCount < initialCapacity) {
            ++segmentCapacity;
        }
        for (segmentSize = 1; segmentSize < segmentCapacity; segmentSize <<= 1) {
        }
        if (this.evicts) {
            int maximumSegmentSize = this.maximumSize / segmentCount + 1;
            int remainder = this.maximumSize % segmentCount;
            for (int i = 0; i < this.segments.length; ++i) {
                if (i == remainder) {
                    --maximumSegmentSize;
                }
                this.segments[i] = new Segment(segmentSize, maximumSegmentSize);
            }
        } else {
            for (int i = 0; i < this.segments.length; ++i) {
                this.segments[i] = new Segment(segmentSize, -1);
            }
        }
    }

    static int filterConcurrencyLevel(int concurrenyLevel) {
        return Math.min(concurrenyLevel, 65536);
    }

    private static <K, V> ValueReference<K, V> unset() {
        return UNSET;
    }

    private static int rehash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    void setValueReference(ReferenceEntry<K, V> entry, ValueReference<K, V> valueReference) {
        entry.setValueReference(valueReference);
    }

    @GuardedBy(value="Segment.this")
    ReferenceEntry<K, V> copyEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
        ValueReference<K, V> valueReference = original.getValueReference();
        ReferenceEntry<K, V> newEntry = this.entryFactory.copyEntry(this, original, newNext);
        newEntry.setValueReference(valueReference.copyFor(newEntry));
        return newEntry;
    }

    int hash(Object key) {
        int h = this.keyEquivalence.hash(Preconditions.checkNotNull(key));
        return CustomConcurrentHashMap.rehash(h);
    }

    boolean reclaimValue(ReferenceEntry<K, V> entry) {
        int hash = entry.getHash();
        return this.segmentFor(hash).reclaimValue(entry, hash);
    }

    boolean removeEntry(ReferenceEntry<K, V> entry) {
        int hash = entry.getHash();
        return this.segmentFor(hash).removeEntry(entry, hash);
    }

    @GuardedBy(value="Segment.this")
    static void connectExpirable(Expirable previous, Expirable next) {
        previous.setNextExpirable(next);
        next.setPreviousExpirable(previous);
    }

    @GuardedBy(value="Segment.this")
    static void nullifyExpirable(Expirable nulled) {
        nulled.setNextExpirable(NullExpirable.INSTANCE);
        nulled.setPreviousExpirable(NullExpirable.INSTANCE);
    }

    boolean isExpired(ReferenceEntry<K, V> entry) {
        return this.isExpired((Expirable)((Object)entry), System.nanoTime());
    }

    boolean isExpired(Expirable expirable, long now) {
        return now - expirable.getWriteTime() > this.expirationNanos;
    }

    V getUnexpiredValue(ReferenceEntry<K, V> e) {
        V value = e.getValueReference().get();
        return (V)(this.expires && this.isExpired(e) ? null : value);
    }

    final Segment[] newSegmentArray(int ssize) {
        return (Segment[])Array.newInstance(Segment.class, ssize);
    }

    Segment segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    @Override
    public boolean isEmpty() {
        int i;
        Segment[] segments = this.segments;
        int[] mc = new int[segments.length];
        int mcsum = 0;
        for (i = 0; i < segments.length; ++i) {
            if (segments[i].count != 0) {
                return false;
            }
            mc[i] = segments[i].modCount;
            mcsum += mc[i];
        }
        if (mcsum != 0) {
            for (i = 0; i < segments.length; ++i) {
                if (segments[i].count == 0 && mc[i] == segments[i].modCount) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int size() {
        Segment[] segments = this.segments;
        long sum = 0L;
        long check = 0L;
        int[] mc = new int[segments.length];
        for (int k = 0; k < 2; ++k) {
            int i;
            check = 0L;
            sum = 0L;
            int mcsum = 0;
            for (i = 0; i < segments.length; ++i) {
                sum += (long)segments[i].count;
                mc[i] = segments[i].modCount;
                mcsum += mc[i];
            }
            if (mcsum != 0) {
                for (i = 0; i < segments.length; ++i) {
                    check += (long)segments[i].count;
                    if (mc[i] == segments[i].modCount) continue;
                    check = -1L;
                    break;
                }
            }
            if (check == sum) break;
        }
        if (check != sum) {
            sum = 0L;
            for (Segment segment : segments) {
                segment.lock();
            }
            for (Segment segment : segments) {
                sum += (long)segment.count;
            }
            for (Segment segment : segments) {
                segment.unlock();
            }
        }
        return Ints.saturatedCast(sum);
    }

    @Override
    public V get(Object key) {
        int hash = this.hash(key);
        return this.segmentFor(hash).get(key, hash);
    }

    @Override
    public boolean containsKey(Object key) {
        int hash = this.hash(key);
        return this.segmentFor(hash).containsKey(key, hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        Preconditions.checkNotNull(value, "value");
        Segment[] segments = this.segments;
        int[] mc = new int[segments.length];
        for (int k = 0; k < 2; ++k) {
            int mcsum = 0;
            for (int i = 0; i < segments.length; ++i) {
                int c = segments[i].count;
                mc[i] = segments[i].modCount;
                mcsum += mc[i];
                if (!segments[i].containsValue(value)) continue;
                return true;
            }
            boolean cleanSweep = true;
            if (mcsum != 0) {
                for (int i = 0; i < segments.length; ++i) {
                    int c = segments[i].count;
                    if (mc[i] == segments[i].modCount) continue;
                    cleanSweep = false;
                    break;
                }
            }
            if (!cleanSweep) continue;
            return false;
        }
        for (Segment segment : segments) {
            segment.lock();
        }
        try {
            for (Segment segment : segments) {
                if (!segment.containsValue(value)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            for (Segment segment : segments) {
                segment.unlock();
            }
        }
        return false;
    }

    @Override
    public V put(K key, V value) {
        int hash = this.hash(key);
        return this.segmentFor(hash).put(key, hash, value, false);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        int hash = this.hash(key);
        return this.segmentFor(hash).put(key, hash, value, true);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        int hash = this.hash(key);
        return this.segmentFor(hash).remove(key, hash, this.expires);
    }

    @Override
    public boolean remove(Object key, Object value) {
        int hash = this.hash(key);
        return this.segmentFor(hash).remove(key, hash, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        int hash = this.hash(key);
        return this.segmentFor(hash).replace(key, hash, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        int hash = this.hash(key);
        return this.segmentFor(hash).replace(key, hash, value);
    }

    @Override
    public void clear() {
        for (Segment segment : this.segments) {
            segment.clear();
        }
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    Object writeReplace() {
        return new SerializationProxy(this.keyStrength, this.valueStrength, this.keyEquivalence, this.valueEquivalence, this.expirationNanos, this.maximumSize, this.concurrencyLevel, this);
    }

    static /* synthetic */ ValueReference access$200() {
        return CustomConcurrentHashMap.unset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializationProxy<K, V>
    extends AbstractSerializationProxy<K, V> {
        private static final long serialVersionUID = 0L;

        SerializationProxy(Strength keyStrength, Strength valueStrength, Equivalence<Object> keyEquivalence, Equivalence<Object> valueEquivalence, long expirationNanos, int maximumSize, int concurrencyLevel, ConcurrentMap<K, V> delegate) {
            super(keyStrength, valueStrength, keyEquivalence, valueEquivalence, expirationNanos, maximumSize, concurrencyLevel, delegate);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            this.writeMapTo(out);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            MapMaker mapMaker = this.readMapMaker(in);
            this.delegate = mapMaker.makeMap();
            this.readEntries(in);
        }

        private Object readResolve() {
            return this.delegate;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractSerializationProxy<K, V>
    extends ForwardingConcurrentMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        final Strength keyStrength;
        final Strength valueStrength;
        final Equivalence<Object> keyEquivalence;
        final Equivalence<Object> valueEquivalence;
        final long expirationNanos;
        final int maximumSize;
        final int concurrencyLevel;
        transient ConcurrentMap<K, V> delegate;

        AbstractSerializationProxy(Strength keyStrength, Strength valueStrength, Equivalence<Object> keyEquivalence, Equivalence<Object> valueEquivalence, long expirationNanos, int maximumSize, int concurrencyLevel, ConcurrentMap<K, V> delegate) {
            this.keyStrength = keyStrength;
            this.valueStrength = valueStrength;
            this.keyEquivalence = keyEquivalence;
            this.valueEquivalence = valueEquivalence;
            this.expirationNanos = expirationNanos;
            this.maximumSize = maximumSize;
            this.concurrencyLevel = concurrencyLevel;
            this.delegate = delegate;
        }

        @Override
        protected ConcurrentMap<K, V> delegate() {
            return this.delegate;
        }

        void writeMapTo(ObjectOutputStream out) throws IOException {
            out.writeInt(this.delegate.size());
            for (Map.Entry entry : this.delegate.entrySet()) {
                out.writeObject(entry.getKey());
                out.writeObject(entry.getValue());
            }
            out.writeObject(null);
        }

        MapMaker readMapMaker(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            MapMaker mapMaker = new MapMaker().initialCapacity(size).setKeyStrength(this.keyStrength).setValueStrength(this.valueStrength).privateKeyEquivalence(this.keyEquivalence).privateValueEquivalence(this.valueEquivalence).concurrencyLevel(this.concurrencyLevel);
            if (this.expirationNanos != 0L) {
                mapMaker.expiration(this.expirationNanos, TimeUnit.NANOSECONDS);
            }
            if (this.maximumSize != -1) {
                mapMaker.maximumSize(this.maximumSize);
            }
            return mapMaker;
        }

        void readEntries(ObjectInputStream in) throws IOException, ClassNotFoundException {
            Object key;
            while ((key = in.readObject()) != null) {
                Object value = in.readObject();
                this.delegate.put(key, value);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null) {
                return false;
            }
            Object v = CustomConcurrentHashMap.this.get(key);
            return v != null && CustomConcurrentHashMap.this.valueEquivalence.equivalent(v, e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            return key != null && CustomConcurrentHashMap.this.remove(key, e.getValue());
        }

        @Override
        public int size() {
            return CustomConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CustomConcurrentHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            CustomConcurrentHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return CustomConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CustomConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return CustomConcurrentHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            CustomConcurrentHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return CustomConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CustomConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return CustomConcurrentHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return CustomConcurrentHashMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            CustomConcurrentHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class WriteThroughEntry
    extends AbstractMapEntry<K, V> {
        final K key;
        V value;

        WriteThroughEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry that = (Map.Entry)object;
                return this.key.equals(that.getKey()) && this.value.equals(that.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        @Override
        public V setValue(V newValue) {
            Object oldValue = CustomConcurrentHashMap.this.put(this.key, newValue);
            this.value = newValue;
            return oldValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ValueIterator
    extends HashIterator
    implements Iterator<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeyIterator
    extends HashIterator
    implements Iterator<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        AtomicReferenceArray<ReferenceEntry<K, V>> currentTable;
        ReferenceEntry<K, V> nextEntry;
        WriteThroughEntry nextExternal;
        WriteThroughEntry lastReturned;

        HashIterator() {
            this.nextSegmentIndex = CustomConcurrentHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        final void advance() {
            this.nextExternal = null;
            if (this.nextInChain()) {
                return;
            }
            if (this.nextInTable()) {
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                Segment seg = CustomConcurrentHashMap.this.segments[this.nextSegmentIndex--];
                if (seg.count == 0) continue;
                this.currentTable = seg.table;
                this.nextTableIndex = this.currentTable.length() - 1;
                if (!this.nextInTable()) continue;
                return;
            }
        }

        boolean nextInChain() {
            if (this.nextEntry != null) {
                this.nextEntry = this.nextEntry.getNext();
                while (this.nextEntry != null) {
                    if (this.advanceTo(this.nextEntry)) {
                        return true;
                    }
                    this.nextEntry = this.nextEntry.getNext();
                }
            }
            return false;
        }

        boolean nextInTable() {
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable.get(this.nextTableIndex--)) == null || !this.advanceTo(this.nextEntry) && !this.nextInChain()) continue;
                return true;
            }
            return false;
        }

        boolean advanceTo(ReferenceEntry<K, V> entry) {
            Object key = entry.getKey();
            Object value = CustomConcurrentHashMap.this.getUnexpiredValue(entry);
            if (key != null && value != null) {
                this.nextExternal = new WriteThroughEntry(key, value);
                return true;
            }
            return false;
        }

        public boolean hasNext() {
            return this.nextExternal != null;
        }

        WriteThroughEntry nextEntry() {
            if (this.nextExternal == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextExternal;
            this.advance();
            return this.lastReturned;
        }

        public void remove() {
            Preconditions.checkState(this.lastReturned != null);
            CustomConcurrentHashMap.this.remove(this.lastReturned.getKey());
            this.lastReturned = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Segment
    extends ReentrantLock {
        volatile int count;
        int modCount;
        int threshold;
        volatile AtomicReferenceArray<ReferenceEntry<K, V>> table;
        final int maxSegmentSize;
        final Expirable expirationHead = new Expirable(){
            @GuardedBy(value="Segment.this")
            Expirable next = this;
            @GuardedBy(value="Segment.this")
            Expirable previous = this;

            public long getWriteTime() {
                return Long.MAX_VALUE;
            }

            public void setWriteTime(long writeTime) {
            }

            public Expirable getNextExpirable() {
                return this.next;
            }

            public void setNextExpirable(Expirable next) {
                this.next = next;
            }

            public Expirable getPreviousExpirable() {
                return this.previous;
            }

            public void setPreviousExpirable(Expirable previous) {
                this.previous = previous;
            }
        };

        Segment(int initialCapacity, int maxSegmentSize) {
            this.setTable(this.newEntryArray(initialCapacity));
            this.maxSegmentSize = maxSegmentSize;
        }

        @GuardedBy(value="Segment.this")
        void setValue(ReferenceEntry<K, V> entry, V value, boolean inserted) {
            if (CustomConcurrentHashMap.this.expires) {
                Expirable expirable = (Expirable)((Object)entry);
                this.addExpirable(expirable);
            }
            CustomConcurrentHashMap.this.setValueReference(entry, CustomConcurrentHashMap.this.valueStrength.referenceValue(entry, value));
        }

        @GuardedBy(value="Segment.this")
        void addExpirable(Expirable added) {
            CustomConcurrentHashMap.connectExpirable(added.getPreviousExpirable(), added.getNextExpirable());
            added.setWriteTime(System.nanoTime());
            CustomConcurrentHashMap.connectExpirable(this.expirationHead.getPreviousExpirable(), added);
            CustomConcurrentHashMap.connectExpirable(added, this.expirationHead);
        }

        @GuardedBy(value="Segment.this")
        void removeExpirable(Expirable removed) {
            CustomConcurrentHashMap.connectExpirable(removed.getPreviousExpirable(), removed.getNextExpirable());
            CustomConcurrentHashMap.nullifyExpirable(removed);
        }

        @GuardedBy(value="Segment.this")
        void expireEntries() {
            Expirable expirable = this.expirationHead.getNextExpirable();
            if (expirable == this.expirationHead) {
                return;
            }
            long now = System.nanoTime();
            while (expirable != this.expirationHead && CustomConcurrentHashMap.this.isExpired(expirable, now)) {
                ReferenceEntry entry = (ReferenceEntry)((Object)expirable);
                this.removeEntry(entry, entry.getHash());
                this.removeExpirable(expirable);
                expirable = this.expirationHead.getNextExpirable();
            }
        }

        AtomicReferenceArray<ReferenceEntry<K, V>> newEntryArray(int size) {
            return new AtomicReferenceArray(size);
        }

        @GuardedBy(value="Segment.this")
        void clearExpirationQueue() {
            Expirable expirable = this.expirationHead.getNextExpirable();
            while (expirable != this.expirationHead) {
                Expirable next = expirable.getNextExpirable();
                CustomConcurrentHashMap.nullifyExpirable(expirable);
                expirable = next;
            }
            this.expirationHead.setNextExpirable(this.expirationHead);
            this.expirationHead.setPreviousExpirable(this.expirationHead);
        }

        @GuardedBy(value="Segment.this")
        void setTable(AtomicReferenceArray<ReferenceEntry<K, V>> newTable) {
            this.threshold = newTable.length() * 3 / 4;
            this.table = newTable;
        }

        ReferenceEntry<K, V> getFirst(int hash) {
            AtomicReferenceArray table = this.table;
            return table.get(hash & table.length() - 1);
        }

        public ReferenceEntry<K, V> getEntry(Object key, int hash) {
            if (this.count != 0) {
                for (ReferenceEntry e = this.getFirst(hash); e != null; e = e.getNext()) {
                    Object entryKey;
                    if (e.getHash() != hash || (entryKey = e.getKey()) == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(entryKey, key) || CustomConcurrentHashMap.this.expires && CustomConcurrentHashMap.this.isExpired(e)) continue;
                    return e;
                }
            }
            return null;
        }

        V get(Object key, int hash) {
            ReferenceEntry entry = this.getEntry(key, hash);
            if (entry == null) {
                return null;
            }
            return entry.getValueReference().get();
        }

        boolean containsKey(Object key, int hash) {
            if (this.count != 0) {
                for (ReferenceEntry e = this.getFirst(hash); e != null; e = e.getNext()) {
                    Object entryKey;
                    if (e.getHash() != hash || (entryKey = e.getKey()) == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(entryKey, key)) continue;
                    return CustomConcurrentHashMap.this.getUnexpiredValue(e) != null;
                }
            }
            return false;
        }

        boolean containsValue(Object value) {
            if (this.count != 0) {
                AtomicReferenceArray table = this.table;
                int length = table.length();
                for (int i = 0; i < length; ++i) {
                    for (ReferenceEntry e = table.get(i); e != null; e = e.getNext()) {
                        Object entryValue = CustomConcurrentHashMap.this.getUnexpiredValue(e);
                        if (entryValue == null || !CustomConcurrentHashMap.this.valueEquivalence.equivalent(entryValue, value)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replace(K key, int hash, V oldValue, V newValue) {
            Preconditions.checkNotNull(newValue);
            this.lock();
            try {
                if (CustomConcurrentHashMap.this.expires) {
                    this.expireEntries();
                }
                for (ReferenceEntry e = this.getFirst(hash); e != null; e = e.getNext()) {
                    Object entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(key, entryKey)) continue;
                    Object entryValue = e.getValueReference().get();
                    if (entryValue == null) {
                        boolean bl = false;
                        return bl;
                    }
                    if (!CustomConcurrentHashMap.this.valueEquivalence.equivalent(entryValue, oldValue)) continue;
                    this.setValue(e, newValue, false);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V replace(K key, int hash, V newValue) {
            Preconditions.checkNotNull(newValue);
            this.lock();
            try {
                if (CustomConcurrentHashMap.this.expires) {
                    this.expireEntries();
                }
                for (ReferenceEntry e = this.getFirst(hash); e != null; e = e.getNext()) {
                    Object entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(key, entryKey)) continue;
                    Object entryValue = e.getValueReference().get();
                    if (entryValue == null) {
                        Object v = null;
                        return v;
                    }
                    this.setValue(e, newValue, false);
                    Object v = entryValue;
                    return v;
                }
                Object v = null;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(K key, int hash, V value, boolean onlyIfAbsent) {
            Preconditions.checkNotNull(value);
            this.lock();
            try {
                ReferenceEntry first;
                int newCount;
                if (CustomConcurrentHashMap.this.expires) {
                    this.expireEntries();
                }
                if ((newCount = this.count + 1) > this.threshold) {
                    this.expand();
                }
                AtomicReferenceArray table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry e = first = table.get(index); e != null; e = e.getNext()) {
                    boolean absent;
                    Object entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(key, entryKey)) continue;
                    Object entryValue = e.getValueReference().get();
                    boolean bl = absent = entryValue == null;
                    if (onlyIfAbsent && !absent) {
                        Object v = entryValue;
                        return v;
                    }
                    this.setValue(e, value, absent);
                    Object v = entryValue;
                    return v;
                }
                ++this.modCount;
                ReferenceEntry newEntry = CustomConcurrentHashMap.this.entryFactory.newEntry(CustomConcurrentHashMap.this, key, hash, first);
                this.setValue(newEntry, value, true);
                table.set(index, newEntry);
                this.count = newCount;
                Object v = null;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        @GuardedBy(value="Segment.this")
        void expand() {
            AtomicReferenceArray oldTable = this.table;
            int oldCapacity = oldTable.length();
            if (oldCapacity >= 0x40000000) {
                return;
            }
            AtomicReferenceArray newTable = this.newEntryArray(oldCapacity << 1);
            this.threshold = newTable.length() * 3 / 4;
            int newMask = newTable.length() - 1;
            for (int oldIndex = 0; oldIndex < oldCapacity; ++oldIndex) {
                ReferenceEntry e;
                ReferenceEntry head = oldTable.get(oldIndex);
                if (head == null) continue;
                ReferenceEntry next = head.getNext();
                int headIndex = head.getHash() & newMask;
                if (next == null) {
                    newTable.set(headIndex, head);
                    continue;
                }
                ReferenceEntry tail = head;
                int tailIndex = headIndex;
                for (e = next; e != null; e = e.getNext()) {
                    int newIndex = e.getHash() & newMask;
                    if (newIndex == tailIndex) continue;
                    tailIndex = newIndex;
                    tail = e;
                }
                newTable.set(tailIndex, tail);
                for (e = head; e != tail; e = e.getNext()) {
                    Object key = e.getKey();
                    if (key == null) continue;
                    int newIndex = e.getHash() & newMask;
                    ReferenceEntry newNext = newTable.get(newIndex);
                    newTable.set(newIndex, CustomConcurrentHashMap.this.copyEntry(e, newNext));
                }
            }
            this.table = newTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V remove(Object key, int hash, boolean expire) {
            this.lock();
            try {
                ReferenceEntry first;
                if (expire) {
                    this.expireEntries();
                }
                int newCount = this.count - 1;
                AtomicReferenceArray table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry e = first = table.get(index); e != null; e = e.getNext()) {
                    Object entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(entryKey, key)) continue;
                    Object entryValue = e.getValueReference().get();
                    ++this.modCount;
                    ReferenceEntry newFirst = this.removeFromTable(first, e);
                    table.set(index, newFirst);
                    this.count = newCount;
                    Object v = entryValue;
                    return v;
                }
                Object v = null;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean remove(Object key, int hash, Object value) {
            this.lock();
            try {
                ReferenceEntry first;
                if (CustomConcurrentHashMap.this.expires) {
                    this.expireEntries();
                }
                int newCount = this.count - 1;
                AtomicReferenceArray table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry e = first = table.get(index); e != null; e = e.getNext()) {
                    Object entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(entryKey, key)) continue;
                    Object entryValue = e.getValueReference().get();
                    if (value == entryValue || value != null && entryValue != null && CustomConcurrentHashMap.this.valueEquivalence.equivalent(entryValue, value)) {
                        ++this.modCount;
                        ReferenceEntry newFirst = this.removeFromTable(first, e);
                        table.set(index, newFirst);
                        this.count = newCount;
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean reclaimValue(ReferenceEntry<K, V> entry, int hash) {
            this.lock();
            try {
                ReferenceEntry first;
                int newCount = this.count - 1;
                AtomicReferenceArray table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry e = first = table.get(index); e != null; e = e.getNext()) {
                    if (e != entry) continue;
                    Object entryValue = e.getValueReference().get();
                    if (entryValue == null) {
                        ++this.modCount;
                        ReferenceEntry newFirst = this.removeFromTable(first, e);
                        table.set(index, newFirst);
                        this.count = newCount;
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean removeEntry(ReferenceEntry<K, V> entry, int hash) {
            this.lock();
            try {
                ReferenceEntry first;
                int newCount = this.count - 1;
                AtomicReferenceArray table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry e = first = table.get(index); e != null; e = e.getNext()) {
                    if (e != entry) continue;
                    ++this.modCount;
                    ReferenceEntry newFirst = this.removeFromTable(first, e);
                    table.set(index, newFirst);
                    this.count = newCount;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> removeFromTable(ReferenceEntry<K, V> first, ReferenceEntry<K, V> removed) {
            if (CustomConcurrentHashMap.this.expires) {
                this.removeExpirable((Expirable)((Object)removed));
            }
            ReferenceEntry newFirst = removed.getNext();
            for (ReferenceEntry p = first; p != removed; p = p.getNext()) {
                Object pKey = p.getKey();
                if (pKey == null) continue;
                newFirst = CustomConcurrentHashMap.this.copyEntry(p, newFirst);
            }
            return newFirst;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    AtomicReferenceArray table = this.table;
                    for (int i = 0; i < table.length(); ++i) {
                        table.set(i, null);
                    }
                    this.clearExpirationQueue();
                    ++this.modCount;
                    this.count = 0;
                }
                finally {
                    this.unlock();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StrongValueReference<K, V>
    implements ValueReference<K, V> {
        final V referent;

        StrongValueReference(V referent) {
            this.referent = referent;
        }

        @Override
        public V get() {
            return this.referent;
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceEntry<K, V> entry) {
            return this;
        }

        @Override
        public V waitForValue() {
            return this.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SoftValueReference<K, V>
    extends FinalizableSoftReference<V>
    implements ValueReference<K, V> {
        final ReferenceEntry<K, V> entry;

        SoftValueReference(V referent, ReferenceEntry<K, V> entry) {
            super(referent, QueueHolder.queue);
            this.entry = entry;
        }

        @Override
        public void finalizeReferent() {
            this.entry.valueReclaimed();
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceEntry<K, V> entry) {
            return new SoftValueReference(this.get(), entry);
        }

        @Override
        public V waitForValue() {
            return (V)this.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakValueReference<K, V>
    extends FinalizableWeakReference<V>
    implements ValueReference<K, V> {
        final ReferenceEntry<K, V> entry;

        WeakValueReference(V referent, ReferenceEntry<K, V> entry) {
            super(referent, QueueHolder.queue);
            this.entry = entry;
        }

        @Override
        public void finalizeReferent() {
            this.entry.valueReclaimed();
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceEntry<K, V> entry) {
            return new WeakValueReference(this.get(), entry);
        }

        @Override
        public V waitForValue() {
            return (V)this.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakExpirableEvictableEntry<K, V>
    extends WeakEntry<K, V>
    implements Expirable,
    Evictable {
        volatile long writeTime = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        Expirable next = NullExpirable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Expirable previous = NullExpirable.INSTANCE;
        volatile int lastUsage;

        WeakExpirableEvictableEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, ReferenceEntry<K, V> next) {
            super(map, key, hash, next);
        }

        @Override
        public long getWriteTime() {
            return this.writeTime;
        }

        @Override
        public void setWriteTime(long writeTime) {
            this.writeTime = writeTime;
        }

        @Override
        public Expirable getNextExpirable() {
            return this.next;
        }

        @Override
        public void setNextExpirable(Expirable next) {
            this.next = next;
        }

        @Override
        public Expirable getPreviousExpirable() {
            return this.previous;
        }

        @Override
        public void setPreviousExpirable(Expirable previous) {
            this.previous = previous;
        }

        @Override
        public int getLastUsage() {
            return this.lastUsage;
        }

        @Override
        public void setLastUsage(int lastUsage) {
            this.lastUsage = lastUsage;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakEvictableEntry<K, V>
    extends WeakEntry<K, V>
    implements Evictable {
        volatile int lastUsage;

        WeakEvictableEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, ReferenceEntry<K, V> next) {
            super(map, key, hash, next);
        }

        @Override
        public int getLastUsage() {
            return this.lastUsage;
        }

        @Override
        public void setLastUsage(int lastUsage) {
            this.lastUsage = lastUsage;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakExpirableEntry<K, V>
    extends WeakEntry<K, V>
    implements Expirable {
        volatile long writeTime = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        Expirable next = NullExpirable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Expirable previous = NullExpirable.INSTANCE;

        WeakExpirableEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, ReferenceEntry<K, V> next) {
            super(map, key, hash, next);
        }

        @Override
        public long getWriteTime() {
            return this.writeTime;
        }

        @Override
        public void setWriteTime(long writeTime) {
            this.writeTime = writeTime;
        }

        @Override
        public Expirable getNextExpirable() {
            return this.next;
        }

        @Override
        public void setNextExpirable(Expirable next) {
            this.next = next;
        }

        @Override
        public Expirable getPreviousExpirable() {
            return this.previous;
        }

        @Override
        public void setPreviousExpirable(Expirable previous) {
            this.previous = previous;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakEntry<K, V>
    extends FinalizableWeakReference<K>
    implements ReferenceEntry<K, V> {
        final CustomConcurrentHashMap<K, V> map;
        final int hash;
        final ReferenceEntry<K, V> next;
        volatile ValueReference<K, V> valueReference = CustomConcurrentHashMap.access$200();

        WeakEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, ReferenceEntry<K, V> next) {
            super(key, QueueHolder.queue);
            this.map = map;
            this.hash = hash;
            this.next = next;
        }

        @Override
        public K getKey() {
            return (K)this.get();
        }

        @Override
        public void finalizeReferent() {
            this.map.removeEntry(this);
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            this.valueReference = valueReference;
        }

        @Override
        public void valueReclaimed() {
            this.map.reclaimValue(this);
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SoftExpirableEvictableEntry<K, V>
    extends SoftEntry<K, V>
    implements Expirable,
    Evictable {
        volatile long writeTime = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        Expirable next = NullExpirable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Expirable previous = NullExpirable.INSTANCE;
        volatile int lastUsage;

        SoftExpirableEvictableEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, ReferenceEntry<K, V> next) {
            super(map, key, hash, next);
        }

        @Override
        public long getWriteTime() {
            return this.writeTime;
        }

        @Override
        public void setWriteTime(long writeTime) {
            this.writeTime = writeTime;
        }

        @Override
        public Expirable getNextExpirable() {
            return this.next;
        }

        @Override
        public void setNextExpirable(Expirable next) {
            this.next = next;
        }

        @Override
        public Expirable getPreviousExpirable() {
            return this.previous;
        }

        @Override
        public void setPreviousExpirable(Expirable previous) {
            this.previous = previous;
        }

        @Override
        public int getLastUsage() {
            return this.lastUsage;
        }

        @Override
        public void setLastUsage(int lastUsage) {
            this.lastUsage = lastUsage;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SoftEvictableEntry<K, V>
    extends SoftEntry<K, V>
    implements Evictable {
        volatile int lastUsage;

        SoftEvictableEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, ReferenceEntry<K, V> next) {
            super(map, key, hash, next);
        }

        @Override
        public int getLastUsage() {
            return this.lastUsage;
        }

        @Override
        public void setLastUsage(int lastUsage) {
            this.lastUsage = lastUsage;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SoftExpirableEntry<K, V>
    extends SoftEntry<K, V>
    implements Expirable {
        volatile long writeTime = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        Expirable next = NullExpirable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Expirable previous = NullExpirable.INSTANCE;

        SoftExpirableEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, ReferenceEntry<K, V> next) {
            super(map, key, hash, next);
        }

        @Override
        public long getWriteTime() {
            return this.writeTime;
        }

        @Override
        public void setWriteTime(long writeTime) {
            this.writeTime = writeTime;
        }

        @Override
        public Expirable getNextExpirable() {
            return this.next;
        }

        @Override
        public void setNextExpirable(Expirable next) {
            this.next = next;
        }

        @Override
        public Expirable getPreviousExpirable() {
            return this.previous;
        }

        @Override
        public void setPreviousExpirable(Expirable previous) {
            this.previous = previous;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SoftEntry<K, V>
    extends FinalizableSoftReference<K>
    implements ReferenceEntry<K, V> {
        final CustomConcurrentHashMap<K, V> map;
        final int hash;
        final ReferenceEntry<K, V> next;
        volatile ValueReference<K, V> valueReference = CustomConcurrentHashMap.access$200();

        SoftEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, ReferenceEntry<K, V> next) {
            super(key, QueueHolder.queue);
            this.map = map;
            this.hash = hash;
            this.next = next;
        }

        @Override
        public K getKey() {
            return (K)this.get();
        }

        @Override
        public void finalizeReferent() {
            this.map.removeEntry(this);
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            this.valueReference = valueReference;
        }

        @Override
        public void valueReclaimed() {
            this.map.reclaimValue(this);
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StrongExpirableEvictableEntry<K, V>
    extends StrongEntry<K, V>
    implements Expirable,
    Evictable {
        volatile long writeTime = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        Expirable next = NullExpirable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Expirable previous = NullExpirable.INSTANCE;
        volatile int lastUsage;

        StrongExpirableEvictableEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, ReferenceEntry<K, V> next) {
            super(map, key, hash, next);
        }

        @Override
        public long getWriteTime() {
            return this.writeTime;
        }

        @Override
        public void setWriteTime(long writeTime) {
            this.writeTime = writeTime;
        }

        @Override
        public Expirable getNextExpirable() {
            return this.next;
        }

        @Override
        public void setNextExpirable(Expirable next) {
            this.next = next;
        }

        @Override
        public Expirable getPreviousExpirable() {
            return this.previous;
        }

        @Override
        public void setPreviousExpirable(Expirable previous) {
            this.previous = previous;
        }

        @Override
        public int getLastUsage() {
            return this.lastUsage;
        }

        @Override
        public void setLastUsage(int lastUsage) {
            this.lastUsage = lastUsage;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StrongEvictableEntry<K, V>
    extends StrongEntry<K, V>
    implements Evictable {
        volatile int lastUsage;

        StrongEvictableEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, ReferenceEntry<K, V> next) {
            super(map, key, hash, next);
        }

        @Override
        public int getLastUsage() {
            return this.lastUsage;
        }

        @Override
        public void setLastUsage(int lastUsage) {
            this.lastUsage = lastUsage;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StrongExpirableEntry<K, V>
    extends StrongEntry<K, V>
    implements Expirable {
        volatile long writeTime = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        Expirable next = NullExpirable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Expirable previous = NullExpirable.INSTANCE;

        StrongExpirableEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, ReferenceEntry<K, V> next) {
            super(map, key, hash, next);
        }

        @Override
        public long getWriteTime() {
            return this.writeTime;
        }

        @Override
        public void setWriteTime(long writeTime) {
            this.writeTime = writeTime;
        }

        @Override
        public Expirable getNextExpirable() {
            return this.next;
        }

        @Override
        public void setNextExpirable(Expirable next) {
            this.next = next;
        }

        @Override
        public Expirable getPreviousExpirable() {
            return this.previous;
        }

        @Override
        public void setPreviousExpirable(Expirable previous) {
            this.previous = previous;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StrongEntry<K, V>
    implements ReferenceEntry<K, V> {
        final K key;
        final CustomConcurrentHashMap<K, V> map;
        final int hash;
        final ReferenceEntry<K, V> next;
        volatile ValueReference<K, V> valueReference = CustomConcurrentHashMap.access$200();

        StrongEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, ReferenceEntry<K, V> next) {
            this.map = map;
            this.key = key;
            this.hash = hash;
            this.next = next;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            this.valueReference = valueReference;
        }

        @Override
        public void valueReclaimed() {
            this.map.reclaimValue(this);
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    static interface Evictable {
        public void setLastUsage(int var1);

        public int getLastUsage();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NullExpirable implements Expirable
    {
        INSTANCE;


        @Override
        public long getWriteTime() {
            return 0L;
        }

        @Override
        public void setWriteTime(long writeTime) {
        }

        @Override
        public Expirable getNextExpirable() {
            return this;
        }

        @Override
        public void setNextExpirable(Expirable next) {
        }

        @Override
        public Expirable getPreviousExpirable() {
            return this;
        }

        @Override
        public void setPreviousExpirable(Expirable previous) {
        }
    }

    static interface Expirable {
        public long getWriteTime();

        public void setWriteTime(long var1);

        public Expirable getNextExpirable();

        public void setNextExpirable(Expirable var1);

        public Expirable getPreviousExpirable();

        public void setPreviousExpirable(Expirable var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ReferenceEntry<K, V> {
        public ValueReference<K, V> getValueReference();

        public void setValueReference(ValueReference<K, V> var1);

        public void valueReclaimed();

        public ReferenceEntry<K, V> getNext();

        public int getHash();

        public K getKey();
    }

    private static class QueueHolder {
        static final FinalizableReferenceQueue queue = new FinalizableReferenceQueue();

        private QueueHolder() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ValueReference<K, V> {
        public V get();

        public ValueReference<K, V> copyFor(ReferenceEntry<K, V> var1);

        public V waitForValue() throws InterruptedException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum EntryFactory {
        STRONG{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, ReferenceEntry<K, V> next) {
                return new StrongEntry<K, V>(map, key, hash, next);
            }
        }
        ,
        STRONG_EXPIRABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, ReferenceEntry<K, V> next) {
                return new StrongExpirableEntry<K, V>(map, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(map, original, newNext);
                this.copyExpirableEntry(original, newEntry);
                return newEntry;
            }
        }
        ,
        STRONG_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, ReferenceEntry<K, V> next) {
                return new StrongEvictableEntry<K, V>(map, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(map, original, newNext);
                this.copyEvictableEntry(original, newEntry);
                return newEntry;
            }
        }
        ,
        STRONG_EXPIRABLE_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, ReferenceEntry<K, V> next) {
                return new StrongExpirableEvictableEntry<K, V>(map, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(map, original, newNext);
                this.copyExpirableEntry(original, newEntry);
                this.copyEvictableEntry(original, newEntry);
                return newEntry;
            }
        }
        ,
        SOFT{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, ReferenceEntry<K, V> next) {
                return new SoftEntry<K, V>(map, key, hash, next);
            }
        }
        ,
        SOFT_EXPIRABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, ReferenceEntry<K, V> next) {
                return new SoftExpirableEntry<K, V>(map, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(map, original, newNext);
                this.copyExpirableEntry(original, newEntry);
                return newEntry;
            }
        }
        ,
        SOFT_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, ReferenceEntry<K, V> next) {
                return new SoftEvictableEntry<K, V>(map, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(map, original, newNext);
                this.copyEvictableEntry(original, newEntry);
                return newEntry;
            }
        }
        ,
        SOFT_EXPIRABLE_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, ReferenceEntry<K, V> next) {
                return new SoftExpirableEvictableEntry<K, V>(map, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(map, original, newNext);
                this.copyExpirableEntry(original, newEntry);
                this.copyEvictableEntry(original, newEntry);
                return newEntry;
            }
        }
        ,
        WEAK{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, ReferenceEntry<K, V> next) {
                return new WeakEntry<K, V>(map, key, hash, next);
            }
        }
        ,
        WEAK_EXPIRABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, ReferenceEntry<K, V> next) {
                return new WeakExpirableEntry<K, V>(map, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(map, original, newNext);
                this.copyExpirableEntry(original, newEntry);
                return newEntry;
            }
        }
        ,
        WEAK_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, ReferenceEntry<K, V> next) {
                return new WeakEvictableEntry<K, V>(map, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(map, original, newNext);
                this.copyEvictableEntry(original, newEntry);
                return newEntry;
            }
        }
        ,
        WEAK_EXPIRABLE_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, ReferenceEntry<K, V> next) {
                return new WeakExpirableEvictableEntry<K, V>(map, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(map, original, newNext);
                this.copyExpirableEntry(original, newEntry);
                this.copyEvictableEntry(original, newEntry);
                return newEntry;
            }
        };

        static final int EXPIRABLE_MASK = 1;
        static final int EVICTABLE_MASK = 2;
        static final EntryFactory[][] FACTORIES;

        static EntryFactory getFactory(Strength keyStrength, boolean expires, boolean evicts) {
            int flags = (expires ? 1 : 0) | (evicts ? 2 : 0);
            return FACTORIES[keyStrength.ordinal()][flags];
        }

        abstract <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> var1, K var2, int var3, ReferenceEntry<K, V> var4);

        @GuardedBy(value="Segment.this")
        <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
            return this.newEntry(map, original.getKey(), original.getHash(), newNext);
        }

        @GuardedBy(value="Segment.this")
        <K, V> void copyExpirableEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newEntry) {
            Expirable originalExpirable = (Expirable)((Object)original);
            Expirable newExpirable = (Expirable)((Object)newEntry);
            newExpirable.setWriteTime(originalExpirable.getWriteTime());
            CustomConcurrentHashMap.connectExpirable(originalExpirable.getPreviousExpirable(), newExpirable);
            CustomConcurrentHashMap.connectExpirable(newExpirable, originalExpirable.getNextExpirable());
            CustomConcurrentHashMap.nullifyExpirable(originalExpirable);
        }

        <K, V> void copyEvictableEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newEntry) {
            Evictable originalEvictable = (Evictable)((Object)original);
            Evictable newEvictable = (Evictable)((Object)newEntry);
            newEvictable.setLastUsage(originalEvictable.getLastUsage());
        }

        static {
            FACTORIES = new EntryFactory[][]{{STRONG, STRONG_EXPIRABLE, STRONG_EVICTABLE, STRONG_EXPIRABLE_EVICTABLE}, {SOFT, SOFT_EXPIRABLE, SOFT_EVICTABLE, SOFT_EXPIRABLE_EVICTABLE}, {WEAK, WEAK_EXPIRABLE, WEAK_EVICTABLE, WEAK_EXPIRABLE_EVICTABLE}};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Strength {
        STRONG{

            @Override
            <K, V> ValueReference<K, V> referenceValue(ReferenceEntry<K, V> entry, V value) {
                return new StrongValueReference(value);
            }

            @Override
            Equivalence<Object> defaultEquivalence() {
                return Equivalences.equals();
            }
        }
        ,
        SOFT{

            @Override
            <K, V> ValueReference<K, V> referenceValue(ReferenceEntry<K, V> entry, V value) {
                return new SoftValueReference<K, V>(value, entry);
            }

            @Override
            Equivalence<Object> defaultEquivalence() {
                return Equivalences.identity();
            }
        }
        ,
        WEAK{

            @Override
            <K, V> ValueReference<K, V> referenceValue(ReferenceEntry<K, V> entry, V value) {
                return new WeakValueReference<K, V>(value, entry);
            }

            @Override
            Equivalence<Object> defaultEquivalence() {
                return Equivalences.identity();
            }
        };


        abstract <K, V> ValueReference<K, V> referenceValue(ReferenceEntry<K, V> var1, V var2);

        abstract Equivalence<Object> defaultEquivalence();
    }
}

