/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.cookie;

import java.util.Date;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.cookie.CookieSpec;

public class Cookie2
extends Cookie {
    public static final String DOMAIN = "domain";
    public static final String PATH = "path";
    public static final String PORT = "port";
    public static final String VERSION = "version";
    public static final String SECURE = "secure";
    public static final String MAXAGE = "max-age";
    public static final String COMMENT = "comment";
    public static final String COMMENTURL = "commenturl";
    public static final String DISCARD = "discard";
    private String cookieCommentURL;
    private int[] cookiePorts;
    private boolean discard = false;
    private boolean hasPortAttribute = false;
    private boolean isPortAttributeBlank = false;
    private boolean hasVersionAttribute = false;

    public Cookie2() {
        super(null, "noname", null, null, null, false);
    }

    public Cookie2(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public Cookie2(String string, String string2, String string3, String string4, Date date, boolean bl) {
        super(string, string2, string3, string4, date, bl);
    }

    public Cookie2(String string, String string2, String string3, String string4, Date date, boolean bl, int[] nArray) {
        super(string, string2, string3, string4, date, bl);
        this.setPorts(nArray);
    }

    public String getCommentURL() {
        return this.cookieCommentURL;
    }

    public void setCommentURL(String string) {
        this.cookieCommentURL = string;
    }

    public int[] getPorts() {
        return this.cookiePorts;
    }

    public void setPorts(int[] nArray) {
        this.cookiePorts = nArray;
    }

    public void setDiscard(boolean bl) {
        this.discard = bl;
    }

    public boolean isPersistent() {
        return null != this.getExpiryDate() && !this.discard;
    }

    public void setPortAttributeSpecified(boolean bl) {
        this.hasPortAttribute = bl;
    }

    public boolean isPortAttributeSpecified() {
        return this.hasPortAttribute;
    }

    public void setPortAttributeBlank(boolean bl) {
        this.isPortAttributeBlank = bl;
    }

    public boolean isPortAttributeBlank() {
        return this.isPortAttributeBlank;
    }

    public void setVersionAttributeSpecified(boolean bl) {
        this.hasVersionAttribute = bl;
    }

    public boolean isVersionAttributeSpecified() {
        return this.hasVersionAttribute;
    }

    public String toExternalForm() {
        CookieSpec cookieSpec = CookiePolicy.getCookieSpec("rfc2965");
        return cookieSpec.formatCookie(this);
    }
}

