/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Calendar;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.UnableToInterruptJobException;
import org.quartz.core.ErrorLogger;
import org.quartz.core.ExecutingJobsManager;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.core.QuartzSchedulerThread;
import org.quartz.core.RemotableQuartzScheduler;
import org.quartz.core.SchedulerSignalerImpl;
import org.quartz.core.SchedulingContext;
import org.quartz.impl.SchedulerRepository;
import org.quartz.simpl.SimpleJobFactory;
import org.quartz.spi.JobFactory;
import org.quartz.spi.SchedulerPlugin;
import org.quartz.spi.SchedulerSignaler;

public class QuartzScheduler
implements RemotableQuartzScheduler {
    private static String VERSION_MAJOR = "UNKNOWN";
    private static String VERSION_MINOR = "UNKNOWN";
    private static String VERSION_ITERATION = "UNKNOWN";
    private QuartzSchedulerResources resources;
    private QuartzSchedulerThread schedThread;
    private ThreadGroup threadGroup;
    private SchedulerContext context = new SchedulerContext();
    private HashMap jobListeners = new HashMap(10);
    private ArrayList globalJobListeners = new ArrayList(10);
    private HashMap triggerListeners = new HashMap(10);
    private ArrayList globalTriggerListeners = new ArrayList(10);
    private ArrayList schedulerListeners = new ArrayList(10);
    private ArrayList schedulerPlugins = new ArrayList(10);
    private JobFactory jobFactory = new SimpleJobFactory();
    ExecutingJobsManager jobMgr = null;
    ErrorLogger errLogger = null;
    private SchedulerSignaler signaler;
    private Random random = new Random();
    private ArrayList holdToPreventGC = new ArrayList(5);
    private boolean signalOnSchedulingChange = true;
    private boolean closed = false;
    private Date initialStart = null;
    static /* synthetic */ Class class$org$quartz$core$QuartzScheduler;
    static /* synthetic */ Class class$org$quartz$InterruptableJob;

    public QuartzScheduler(QuartzSchedulerResources resources, SchedulingContext ctxt, long idleWaitTime, long dbRetryInterval) throws SchedulerException {
        this.resources = resources;
        try {
            this.bind();
        }
        catch (Exception re) {
            throw new SchedulerException("Unable to bind scheduler to RMI Registry.", re);
        }
        this.schedThread = new QuartzSchedulerThread(this, resources, ctxt);
        if (idleWaitTime > 0L) {
            this.schedThread.setIdleWaitTime(idleWaitTime);
        }
        if (dbRetryInterval > 0L) {
            this.schedThread.setDbFailureRetryInterval(dbRetryInterval);
        }
        this.jobMgr = new ExecutingJobsManager();
        this.addGlobalJobListener(this.jobMgr);
        this.errLogger = new ErrorLogger();
        this.addSchedulerListener(this.errLogger);
        this.signaler = new SchedulerSignalerImpl(this);
        QuartzScheduler.getLog().info("Quartz Scheduler v." + this.getVersion() + " created.");
    }

    public String getVersion() {
        return QuartzScheduler.getVersionMajor() + "." + QuartzScheduler.getVersionMinor() + "." + QuartzScheduler.getVersionIteration();
    }

    public static String getVersionMajor() {
        return VERSION_MAJOR;
    }

    public static String getVersionMinor() {
        return VERSION_MINOR;
    }

    public static String getVersionIteration() {
        return VERSION_ITERATION;
    }

    public SchedulerSignaler getSchedulerSignaler() {
        return this.signaler;
    }

    public static Log getLog() {
        return LogFactory.getLog(class$org$quartz$core$QuartzScheduler == null ? (class$org$quartz$core$QuartzScheduler = QuartzScheduler.class$("org.quartz.core.QuartzScheduler")) : class$org$quartz$core$QuartzScheduler);
    }

    private void bind() throws RemoteException {
        String host = this.resources.getRMIRegistryHost();
        if (host == null || host.length() == 0) {
            return;
        }
        RemotableQuartzScheduler exportable = null;
        exportable = this.resources.getRMIServerPort() > 0 ? (RemotableQuartzScheduler)UnicastRemoteObject.exportObject((Remote)this, this.resources.getRMIServerPort()) : (RemotableQuartzScheduler)((Object)UnicastRemoteObject.exportObject(this));
        Registry registry = null;
        if (this.resources.getRMICreateRegistryStrategy().equals("as_needed")) {
            try {
                registry = LocateRegistry.getRegistry(this.resources.getRMIRegistryPort());
                registry.list();
            }
            catch (Exception e) {
                registry = LocateRegistry.createRegistry(this.resources.getRMIRegistryPort());
            }
        } else if (this.resources.getRMICreateRegistryStrategy().equals("always")) {
            try {
                registry = LocateRegistry.createRegistry(this.resources.getRMIRegistryPort());
            }
            catch (Exception e) {
                registry = LocateRegistry.getRegistry(this.resources.getRMIRegistryPort());
            }
        } else {
            registry = LocateRegistry.getRegistry(this.resources.getRMIRegistryHost(), this.resources.getRMIRegistryPort());
        }
        registry.rebind(this.resources.getUniqueIdentifier(), exportable);
        QuartzScheduler.getLog().info("Scheduler bound to RMI registry.");
    }

    private void unBind() throws RemoteException {
        String host = this.resources.getRMIRegistryHost();
        if (host == null || host.length() == 0) {
            return;
        }
        Registry registry = LocateRegistry.getRegistry(this.resources.getRMIRegistryHost(), this.resources.getRMIRegistryPort());
        try {
            registry.unbind(this.resources.getUniqueIdentifier());
            UnicastRemoteObject.unexportObject(this, true);
        }
        catch (NotBoundException notBoundException) {
            // empty catch block
        }
        QuartzScheduler.getLog().info("Scheduler un-bound from RMI registry.");
    }

    public String getSchedulerName() {
        return this.resources.getName();
    }

    public String getSchedulerInstanceId() {
        return this.resources.getInstanceId();
    }

    public ThreadGroup getSchedulerThreadGroup() {
        if (this.threadGroup == null) {
            this.threadGroup = new ThreadGroup("QuartzScheduler:" + this.getSchedulerName());
        }
        return this.threadGroup;
    }

    public void addNoGCObject(Object obj) {
        this.holdToPreventGC.add(obj);
    }

    public boolean removeNoGCObject(Object obj) {
        return this.holdToPreventGC.remove(obj);
    }

    public SchedulerContext getSchedulerContext() throws SchedulerException {
        return this.context;
    }

    public boolean isSignalOnSchedulingChange() {
        return this.signalOnSchedulingChange;
    }

    public void setSignalOnSchedulingChange(boolean signalOnSchedulingChange) {
        this.signalOnSchedulingChange = signalOnSchedulingChange;
    }

    public void start() throws SchedulerException {
        if (this.closed) {
            throw new SchedulerException("The Scheduler cannot be restarted after shutdown() has been called.");
        }
        this.schedThread.togglePause(false);
        if (this.initialStart == null) {
            this.initialStart = new Date();
            this.resources.getJobStore().schedulerStarted();
            this.startPlugins();
        }
        QuartzScheduler.getLog().info("Scheduler " + this.resources.getUniqueIdentifier() + " started.");
    }

    public void standby() {
        this.schedThread.togglePause(true);
        QuartzScheduler.getLog().info("Scheduler " + this.resources.getUniqueIdentifier() + " paused.");
    }

    public boolean isInStandbyMode() {
        return this.schedThread.isPaused();
    }

    public Date runningSince() {
        return this.initialStart;
    }

    public int numJobsExecuted() {
        return this.jobMgr.getNumJobsFired();
    }

    public Class getJobStoreClass() {
        return this.resources.getJobStore().getClass();
    }

    public boolean supportsPersistence() {
        return this.resources.getJobStore().supportsPersistence();
    }

    public Class getThreadPoolClass() {
        return this.resources.getThreadPool().getClass();
    }

    public int getThreadPoolSize() {
        return this.resources.getThreadPool().getPoolSize();
    }

    public void shutdown() {
        this.shutdown(false);
    }

    public void shutdown(boolean waitForJobsToComplete) {
        if (this.closed) {
            return;
        }
        QuartzScheduler.getLog().info("Scheduler " + this.resources.getUniqueIdentifier() + " shutting down.");
        this.standby();
        this.closed = true;
        this.schedThread.halt();
        this.resources.getThreadPool().shutdown(waitForJobsToComplete);
        if (waitForJobsToComplete) {
            while (this.jobMgr.getNumJobsCurrentlyExecuting() > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception ignore) {}
            }
        }
        this.resources.getJobStore().shutdown();
        this.notifySchedulerListenersShutdown();
        this.shutdownPlugins();
        SchedulerRepository.getInstance().remove(this.resources.getName());
        this.holdToPreventGC.clear();
        try {
            this.unBind();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        QuartzScheduler.getLog().info("Scheduler " + this.resources.getUniqueIdentifier() + " shutdown complete.");
    }

    public boolean isShutdown() {
        return this.closed;
    }

    public void validateState() throws SchedulerException {
        if (this.isShutdown()) {
            throw new SchedulerException("The Scheduler has been shutdown.");
        }
    }

    public List getCurrentlyExecutingJobs() {
        return this.jobMgr.getExecutingJobs();
    }

    public Date scheduleJob(SchedulingContext ctxt, JobDetail jobDetail, Trigger trigger) throws SchedulerException {
        Date ft;
        this.validateState();
        jobDetail.validate();
        if (trigger.getJobName() == null) {
            trigger.setJobName(jobDetail.getName());
            trigger.setJobGroup(jobDetail.getGroup());
        } else {
            if (trigger.getJobName() != null && !trigger.getJobName().equals(jobDetail.getName())) {
                throw new SchedulerException("Trigger does not reference given job!", 100);
            }
            if (trigger.getJobGroup() != null && !trigger.getJobGroup().equals(jobDetail.getGroup())) {
                throw new SchedulerException("Trigger does not reference given job!", 100);
            }
        }
        trigger.validate();
        Calendar cal = null;
        if (trigger.getCalendarName() != null) {
            cal = this.resources.getJobStore().retrieveCalendar(ctxt, trigger.getCalendarName());
        }
        if ((ft = trigger.computeFirstFireTime(cal)) == null) {
            throw new SchedulerException("Based on configured schedule, the given trigger will never fire.", 100);
        }
        this.resources.getJobStore().storeJobAndTrigger(ctxt, jobDetail, trigger);
        this.notifySchedulerThread();
        this.notifySchedulerListenersSchduled(trigger);
        return ft;
    }

    public Date scheduleJob(SchedulingContext ctxt, Trigger trigger) throws SchedulerException {
        this.validateState();
        trigger.validate();
        Calendar cal = null;
        if (trigger.getCalendarName() != null && (cal = this.resources.getJobStore().retrieveCalendar(ctxt, trigger.getCalendarName())) == null) {
            throw new SchedulerException("Calendar not found: " + trigger.getCalendarName(), 420);
        }
        Date ft = trigger.computeFirstFireTime(cal);
        if (ft == null) {
            throw new SchedulerException("Based on configured schedule, the given trigger will never fire.", 100);
        }
        this.resources.getJobStore().storeTrigger(ctxt, trigger, false);
        this.notifySchedulerThread();
        this.notifySchedulerListenersSchduled(trigger);
        return ft;
    }

    public void addJob(SchedulingContext ctxt, JobDetail jobDetail, boolean replace) throws SchedulerException {
        this.validateState();
        if (!jobDetail.isDurable() && !replace) {
            throw new SchedulerException("Jobs added with no trigger must be durable.", 100);
        }
        this.resources.getJobStore().storeJob(ctxt, jobDetail, replace);
    }

    public boolean deleteJob(SchedulingContext ctxt, String jobName, String groupName) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        return this.resources.getJobStore().removeJob(ctxt, jobName, groupName);
    }

    public boolean unscheduleJob(SchedulingContext ctxt, String triggerName, String groupName) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        if (!this.resources.getJobStore().removeTrigger(ctxt, triggerName, groupName)) {
            return false;
        }
        this.notifySchedulerThread();
        this.notifySchedulerListenersUnschduled(triggerName, groupName);
        return true;
    }

    public Date rescheduleJob(SchedulingContext ctxt, String triggerName, String groupName, Trigger newTrigger) throws SchedulerException {
        Date ft;
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        newTrigger.validate();
        Calendar cal = null;
        if (newTrigger.getCalendarName() != null) {
            cal = this.resources.getJobStore().retrieveCalendar(ctxt, newTrigger.getCalendarName());
        }
        if ((ft = newTrigger.computeFirstFireTime(cal)) == null) {
            throw new SchedulerException("Based on configured schedule, the given trigger will never fire.", 100);
        }
        if (!this.resources.getJobStore().replaceTrigger(ctxt, triggerName, groupName, newTrigger)) {
            return null;
        }
        this.notifySchedulerThread();
        this.notifySchedulerListenersUnschduled(triggerName, groupName);
        this.notifySchedulerListenersSchduled(newTrigger);
        return ft;
    }

    private String newTriggerId() {
        long r = this.random.nextLong();
        if (r < 0L) {
            r = -r;
        }
        return "MT_" + Long.toString(r, 30 + (int)(System.currentTimeMillis() % 7L));
    }

    public void triggerJob(SchedulingContext ctxt, String jobName, String groupName, JobDataMap data) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        SimpleTrigger trig = new SimpleTrigger(this.newTriggerId(), "MANUAL_TRIGGER", jobName, groupName, new Date(), null, 0, 0L);
        trig.setVolatility(false);
        ((Trigger)trig).computeFirstFireTime(null);
        if (data != null) {
            trig.setJobDataMap(data);
        }
        boolean collision = true;
        while (collision) {
            try {
                this.resources.getJobStore().storeTrigger(ctxt, trig, false);
                collision = false;
            }
            catch (ObjectAlreadyExistsException oaee) {
                trig.setName(this.newTriggerId());
            }
        }
        this.notifySchedulerThread();
        this.notifySchedulerListenersSchduled(trig);
    }

    public void triggerJobWithVolatileTrigger(SchedulingContext ctxt, String jobName, String groupName, JobDataMap data) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        SimpleTrigger trig = new SimpleTrigger(this.newTriggerId(), "MANUAL_TRIGGER", jobName, groupName, new Date(), null, 0, 0L);
        trig.setVolatility(true);
        ((Trigger)trig).computeFirstFireTime(null);
        if (data != null) {
            trig.setJobDataMap(data);
        }
        boolean collision = true;
        while (collision) {
            try {
                this.resources.getJobStore().storeTrigger(ctxt, trig, false);
                collision = false;
            }
            catch (ObjectAlreadyExistsException oaee) {
                trig.setName(this.newTriggerId());
            }
        }
        this.notifySchedulerThread();
        this.notifySchedulerListenersSchduled(trig);
    }

    public void pauseTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        this.resources.getJobStore().pauseTrigger(ctxt, triggerName, groupName);
        this.notifySchedulerThread();
        this.notifySchedulerListenersPausedTrigger(triggerName, groupName);
    }

    public void pauseTriggerGroup(SchedulingContext ctxt, String groupName) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        this.resources.getJobStore().pauseTriggerGroup(ctxt, groupName);
        this.notifySchedulerThread();
        this.notifySchedulerListenersPausedTrigger(null, groupName);
    }

    public void pauseJob(SchedulingContext ctxt, String jobName, String groupName) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        this.resources.getJobStore().pauseJob(ctxt, jobName, groupName);
        this.notifySchedulerThread();
        this.notifySchedulerListenersPausedJob(jobName, groupName);
    }

    public void pauseJobGroup(SchedulingContext ctxt, String groupName) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        this.resources.getJobStore().pauseJobGroup(ctxt, groupName);
        this.notifySchedulerThread();
        this.notifySchedulerListenersPausedJob(null, groupName);
    }

    public void resumeTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        this.resources.getJobStore().resumeTrigger(ctxt, triggerName, groupName);
        this.notifySchedulerThread();
        this.notifySchedulerListenersResumedTrigger(triggerName, groupName);
    }

    public void resumeTriggerGroup(SchedulingContext ctxt, String groupName) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        this.resources.getJobStore().resumeTriggerGroup(ctxt, groupName);
        this.notifySchedulerThread();
        this.notifySchedulerListenersResumedTrigger(null, groupName);
    }

    public Set getPausedTriggerGroups(SchedulingContext ctxt) throws SchedulerException {
        return this.resources.getJobStore().getPausedTriggerGroups(ctxt);
    }

    public void resumeJob(SchedulingContext ctxt, String jobName, String groupName) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        this.resources.getJobStore().resumeJob(ctxt, jobName, groupName);
        this.notifySchedulerThread();
        this.notifySchedulerListenersResumedJob(jobName, groupName);
    }

    public void resumeJobGroup(SchedulingContext ctxt, String groupName) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        this.resources.getJobStore().resumeJobGroup(ctxt, groupName);
        this.notifySchedulerThread();
        this.notifySchedulerListenersResumedJob(null, groupName);
    }

    public void pauseAll(SchedulingContext ctxt) throws SchedulerException {
        this.validateState();
        this.resources.getJobStore().pauseAll(ctxt);
        this.notifySchedulerThread();
        this.notifySchedulerListenersPausedTrigger(null, null);
    }

    public void resumeAll(SchedulingContext ctxt) throws SchedulerException {
        this.validateState();
        this.resources.getJobStore().resumeAll(ctxt);
        this.notifySchedulerThread();
        this.notifySchedulerListenersResumedTrigger(null, null);
    }

    public String[] getJobGroupNames(SchedulingContext ctxt) throws SchedulerException {
        this.validateState();
        return this.resources.getJobStore().getJobGroupNames(ctxt);
    }

    public String[] getJobNames(SchedulingContext ctxt, String groupName) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        return this.resources.getJobStore().getJobNames(ctxt, groupName);
    }

    public Trigger[] getTriggersOfJob(SchedulingContext ctxt, String jobName, String groupName) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        return this.resources.getJobStore().getTriggersForJob(ctxt, jobName, groupName);
    }

    public String[] getTriggerGroupNames(SchedulingContext ctxt) throws SchedulerException {
        this.validateState();
        return this.resources.getJobStore().getTriggerGroupNames(ctxt);
    }

    public String[] getTriggerNames(SchedulingContext ctxt, String groupName) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        return this.resources.getJobStore().getTriggerNames(ctxt, groupName);
    }

    public JobDetail getJobDetail(SchedulingContext ctxt, String jobName, String jobGroup) throws SchedulerException {
        this.validateState();
        if (jobGroup == null) {
            jobGroup = "DEFAULT";
        }
        return this.resources.getJobStore().retrieveJob(ctxt, jobName, jobGroup);
    }

    public Trigger getTrigger(SchedulingContext ctxt, String triggerName, String triggerGroup) throws SchedulerException {
        this.validateState();
        if (triggerGroup == null) {
            triggerGroup = "DEFAULT";
        }
        return this.resources.getJobStore().retrieveTrigger(ctxt, triggerName, triggerGroup);
    }

    public int getTriggerState(SchedulingContext ctxt, String triggerName, String triggerGroup) throws SchedulerException {
        this.validateState();
        if (triggerGroup == null) {
            triggerGroup = "DEFAULT";
        }
        return this.resources.getJobStore().getTriggerState(ctxt, triggerName, triggerGroup);
    }

    public void addCalendar(SchedulingContext ctxt, String calName, Calendar calendar, boolean replace, boolean updateTriggers) throws SchedulerException {
        this.validateState();
        this.resources.getJobStore().storeCalendar(ctxt, calName, calendar, replace, updateTriggers);
    }

    public boolean deleteCalendar(SchedulingContext ctxt, String calName) throws SchedulerException {
        this.validateState();
        return this.resources.getJobStore().removeCalendar(ctxt, calName);
    }

    public Calendar getCalendar(SchedulingContext ctxt, String calName) throws SchedulerException {
        this.validateState();
        return this.resources.getJobStore().retrieveCalendar(ctxt, calName);
    }

    public String[] getCalendarNames(SchedulingContext ctxt) throws SchedulerException {
        this.validateState();
        return this.resources.getJobStore().getCalendarNames(ctxt);
    }

    public void addGlobalJobListener(JobListener jobListener) {
        if (jobListener.getName() == null || jobListener.getName().length() == 0) {
            throw new IllegalArgumentException("JobListener name cannot be empty.");
        }
        this.globalJobListeners.add(jobListener);
    }

    public void addJobListener(JobListener jobListener) {
        if (jobListener.getName() == null || jobListener.getName().length() == 0) {
            throw new IllegalArgumentException("JobListener name cannot be empty.");
        }
        this.jobListeners.put(jobListener.getName(), jobListener);
    }

    public boolean removeGlobalJobListener(JobListener jobListener) {
        return this.globalJobListeners.remove(jobListener);
    }

    public boolean removeJobListener(String name) {
        Object o = this.jobListeners.remove(name);
        return o != null;
    }

    public List getGlobalJobListeners() {
        return new LinkedList(this.globalJobListeners);
    }

    public Set getJobListenerNames() {
        return Collections.unmodifiableSet(this.jobListeners.keySet());
    }

    public JobListener getJobListener(String name) {
        return (JobListener)this.jobListeners.get(name);
    }

    public void addGlobalTriggerListener(TriggerListener triggerListener) {
        if (triggerListener.getName() == null || triggerListener.getName().length() == 0) {
            throw new IllegalArgumentException("TriggerListener name cannot be empty.");
        }
        this.globalTriggerListeners.add(triggerListener);
    }

    public void addTriggerListener(TriggerListener triggerListener) {
        if (triggerListener.getName() == null || triggerListener.getName().length() == 0) {
            throw new IllegalArgumentException("TriggerListener name cannot be empty.");
        }
        this.triggerListeners.put(triggerListener.getName(), triggerListener);
    }

    public boolean removeGlobalTriggerListener(TriggerListener triggerListener) {
        return this.globalTriggerListeners.remove(triggerListener);
    }

    public boolean removeTriggerListener(String name) {
        Object o = this.triggerListeners.remove(name);
        return o != null;
    }

    public List getGlobalTriggerListeners() {
        return new LinkedList(this.globalTriggerListeners);
    }

    public Set getTriggerListenerNames() {
        return Collections.unmodifiableSet(this.triggerListeners.keySet());
    }

    public TriggerListener getTriggerListener(String name) {
        return (TriggerListener)this.triggerListeners.get(name);
    }

    public void addSchedulerListener(SchedulerListener schedulerListener) {
        this.schedulerListeners.add(schedulerListener);
    }

    public boolean removeSchedulerListener(SchedulerListener schedulerListener) {
        return this.schedulerListeners.remove(schedulerListener);
    }

    public List getSchedulerListeners() {
        return (List)this.schedulerListeners.clone();
    }

    protected void notifyJobStoreJobComplete(SchedulingContext ctxt, Trigger trigger, JobDetail detail, int instCode) throws JobPersistenceException {
        this.resources.getJobStore().triggeredJobComplete(ctxt, trigger, detail, instCode);
    }

    protected void notifySchedulerThread() {
        if (this.isSignalOnSchedulingChange()) {
            this.schedThread.signalSchedulingChange();
        }
    }

    private List buildTriggerListenerList(String[] additionalLstnrs) throws SchedulerException {
        List triggerListeners = this.getGlobalTriggerListeners();
        for (int i = 0; i < additionalLstnrs.length; ++i) {
            TriggerListener tl = this.getTriggerListener(additionalLstnrs[i]);
            if (tl == null) {
                throw new SchedulerException("TriggerListener '" + additionalLstnrs[i] + "' not found.", 710);
            }
            triggerListeners.add(tl);
        }
        return triggerListeners;
    }

    private List buildJobListenerList(String[] additionalLstnrs) throws SchedulerException {
        List jobListeners = this.getGlobalJobListeners();
        for (int i = 0; i < additionalLstnrs.length; ++i) {
            JobListener jl = this.getJobListener(additionalLstnrs[i]);
            if (jl == null) {
                throw new SchedulerException("JobListener '" + additionalLstnrs[i] + "' not found.", 610);
            }
            jobListeners.add(jl);
        }
        return jobListeners;
    }

    public boolean notifyTriggerListenersFired(JobExecutionContext jec) throws SchedulerException {
        List triggerListeners = this.buildTriggerListenerList(jec.getTrigger().getTriggerListenerNames());
        boolean vetoedExecution = false;
        Iterator itr = triggerListeners.iterator();
        while (itr.hasNext()) {
            TriggerListener tl = (TriggerListener)itr.next();
            try {
                tl.triggerFired(jec.getTrigger(), jec);
                if (!tl.vetoJobExecution(jec.getTrigger(), jec)) continue;
                vetoedExecution = true;
            }
            catch (Exception e) {
                SchedulerException se = new SchedulerException("TriggerListener '" + tl.getName() + "' threw exception: " + e.getMessage(), e);
                se.setErrorCode(700);
                throw se;
            }
        }
        return vetoedExecution;
    }

    public void notifyTriggerListenersMisfired(Trigger trigger) throws SchedulerException {
        List triggerListeners = this.buildTriggerListenerList(trigger.getTriggerListenerNames());
        Iterator itr = triggerListeners.iterator();
        while (itr.hasNext()) {
            TriggerListener tl = (TriggerListener)itr.next();
            try {
                tl.triggerMisfired(trigger);
            }
            catch (Exception e) {
                SchedulerException se = new SchedulerException("TriggerListener '" + tl.getName() + "' threw exception: " + e.getMessage(), e);
                se.setErrorCode(700);
                throw se;
            }
        }
    }

    public void notifyTriggerListenersComplete(JobExecutionContext jec, int instCode) throws SchedulerException {
        List triggerListeners = this.buildTriggerListenerList(jec.getTrigger().getTriggerListenerNames());
        Iterator itr = triggerListeners.iterator();
        while (itr.hasNext()) {
            TriggerListener tl = (TriggerListener)itr.next();
            try {
                tl.triggerComplete(jec.getTrigger(), jec, instCode);
            }
            catch (Exception e) {
                SchedulerException se = new SchedulerException("TriggerListener '" + tl.getName() + "' threw exception: " + e.getMessage(), e);
                se.setErrorCode(700);
                throw se;
            }
        }
    }

    public void notifyJobListenersToBeExecuted(JobExecutionContext jec) throws SchedulerException {
        List jobListeners = this.buildJobListenerList(jec.getJobDetail().getJobListenerNames());
        Iterator itr = jobListeners.iterator();
        while (itr.hasNext()) {
            JobListener jl = (JobListener)itr.next();
            try {
                jl.jobToBeExecuted(jec);
            }
            catch (Exception e) {
                SchedulerException se = new SchedulerException("JobListener '" + jl.getName() + "' threw exception: " + e.getMessage(), e);
                se.setErrorCode(600);
                throw se;
            }
        }
    }

    public void notifyJobListenersWasVetoed(JobExecutionContext jec) throws SchedulerException {
        List jobListeners = this.buildJobListenerList(jec.getJobDetail().getJobListenerNames());
        Iterator itr = jobListeners.iterator();
        while (itr.hasNext()) {
            JobListener jl = (JobListener)itr.next();
            try {
                jl.jobExecutionVetoed(jec);
            }
            catch (Exception e) {
                SchedulerException se = new SchedulerException("JobListener '" + jl.getName() + "' threw exception: " + e.getMessage(), e);
                se.setErrorCode(600);
                throw se;
            }
        }
    }

    public void notifyJobListenersWasExecuted(JobExecutionContext jec, JobExecutionException je) throws SchedulerException {
        List jobListeners = this.buildJobListenerList(jec.getJobDetail().getJobListenerNames());
        Iterator itr = jobListeners.iterator();
        while (itr.hasNext()) {
            JobListener jl = (JobListener)itr.next();
            try {
                jl.jobWasExecuted(jec, je);
            }
            catch (Exception e) {
                SchedulerException se = new SchedulerException("JobListener '" + jl.getName() + "' threw exception: " + e.getMessage(), e);
                se.setErrorCode(600);
                throw se;
            }
        }
    }

    public void notifySchedulerListenersError(String msg, SchedulerException se) {
        List schedListeners = this.getSchedulerListeners();
        Iterator itr = schedListeners.iterator();
        while (itr.hasNext()) {
            SchedulerListener sl = (SchedulerListener)itr.next();
            try {
                sl.schedulerError(msg, se);
            }
            catch (Exception e) {
                QuartzScheduler.getLog().error("Error while notifying SchedulerListener of error: ", e);
                QuartzScheduler.getLog().error("  Original error (for notification) was: " + msg, se);
            }
        }
    }

    public void notifySchedulerListenersSchduled(Trigger trigger) {
        List schedListeners = this.getSchedulerListeners();
        Iterator itr = schedListeners.iterator();
        while (itr.hasNext()) {
            SchedulerListener sl = (SchedulerListener)itr.next();
            try {
                sl.jobScheduled(trigger);
            }
            catch (Exception e) {
                QuartzScheduler.getLog().error("Error while notifying SchedulerListener of scheduled job.  Triger=" + trigger.getFullName(), e);
            }
        }
    }

    public void notifySchedulerListenersUnschduled(String triggerName, String triggerGroup) {
        List schedListeners = this.getSchedulerListeners();
        Iterator itr = schedListeners.iterator();
        while (itr.hasNext()) {
            SchedulerListener sl = (SchedulerListener)itr.next();
            try {
                sl.jobUnscheduled(triggerName, triggerGroup);
            }
            catch (Exception e) {
                QuartzScheduler.getLog().error("Error while notifying SchedulerListener of unscheduled job.  Triger=" + triggerGroup + "." + triggerName, e);
            }
        }
    }

    public void notifySchedulerListenersFinalized(Trigger trigger) {
        List schedListeners = this.getSchedulerListeners();
        Iterator itr = schedListeners.iterator();
        while (itr.hasNext()) {
            SchedulerListener sl = (SchedulerListener)itr.next();
            try {
                sl.triggerFinalized(trigger);
            }
            catch (Exception e) {
                QuartzScheduler.getLog().error("Error while notifying SchedulerListener of finalized trigger.  Triger=" + trigger.getFullName(), e);
            }
        }
    }

    public void notifySchedulerListenersPausedTrigger(String name, String group) {
        List schedListeners = this.getSchedulerListeners();
        Iterator itr = schedListeners.iterator();
        while (itr.hasNext()) {
            SchedulerListener sl = (SchedulerListener)itr.next();
            try {
                sl.triggersPaused(name, group);
            }
            catch (Exception e) {
                QuartzScheduler.getLog().error("Error while notifying SchedulerListener of paused trigger/group.  Triger=" + group + "." + name, e);
            }
        }
    }

    public void notifySchedulerListenersResumedTrigger(String name, String group) {
        List schedListeners = this.getSchedulerListeners();
        Iterator itr = schedListeners.iterator();
        while (itr.hasNext()) {
            SchedulerListener sl = (SchedulerListener)itr.next();
            try {
                sl.triggersResumed(name, group);
            }
            catch (Exception e) {
                QuartzScheduler.getLog().error("Error while notifying SchedulerListener of resumed trigger/group.  Triger=" + group + "." + name, e);
            }
        }
    }

    public void notifySchedulerListenersPausedJob(String name, String group) {
        List schedListeners = this.getSchedulerListeners();
        Iterator itr = schedListeners.iterator();
        while (itr.hasNext()) {
            SchedulerListener sl = (SchedulerListener)itr.next();
            try {
                sl.jobsPaused(name, group);
            }
            catch (Exception e) {
                QuartzScheduler.getLog().error("Error while notifying SchedulerListener of paused job/group.  Job=" + group + "." + name, e);
            }
        }
    }

    public void notifySchedulerListenersResumedJob(String name, String group) {
        List schedListeners = this.getSchedulerListeners();
        Iterator itr = schedListeners.iterator();
        while (itr.hasNext()) {
            SchedulerListener sl = (SchedulerListener)itr.next();
            try {
                sl.jobsResumed(name, group);
            }
            catch (Exception e) {
                QuartzScheduler.getLog().error("Error while notifying SchedulerListener of resumed job/group.  Job=" + group + "." + name, e);
            }
        }
    }

    public void notifySchedulerListenersShutdown() {
        List schedListeners = this.getSchedulerListeners();
        Iterator itr = schedListeners.iterator();
        while (itr.hasNext()) {
            SchedulerListener sl = (SchedulerListener)itr.next();
            try {
                sl.schedulerShutdown();
            }
            catch (Exception e) {
                QuartzScheduler.getLog().error("Error while notifying SchedulerListener of shutdown.", e);
            }
        }
    }

    public void addSchedulerPlugin(SchedulerPlugin plugin) {
        this.schedulerPlugins.add(plugin);
    }

    public void setJobFactory(JobFactory factory) throws SchedulerException {
        if (factory == null) {
            throw new IllegalArgumentException("JobFactory cannot be set to null!");
        }
        QuartzScheduler.getLog().info("JobFactory set to: " + factory);
        this.jobFactory = factory;
    }

    public JobFactory getJobFactory() {
        return this.jobFactory;
    }

    public boolean interrupt(SchedulingContext ctxt, String jobName, String groupName) throws UnableToInterruptJobException {
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        List jobs = this.getCurrentlyExecutingJobs();
        Iterator it = jobs.iterator();
        JobExecutionContext jec = null;
        JobDetail jobDetail = null;
        Job job = null;
        boolean interrupted = false;
        while (it.hasNext()) {
            jec = (JobExecutionContext)it.next();
            jobDetail = jec.getJobDetail();
            if (!jobName.equals(jobDetail.getName()) || !groupName.equals(jobDetail.getGroup())) continue;
            job = jec.getJobInstance();
            if (job instanceof InterruptableJob) {
                ((InterruptableJob)job).interrupt();
                interrupted = true;
                continue;
            }
            throw new UnableToInterruptJobException("Job '" + jobName + "' of group '" + groupName + "' can not be interrupted, since it does not implement " + (class$org$quartz$InterruptableJob == null ? (class$org$quartz$InterruptableJob = QuartzScheduler.class$("org.quartz.InterruptableJob")) : class$org$quartz$InterruptableJob).getName());
        }
        return interrupted;
    }

    private void shutdownPlugins() {
        Iterator itr = this.schedulerPlugins.iterator();
        while (itr.hasNext()) {
            SchedulerPlugin plugin = (SchedulerPlugin)itr.next();
            plugin.shutdown();
        }
    }

    private void startPlugins() {
        Iterator itr = this.schedulerPlugins.iterator();
        while (itr.hasNext()) {
            SchedulerPlugin plugin = (SchedulerPlugin)itr.next();
            plugin.start();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Properties props = new Properties();
        try {
            InputStream is = (class$org$quartz$core$QuartzScheduler == null ? (class$org$quartz$core$QuartzScheduler = QuartzScheduler.class$("org.quartz.core.QuartzScheduler")) : class$org$quartz$core$QuartzScheduler).getResourceAsStream("/build.properties");
            if (is != null) {
                props.load(is);
                VERSION_MAJOR = props.getProperty("version.major");
                VERSION_MINOR = props.getProperty("version.minor");
                VERSION_ITERATION = props.getProperty("version.iter");
            }
        }
        catch (IOException e) {
            QuartzScheduler.getLog().error("Error loading version info from build.properties.", e);
        }
    }
}

