/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.appengine.DatastoreAbstractCollectionStoreSpecialization;
import org.datanucleus.store.appengine.DatastoreManager;
import org.datanucleus.store.appengine.DatastorePersistenceHandler;
import org.datanucleus.store.appengine.DatastoreServiceFactoryInternal;
import org.datanucleus.store.appengine.EntityUtils;
import org.datanucleus.store.appengine.Utils;
import org.datanucleus.store.mapped.exceptions.MappedDatastoreException;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.scostore.AbstractListStoreSpecialization;
import org.datanucleus.store.mapped.scostore.ElementContainerStore;
import org.datanucleus.util.Localiser;

abstract class DatastoreAbstractListStoreSpecialization
extends DatastoreAbstractCollectionStoreSpecialization
implements AbstractListStoreSpecialization {
    DatastoreAbstractListStoreSpecialization(Localiser localiser, ClassLoaderResolver clr, DatastoreManager storeMgr) {
        super(localiser, clr, storeMgr);
    }

    public int indexOf(StateManager parentSm, Object element, ElementContainerStore ecs) {
        StateManager elementSm = parentSm.getObjectManager().findStateManager(element);
        Key elementKey = EntityUtils.getPrimaryKeyAsKey(elementSm.getObjectManager().getApiAdapter(), elementSm);
        if (elementKey == null) {
            throw new NucleusUserException("Collection element does not have a primary key.");
        }
        if (elementKey.getParent() == null) {
            throw new NucleusUserException("Collection element primary key does not have a parent.");
        }
        DatastoreService service = DatastoreServiceFactoryInternal.getDatastoreService();
        try {
            Entity e = service.get(elementKey);
            return this.extractIndexProperty(e, ecs, elementSm.getObjectManager());
        }
        catch (EntityNotFoundException enfe) {
            throw new NucleusDataStoreException("Could not determine index of entity.", (Throwable)enfe);
        }
    }

    public int lastIndexOf(StateManager sm, Object element, ElementContainerStore ecs) {
        throw new UnsupportedOperationException();
    }

    public int[] getIndicesOf(StateManager sm, Collection elements, ElementContainerStore ecs) {
        if (elements.isEmpty()) {
            return new int[0];
        }
        ArrayList<Object> keys = Utils.newArrayList(new Object[0]);
        HashSet<Object> keySet = Utils.newHashSet(new Object[0]);
        for (Object ele : elements) {
            Key key;
            ApiAdapter apiAdapter = sm.getObjectManager().getApiAdapter();
            Object keyOrString = apiAdapter.getTargetKeyForSingleFieldIdentity(apiAdapter.getIdForObject(ele));
            Key key2 = key = keyOrString instanceof Key ? (Key)keyOrString : KeyFactory.stringToKey((String)((String)keyOrString));
            if (key == null) {
                throw new NucleusUserException("Collection element does not have a primary key.");
            }
            if (key.getParent() == null) {
                throw new NucleusUserException("Collection element primary key does not have a parent.");
            }
            keys.add(key);
            keySet.add(key);
        }
        Collections.sort(keys);
        AbstractClassMetaData emd = ecs.getEmd();
        String kind = this.storeMgr.getIdentifierFactory().newDatastoreContainerIdentifier(emd).getIdentifierName();
        Query q = new Query(kind);
        q.setAncestor(((Key)keys.get(0)).getParent());
        q.addFilter("__key__", Query.FilterOperator.GREATER_THAN_OR_EQUAL, keys.get(0));
        q.addFilter("__key__", Query.FilterOperator.LESS_THAN_OR_EQUAL, keys.get(keys.size() - 1));
        q.addSort("__key__", Query.SortDirection.DESCENDING);
        DatastoreService service = DatastoreServiceFactoryInternal.getDatastoreService();
        int[] indices = new int[keys.size()];
        int index = 0;
        for (Entity e : service.prepare(service.getCurrentTransaction(null), q).asIterable()) {
            if (!keySet.contains(e.getKey())) continue;
            indices[index++] = this.extractIndexProperty(e, ecs, sm.getObjectManager());
        }
        if (index != indices.length) {
            throw new NucleusDataStoreException("Too few keys returned.");
        }
        return indices;
    }

    private int extractIndexProperty(Entity e, ElementContainerStore ecs, ObjectManager om) {
        JavaTypeMapping orderMapping = ecs.getOrderMapping();
        Long indexVal = (Long)orderMapping.getObject(om, (Object)e, new int[1]);
        if (indexVal == null) {
            throw new NucleusDataStoreException("Null index value");
        }
        return indexVal.intValue();
    }

    public int[] internalShift(StateManager ownerSM, ManagedConnection conn, boolean batched, int oldIndex, int amount, boolean executeNow, ElementContainerStore ecs) throws MappedDatastoreException {
        JavaTypeMapping orderMapping = ecs.getOrderMapping();
        if (orderMapping == null) {
            return null;
        }
        DatastoreService service = DatastoreServiceFactoryInternal.getDatastoreService();
        AbstractClassMetaData acmd = ecs.getEmd();
        String kind = this.storeMgr.getIdentifierFactory().newDatastoreContainerIdentifier(acmd).getIdentifierName();
        Query q = new Query(kind);
        ObjectManager om = ownerSM.getObjectManager();
        Object id = om.getApiAdapter().getTargetKeyForSingleFieldIdentity(ownerSM.getInternalObjectId());
        Key key = id instanceof Key ? (Key)id : KeyFactory.stringToKey((String)((String)id));
        q.setAncestor(key);
        Entity entity = new Entity(kind);
        orderMapping.setObject(om, (Object)entity, new int[]{1}, (Object)oldIndex);
        String indexProp = (String)entity.getProperties().keySet().iterator().next();
        q.addFilter(indexProp, Query.FilterOperator.GREATER_THAN_OR_EQUAL, (Object)oldIndex);
        DatastorePersistenceHandler handler = this.storeMgr.getPersistenceHandler();
        for (Entity shiftMe : service.prepare(service.getCurrentTransaction(null), q).asIterable()) {
            Long pos = (Long)shiftMe.getProperty(indexProp);
            shiftMe.setProperty(indexProp, (Object)(pos + (long)amount));
            handler.put(om, shiftMe);
        }
        return null;
    }
}

