/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import com.google.appengine.api.datastore.Entity;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.appengine.Utils;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.mapped.mapping.MappingConsumer;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;

class DependentDeleteRequest {
    private final List<MappingCallbacks> callbacks;
    private final AbstractMemberMetaData[] oneToOneNonOwnerFields;

    public DependentDeleteRequest(DatastoreClass dc, ClassLoaderResolver clr) {
        DependentDeleteMappingConsumer consumer = new DependentDeleteMappingConsumer(clr);
        dc.provideNonPrimaryKeyMappings((MappingConsumer)consumer);
        dc.providePrimaryKeyMappings((MappingConsumer)consumer);
        dc.provideDatastoreIdMappings((MappingConsumer)consumer);
        this.callbacks = consumer.getMappingCallBacks();
        this.oneToOneNonOwnerFields = consumer.getOneToOneNonOwnerFields();
    }

    public void execute(StateManager sm, Entity owningEntity) {
        for (MappingCallbacks callback : this.callbacks) {
            callback.preDelete(sm);
        }
        if (this.oneToOneNonOwnerFields != null && this.oneToOneNonOwnerFields.length > 0) {
            for (AbstractMemberMetaData relatedFmd : this.oneToOneNonOwnerFields) {
                this.updateOneToOneBidirectionalOwnerObjectForField(sm, relatedFmd, owningEntity);
            }
        }
    }

    private void updateOneToOneBidirectionalOwnerObjectForField(StateManager sm, AbstractMemberMetaData fmd, Entity owningEntity) {
        ObjectManager om;
        ClassLoaderResolver clr;
        AbstractMemberMetaData[] relatedMmds;
        String fullClassName;
        MappedStoreManager storeMgr = (MappedStoreManager)sm.getStoreManager();
        DatastoreClass refTable = storeMgr.getDatastoreClass(fullClassName = ((AbstractClassMetaData)(relatedMmds = fmd.getRelatedMemberMetaData(clr = (om = sm.getObjectManager()).getClassLoaderResolver()))[0].getParent()).getFullClassName(), clr);
        JavaTypeMapping refMapping = refTable.getMemberMapping(fmd.getMappedBy());
        if (refMapping.isNullable()) {
            refMapping.setObject(om, (Object)owningEntity, new int[1], sm.getObject());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DependentDeleteMappingConsumer
    implements MappingConsumer {
        private int pkField;
        private final List<AbstractMemberMetaData> oneToOneNonOwnerFields = Utils.newArrayList(new Object[0]);
        private final List<MappingCallbacks> callbacks = Utils.newArrayList(new Object[0]);
        private final ClassLoaderResolver clr;

        public DependentDeleteMappingConsumer(ClassLoaderResolver clr) {
            this.clr = clr;
        }

        public void preConsumeMapping(int highest) {
        }

        public void consumeMapping(JavaTypeMapping m, AbstractMemberMetaData fmd) {
            if (m.includeInUpdateStatement()) {
                if (fmd.isPrimaryKey()) {
                    this.pkField = fmd.getAbsoluteFieldNumber();
                } else if ((m instanceof PersistenceCapableMapping || m instanceof ReferenceMapping) && m.getNumberOfDatastoreFields() == 0) {
                    int relationType = fmd.getRelationType(this.clr);
                    if (relationType == 2) {
                        if (fmd.getMappedBy() != null) {
                            this.oneToOneNonOwnerFields.add(fmd);
                        }
                    } else if (relationType == 6) {
                        AbstractMemberMetaData[] relatedMmds = fmd.getRelatedMemberMetaData(this.clr);
                        if (fmd.getJoinMetaData() != null || relatedMmds[0].getJoinMetaData() != null) {
                            // empty if block
                        }
                    }
                }
            }
            if (m instanceof MappingCallbacks) {
                this.callbacks.add((MappingCallbacks)m);
            }
        }

        public int getPrimaryKeyFieldNumber() {
            return this.pkField;
        }

        public AbstractMemberMetaData[] getOneToOneNonOwnerFields() {
            AbstractMemberMetaData[] fmds = new AbstractMemberMetaData[this.oneToOneNonOwnerFields.size()];
            for (int i = 0; i < this.oneToOneNonOwnerFields.size(); ++i) {
                fmds[i] = this.oneToOneNonOwnerFields.get(i);
            }
            return fmds;
        }

        public List<MappingCallbacks> getMappingCallBacks() {
            return this.callbacks;
        }

        public void consumeUnmappedDatastoreField(DatastoreField fld) {
        }

        public void consumeMapping(JavaTypeMapping m, int mappingType) {
        }
    }
}

