/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine.valuegenerator;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.KeyRange;
import java.util.ArrayList;
import java.util.Properties;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.appengine.DatastoreManager;
import org.datanucleus.store.appengine.DatastoreServiceFactoryInternal;
import org.datanucleus.store.appengine.EntityUtils;
import org.datanucleus.store.appengine.Utils;
import org.datanucleus.store.valuegenerator.AbstractDatastoreGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationBlock;

public class SequenceGenerator
extends AbstractDatastoreGenerator {
    private static final String SEQUENCE_POSTFIX = "_SEQUENCE__";
    private static final String KEY_CACHE_SIZE_PROPERTY = "key-cache-size";
    private String sequenceName;

    public SequenceGenerator(String name, Properties props) {
        super(name, props);
    }

    public void setStoreManager(StoreManager storeMgr) {
        super.setStoreManager(storeMgr);
        OMFContext omfContext = this.getOMFContext();
        MetaDataManager mdm = omfContext.getMetaDataManager();
        ClassLoaderResolver clr = omfContext.getClassLoaderResolver(((Object)((Object)this)).getClass().getClassLoader());
        AbstractClassMetaData acmd = mdm.getMetaDataForClass((String)this.properties.get("class-name"), clr);
        if (acmd != null) {
            ((DatastoreManager)storeMgr).validateMetaDataForClass(acmd, clr);
        }
        this.sequenceName = this.determineSequenceName(acmd);
        if (this.sequenceName != null) {
            SequenceMetaData sequenceMetaData = mdm.getMetaDataForSequence(clr, this.sequenceName);
            if (sequenceMetaData != null) {
                this.allocationSize = sequenceMetaData.hasExtension(KEY_CACHE_SIZE_PROPERTY) ? Integer.parseInt(sequenceMetaData.getValueForExtension(KEY_CACHE_SIZE_PROPERTY)) : this.longToInt(sequenceMetaData.getAllocationSize());
                this.sequenceName = sequenceMetaData.getDatastoreSequence();
            } else if (this.properties.getProperty(KEY_CACHE_SIZE_PROPERTY) != null) {
                this.allocationSize = Integer.parseInt(this.properties.getProperty(KEY_CACHE_SIZE_PROPERTY));
            }
        }
        if (this.sequenceName == null) {
            this.sequenceName = this.deriveSequenceNameFromClassMetaData(acmd);
        }
    }

    private String determineSequenceName(AbstractClassMetaData acmd) {
        String sequenceName = (String)this.properties.get("sequence-name");
        if (sequenceName != null) {
            return sequenceName;
        }
        if (acmd == null) {
            throw new IllegalStateException("Received a null AbstractClassMetaData and properties did not contain a sequence-name attribute.");
        }
        String fieldName = (String)this.properties.get("field-name");
        AbstractMemberMetaData ammd = acmd.getMetaDataForMember(fieldName.substring(fieldName.lastIndexOf(".") + 1));
        return ammd.getSequence() != null ? ammd.getSequence() : ammd.getValueGeneratorName();
    }

    private int longToInt(Long val) {
        if (Long.valueOf(val.intValue()).longValue() != val.longValue()) {
            throw new NucleusUserException("id batch size is too big: " + val).setFatal();
        }
        return val.intValue();
    }

    private OMFContext getOMFContext() {
        return this.storeMgr.getOMFContext();
    }

    private String deriveSequenceNameFromClassMetaData(AbstractClassMetaData acmd) {
        return EntityUtils.determineKind(acmd, ((DatastoreManager)this.storeMgr).getIdentifierFactory()) + SEQUENCE_POSTFIX;
    }

    protected ValueGenerationBlock reserveBlock(long size) {
        if (this.sequenceName == null) {
            throw new IllegalStateException("sequence name is null");
        }
        DatastoreService ds = DatastoreServiceFactoryInternal.getDatastoreService();
        KeyRange range = ds.allocateIds(this.sequenceName, size);
        ArrayList<Object> ids = Utils.newArrayList(new Object[0]);
        long current = range.getStart().getId();
        int i = 0;
        while ((long)i < size) {
            ids.add(current + (long)i);
            ++i;
        }
        return new ValueGenerationBlock(ids);
    }
}

