/*
 * Decompiled with CFR 0.152.
 */
package play.modules.gae;

import com.google.appengine.tools.development.ApiProxyLocalImpl;
import com.google.apphosting.api.ApiProxy;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import javax.mail.Session;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.datanucleus.enhancer.DataNucleusEnhancer;
import org.datanucleus.store.appengine.jpa.DatastorePersistenceProvider;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.cache.Cache;
import play.classloading.ApplicationClasses;
import play.db.jpa.JPA;
import play.db.jpa.JPAPlugin;
import play.db.jpa.JPQLDialect;
import play.exceptions.UnexpectedException;
import play.jobs.JobsPlugin;
import play.libs.IO;
import play.libs.Mail;
import play.modules.gae.DataNucleusDialect;
import play.modules.gae.GAECache;
import play.modules.gae.PlayDevEnvironment;
import play.mvc.Router;

public class GAEPlugin
extends PlayPlugin {
    public ApiProxy.Environment devEnvironment = null;
    public boolean prodGAE;

    public void onLoad() {
        ListIterator it = Play.plugins.listIterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof JobsPlugin)) continue;
            it.remove();
        }
        if (ApiProxy.getCurrentEnvironment() != null && ApiProxy.getCurrentEnvironment().getClass().getName().indexOf("development") == -1) {
            Play.mode = Play.Mode.PROD;
            this.prodGAE = true;
        }
        if (ApiProxy.getCurrentEnvironment() == null) {
            File webInf;
            Logger.warn((String)"", (Object[])new Object[0]);
            Logger.warn((String)"Google App Engine module", (Object[])new Object[0]);
            Logger.warn((String)"~~~~~~~~~~~~~~~~~~~~~~~", (Object[])new Object[0]);
            Logger.warn((String)"No Google App Engine environment found. Setting up a development environement", (Object[])new Object[0]);
            this.devEnvironment = new PlayDevEnvironment();
            ApiProxy.setDelegate((ApiProxy.Delegate)new ApiProxyLocalImpl(new File(Play.applicationPath, "war")){});
            ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)new PlayDevEnvironment());
            System.setProperty("appengine.orm.disable.duplicate.emf.exception", "yes");
            File warExt = Play.getFile((String)"war");
            if (!warExt.exists()) {
                warExt.mkdir();
            }
            if (!(webInf = Play.getFile((String)"war/WEB-INF")).exists()) {
                webInf.mkdir();
            }
            File xml = Play.getFile((String)"war/WEB-INF/appengine-web.xml");
            try {
                if (!xml.exists()) {
                    IO.writeContent((CharSequence)"<appengine-web-app xmlns=\"http://appengine.google.com/ns/1.0\">\n\t<application><!-- Replace this with your application id from http://appengine.google.com --></application>\n\t<version>1</version>\n</appengine-web-app>\n", (File)xml);
                }
                if (IO.readContentAsString((File)xml).contains("<!-- Replace this with your application id from http://appengine.google.com -->")) {
                    Logger.warn((String)"Don't forget to define your GAE application id in the 'war/WEB-INF/appengine-web.xml' file", (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                Logger.error((Throwable)e, (String)"Cannot init GAE files", (Object[])new Object[0]);
            }
            Logger.warn((String)"", (Object[])new Object[0]);
        }
    }

    public void onRoutesLoaded() {
        Router.addRoute((String)"GET", (String)"/_ah/login", (String)"GAEActions.login");
        Router.addRoute((String)"POST", (String)"/_ah/login", (String)"GAEActions.doLogin");
        Router.addRoute((String)"GET", (String)"/_ah/logout", (String)"GAEActions.logout");
    }

    public void onApplicationStart() {
        final List classes = Play.classloader.getAnnotatedClasses(Entity.class);
        if (!classes.isEmpty()) {
            JPAPlugin.autoTxs = false;
            JPA.entityManagerFactory = new DatastorePersistenceProvider().createContainerEntityManagerFactory(new PersistenceUnitInfo(){

                public String getPersistenceUnitName() {
                    return "default";
                }

                public String getPersistenceProviderClassName() {
                    return DatastorePersistenceProvider.class.getName();
                }

                public PersistenceUnitTransactionType getTransactionType() {
                    return PersistenceUnitTransactionType.RESOURCE_LOCAL;
                }

                public DataSource getJtaDataSource() {
                    return null;
                }

                public DataSource getNonJtaDataSource() {
                    return null;
                }

                public List<String> getMappingFileNames() {
                    return new ArrayList<String>();
                }

                public List<URL> getJarFileUrls() {
                    return new ArrayList<URL>();
                }

                public URL getPersistenceUnitRootUrl() {
                    try {
                        return Play.applicationPath.toURL();
                    }
                    catch (MalformedURLException ex) {
                        throw new RuntimeException(ex);
                    }
                }

                public List<String> getManagedClassNames() {
                    ArrayList<String> classNames = new ArrayList<String>();
                    for (Class c : classes) {
                        classNames.add(c.getName());
                    }
                    return classNames;
                }

                public boolean excludeUnlistedClasses() {
                    return false;
                }

                public Properties getProperties() {
                    Properties properties = new Properties();
                    properties.setProperty("datanucleus.NontransactionalRead", "true");
                    properties.setProperty("datanucleus.NontransactionalWrite", "true");
                    properties.setProperty("datanucleus.ConnectionURL", "appengine");
                    properties.setProperty("datanucleus.classLoaderResolverName", "playApplicationLoader");
                    return properties;
                }

                public ClassLoader getClassLoader() {
                    return Play.classloader;
                }

                public void addTransformer(ClassTransformer c) {
                }

                public ClassLoader getNewTempClassLoader() {
                    return Play.classloader;
                }
            }, new HashMap());
            JPQLDialect.instance = new DataNucleusDialect();
        }
        if (this.devEnvironment == null) {
            Cache.forcedCacheImpl = new GAECache();
        }
        Mail.session = Session.getDefaultInstance((Properties)new Properties(), null);
        Mail.asynchronousSend = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enhance(ApplicationClasses.ApplicationClass applicationClass) {
        ClassLoader tempCl = new ClassLoader(){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                Class<?> c = this.findLoadedClass(name);
                if (c != null) {
                    return c;
                }
                ApplicationClasses.ApplicationClass tempClass = Play.classes.getApplicationClass(name);
                if (tempClass != null) {
                    return this.defineClass(tempClass.name, tempClass.javaByteCode, 0, tempClass.javaByteCode.length, Play.classloader.protectionDomain);
                }
                return GAEPlugin.class.getClassLoader().loadClass(name);
            }
        };
        try {
            if (!tempCl.loadClass(applicationClass.name).isAnnotationPresent(Entity.class) && !tempCl.loadClass(applicationClass.name).isAnnotationPresent(MappedSuperclass.class)) {
                return;
            }
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
        DataNucleusEnhancer dataNucleusEnhancer = new DataNucleusEnhancer("JDO", "ASM");
        dataNucleusEnhancer.setVerbose(true);
        dataNucleusEnhancer.setClassLoader(tempCl);
        ClassLoader pc = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(tempCl);
            dataNucleusEnhancer.getMetaDataManager().loadClasses(new String[]{applicationClass.name}, tempCl);
            dataNucleusEnhancer.addClass(applicationClass.name, applicationClass.enhancedByteCode);
            dataNucleusEnhancer.enhance();
            applicationClass.enhancedByteCode = dataNucleusEnhancer.getEnhancedBytes(applicationClass.name);
        }
        finally {
            Thread.currentThread().setContextClassLoader(pc);
        }
    }

    public void beforeInvocation() {
        if (this.devEnvironment != null) {
            ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)new PlayDevEnvironment());
        }
    }

    public void onConfigurationRead() {
        if (this.devEnvironment == null) {
            Play.configuration.remove("smtp.mock");
            Play.configuration.setProperty("application.log", "DEBUG");
        }
        Play.configuration.setProperty("upload.threshold", "2147483647");
    }
}

