/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.testing;

import com.google.appengine.api.labs.taskqueue.dev.LocalTaskQueue;
import com.google.appengine.api.labs.taskqueue.dev.LocalTaskQueueCallback;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.testing.LocalServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalServiceTestHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalTaskQueueTestConfig
implements LocalServiceTestConfig {
    private Boolean disableAutoTaskExecution = true;
    private String queueXmlPath;
    private Class<? extends LocalTaskQueueCallback> callbackClass;

    public LocalTaskQueueTestConfig setDisableAutoTaskExecution(boolean disableAutoTaskExecution) {
        this.disableAutoTaskExecution = disableAutoTaskExecution;
        return this;
    }

    public LocalTaskQueueTestConfig setQueueXmlPath(String queueXmlPath) {
        this.queueXmlPath = queueXmlPath;
        return this;
    }

    public LocalTaskQueueTestConfig setCallbackClass(Class<? extends LocalTaskQueueCallback> callbackClass) {
        this.callbackClass = callbackClass;
        return this;
    }

    @Override
    public void setUp() {
        ApiProxyLocal proxy = LocalServiceTestHelper.getApiProxyLocal();
        proxy.setProperty("task_queue.disable_auto_task_execution", this.disableAutoTaskExecution.toString());
        if (this.queueXmlPath != null) {
            proxy.setProperty("task_queue.queue_xml_path", this.queueXmlPath);
        }
        if (this.callbackClass != null) {
            proxy.setProperty("task_queue.callback_class", this.callbackClass.getName());
        }
    }

    @Override
    public void tearDown() {
        LocalTaskQueue ltq = LocalTaskQueueTestConfig.getLocalTaskQueue();
        for (String queueName : ltq.getQueueStateInfo().keySet()) {
            ltq.flushQueue(queueName);
        }
    }

    public static LocalTaskQueue getLocalTaskQueue() {
        return (LocalTaskQueue)LocalServiceTestHelper.getLocalService("taskqueue");
    }
}

