/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.EntityTranslator;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.KeyRange;
import com.google.appengine.api.datastore.KeyTranslator;
import com.google.appengine.api.datastore.MultiQueryBuilder;
import com.google.appengine.api.datastore.PreparedMultiQuery;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.PreparedQueryImpl;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QuerySplitHelper;
import com.google.appengine.api.datastore.ReadPolicy;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.appengine.api.datastore.TransactionRunner;
import com.google.appengine.api.datastore.TransactionStack;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DatastoreServiceImpl
implements DatastoreService {
    private static final Logger logger = Logger.getLogger(DatastoreServiceImpl.class.getName());
    static final long ARBITRARY_FAILOVER_READ_MS = -1L;
    private final DatastoreServiceConfig datastoreServiceConfig;
    private final ApiProxy.ApiConfig apiConfig;
    final TransactionStack defaultTxnProvider;

    public DatastoreServiceImpl(DatastoreServiceConfig datastoreServiceConfig, TransactionStack defaultTxnProvider) {
        this.datastoreServiceConfig = datastoreServiceConfig;
        this.apiConfig = this.createApiConfig(datastoreServiceConfig);
        this.defaultTxnProvider = defaultTxnProvider;
    }

    private ApiProxy.ApiConfig createApiConfig(DatastoreServiceConfig config) {
        ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
        apiConfig.setDeadlineInSeconds(config.getDeadline());
        return apiConfig;
    }

    @Override
    public Entity get(Transaction txn, Key key) throws EntityNotFoundException {
        return this.get(txn, key, false);
    }

    @Override
    public Entity get(Key key) throws EntityNotFoundException {
        GetOrCreateTransactionResult result = this.getOrCreateTransaction();
        return this.get(result.getTransaction(), key, result.isNew());
    }

    Entity get(Transaction txn, Key key, boolean finishTxn) throws EntityNotFoundException {
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        Map<Key, Entity> entities = this.get(txn, Arrays.asList(key), finishTxn);
        Entity entity = entities.get(key);
        if (entity == null) {
            throw new EntityNotFoundException(key);
        }
        return entity;
    }

    @Override
    public Map<Key, Entity> get(Iterable<Key> keys) {
        GetOrCreateTransactionResult result = this.getOrCreateTransaction();
        return this.get(result.getTransaction(), keys, result.isNew());
    }

    @Override
    public Map<Key, Entity> get(Transaction txn, Iterable<Key> keys) {
        return this.get(txn, keys, false);
    }

    Map<Key, Entity> get(final Transaction txn, final Iterable<Key> keys, boolean finishTxn) {
        if (keys == null) {
            throw new NullPointerException("keys cannot be null");
        }
        final DatastorePb.GetRequest req = new DatastorePb.GetRequest();
        final DatastorePb.GetResponse resp = new DatastorePb.GetResponse();
        new TransactionRunner(txn, finishTxn){

            protected void run() {
                if (txn != null) {
                    req.setTransaction(DatastoreServiceImpl.localTxnToRemoteTxn(txn));
                }
                for (Key key : keys) {
                    if (!key.isComplete()) {
                        throw new IllegalArgumentException(key + " is incomplete.");
                    }
                    req.addKey(KeyTranslator.convertToPb(key));
                }
                if (DatastoreServiceImpl.this.datastoreServiceConfig.getReadPolicy().getConsistency() == ReadPolicy.Consistency.EVENTUAL) {
                    req.setFailoverMs(-1L);
                }
                DatastoreApiHelper.makeSyncCall(DatastoreServiceImpl.this.apiConfig, "Get", req, resp);
            }
        }.runInTransaction();
        HashMap<Key, Entity> results = new HashMap<Key, Entity>();
        Iterator<Key> keyIterator = keys.iterator();
        Iterator<DatastorePb.GetResponse.Entity> responseEntitiesIterator = resp.entitys().iterator();
        while (keyIterator.hasNext()) {
            Key key = keyIterator.next();
            DatastorePb.GetResponse.Entity responseEntity = responseEntitiesIterator.next();
            if (!responseEntity.hasEntity()) continue;
            results.put(key, EntityTranslator.createFromPb(responseEntity.getEntity()));
        }
        return results;
    }

    @Override
    public Key put(Entity entity) {
        GetOrCreateTransactionResult result = this.getOrCreateTransaction();
        return this.put(result.getTransaction(), entity, result.isNew());
    }

    @Override
    public Key put(Transaction txn, Entity entity) {
        return this.put(txn, entity, false);
    }

    Key put(Transaction txn, Entity entity, boolean finishTxn) {
        this.put(txn, Arrays.asList(entity), finishTxn);
        return entity.getKey();
    }

    @Override
    public List<Key> put(Iterable<Entity> entities) {
        GetOrCreateTransactionResult result = this.getOrCreateTransaction();
        return this.put(result.getTransaction(), entities, result.isNew());
    }

    @Override
    public List<Key> put(Transaction txn, Iterable<Entity> entities) {
        return this.put(txn, entities, false);
    }

    private List<Key> put(final Transaction txn, final Iterable<Entity> entities, boolean finishTxn) {
        final DatastorePb.PutRequest req = new DatastorePb.PutRequest();
        final DatastorePb.PutResponse resp = new DatastorePb.PutResponse();
        new TransactionRunner(txn, finishTxn){

            protected void run() {
                if (txn != null) {
                    req.setTransaction(DatastoreServiceImpl.localTxnToRemoteTxn(txn));
                }
                for (Entity entity : entities) {
                    OnestoreEntity.EntityProto proto = EntityTranslator.convertToPb(entity);
                    req.addEntity(proto);
                }
                DatastoreApiHelper.makeSyncCall(DatastoreServiceImpl.this.apiConfig, "Put", req, resp);
            }
        }.runInTransaction();
        Iterator<Entity> entitiesIterator = entities.iterator();
        Iterator<OnestoreEntity.Reference> referenceIterator = resp.keys().iterator();
        ArrayList<Key> keysInOrder = new ArrayList<Key>(resp.keySize());
        while (entitiesIterator.hasNext()) {
            Entity entity = entitiesIterator.next();
            OnestoreEntity.Reference reference = referenceIterator.next();
            KeyTranslator.updateKey(reference, entity.getKey());
            keysInOrder.add(entity.getKey());
        }
        return keysInOrder;
    }

    @Override
    public void delete(Key ... keys) {
        GetOrCreateTransactionResult result = this.getOrCreateTransaction();
        this.delete(result.getTransaction(), result.isNew(), keys);
    }

    @Override
    public void delete(Transaction txn, Key ... keys) {
        this.delete(txn, false, keys);
    }

    void delete(Transaction txn, boolean finishTxn, Key ... keys) {
        this.delete(txn, Arrays.asList(keys), finishTxn);
    }

    @Override
    public void delete(Iterable<Key> keys) {
        GetOrCreateTransactionResult result = this.getOrCreateTransaction();
        this.delete(result.getTransaction(), keys, result.isNew());
    }

    @Override
    public void delete(Transaction txn, Iterable<Key> keys) {
        this.delete(txn, keys, false);
    }

    void delete(final Transaction txn, final Iterable<Key> keys, boolean finishTxn) {
        final DatastorePb.DeleteRequest request = new DatastorePb.DeleteRequest();
        final DatastorePb.DeleteResponse response = new DatastorePb.DeleteResponse();
        new TransactionRunner(txn, finishTxn){

            protected void run() {
                if (txn != null) {
                    request.setTransaction(DatastoreServiceImpl.localTxnToRemoteTxn(txn));
                }
                for (Key key : keys) {
                    if (!key.isComplete()) {
                        throw new IllegalArgumentException(key + " is incomplete.");
                    }
                    request.addKey(KeyTranslator.convertToPb(key));
                }
                DatastoreApiHelper.makeSyncCall(DatastoreServiceImpl.this.apiConfig, "Delete", request, response);
            }
        }.runInTransaction();
    }

    @Override
    public PreparedQuery prepare(Query query) {
        return this.prepare(null, query);
    }

    @Override
    public PreparedQuery prepare(Transaction txn, Query query) {
        MultiQueryBuilder queriesToRun = QuerySplitHelper.splitQuery(query);
        if (queriesToRun != null) {
            return new PreparedMultiQuery(this.apiConfig, this.datastoreServiceConfig, queriesToRun, txn);
        }
        return new PreparedQueryImpl(this.apiConfig, this.datastoreServiceConfig, query, txn);
    }

    @Override
    public Transaction beginTransaction() {
        DatastorePb.Transaction remoteTxn = new DatastorePb.Transaction();
        DatastorePb.BeginTransactionRequest request = new DatastorePb.BeginTransactionRequest();
        request.setApp(DatastoreApiHelper.getCurrentAppId());
        DatastoreApiHelper.makeSyncCall(this.apiConfig, "BeginTransaction", request, remoteTxn);
        Transaction localTxn = this.remoteTxnToLocalTxn(remoteTxn);
        this.defaultTxnProvider.push(localTxn);
        return localTxn;
    }

    @Override
    public Transaction getCurrentTransaction() {
        return this.defaultTxnProvider.peek();
    }

    @Override
    public Transaction getCurrentTransaction(Transaction returnedIfNoTxn) {
        return this.defaultTxnProvider.peek(returnedIfNoTxn);
    }

    @Override
    public Collection<Transaction> getActiveTransactions() {
        return this.defaultTxnProvider.getAll();
    }

    Transaction remoteTxnToLocalTxn(DatastorePb.Transaction remote) {
        return new TransactionImpl(this.apiConfig, remote.getApp(), remote.getHandle(), this.defaultTxnProvider);
    }

    static DatastorePb.Transaction localTxnToRemoteTxn(Transaction local) {
        DatastorePb.Transaction remote = new DatastorePb.Transaction();
        remote.setApp(local.getApp());
        remote.setHandle(Long.parseLong(local.getId()));
        return remote;
    }

    GetOrCreateTransactionResult getOrCreateTransaction() {
        Transaction currentTxn = this.getCurrentTransaction(null);
        if (currentTxn != null) {
            return new GetOrCreateTransactionResult(false, currentTxn);
        }
        switch (this.datastoreServiceConfig.getImplicitTransactionManagementPolicy()) {
            case NONE: {
                return new GetOrCreateTransactionResult(false, null);
            }
            case AUTO: {
                return new GetOrCreateTransactionResult(true, this.beginTransaction());
            }
        }
        String msg = "Unexpected Transaction Creation Policy: " + (Object)((Object)this.datastoreServiceConfig.getImplicitTransactionManagementPolicy());
        logger.severe(msg);
        throw new IllegalArgumentException(msg);
    }

    @Override
    public KeyRange allocateIds(String kind, long num) {
        return this.allocateIds(null, kind, num);
    }

    @Override
    public KeyRange allocateIds(Key parent, String kind, long num) {
        if (num <= 0L) {
            throw new IllegalArgumentException("num must be > 0");
        }
        if (num > 1000000000L) {
            throw new IllegalArgumentException("num must be < 1 billion");
        }
        OnestoreEntity.Reference allocateIdsRef = DatastoreServiceImpl.buildAllocateIdsRef(parent, kind);
        DatastorePb.AllocateIdsRequest req = new DatastorePb.AllocateIdsRequest().setSize(num).setModelKey(allocateIdsRef);
        DatastorePb.AllocateIdsResponse resp = new DatastorePb.AllocateIdsResponse();
        DatastoreApiHelper.makeSyncCall(this.apiConfig, "AllocateIds", req, resp);
        return new KeyRange(parent, kind, resp.getStart(), resp.getEnd());
    }

    static OnestoreEntity.Reference buildAllocateIdsRef(Key parent, String kind) {
        if (parent != null && !parent.isComplete()) {
            throw new IllegalArgumentException("parent key must be complete");
        }
        Key key = KeyFactory.createKey(parent, kind, "ignored");
        return KeyTranslator.convertToPb(key);
    }

    @Override
    public DatastoreService.KeyRangeState allocateIdRange(KeyRange range) {
        Key parent = range.getParent();
        String kind = range.getKind();
        long start = range.getStart().getId();
        long end = range.getEnd().getId();
        DatastorePb.AllocateIdsRequest req = new DatastorePb.AllocateIdsRequest().setModelKey(DatastoreServiceImpl.buildAllocateIdsRef(parent, kind)).setMax(end);
        DatastorePb.AllocateIdsResponse resp = new DatastorePb.AllocateIdsResponse();
        DatastoreApiHelper.makeSyncCall(this.apiConfig, "AllocateIds", req, resp);
        Query query = new Query(kind).setKeysOnly();
        query.addFilter("__key__", Query.FilterOperator.GREATER_THAN_OR_EQUAL, range.getStart());
        query.addFilter("__key__", Query.FilterOperator.LESS_THAN_OR_EQUAL, range.getEnd());
        List<Entity> collision = this.prepare(query).asList(FetchOptions.Builder.withLimit(1));
        if (!collision.isEmpty()) {
            return DatastoreService.KeyRangeState.COLLISION;
        }
        boolean raceCondition = start < resp.getStart();
        return raceCondition ? DatastoreService.KeyRangeState.CONTENTION : DatastoreService.KeyRangeState.EMPTY;
    }

    static final class GetOrCreateTransactionResult {
        private final boolean isNew;
        private final Transaction txn;

        private GetOrCreateTransactionResult(boolean aNew, Transaction txn) {
            this.isNew = aNew;
            this.txn = txn;
        }

        public boolean isNew() {
            return this.isNew;
        }

        public Transaction getTransaction() {
            return this.txn;
        }
    }
}

