/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.repackaged.com.google.common.collect.HashMultimap;
import com.google.appengine.repackaged.com.google.common.collect.Multimap;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.appengine.tools.development.ServicesFile;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedAnnotationTypes(value={"com.google.appengine.tools.development.ServiceProvider"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedOptions(value={"debug", "verify"})
public class ServiceProviderProcessor
extends AbstractProcessor {
    private static final String SERVICE_DIR = "META-INF" + File.separator + "services" + File.separator;
    private Multimap<String, String> providers = HashMultimap.create();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            return this.processImpl(annotations, roundEnv);
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            this.fatalError(writer.toString());
            return true;
        }
    }

    private boolean processImpl(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.generateConfigFiles();
        } else {
            this.processAnnotations(annotations, roundEnv);
        }
        return true;
    }

    private void processAnnotations(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(ServiceProvider.class);
        this.log(annotations.toString());
        this.log(elements.toString());
        for (Element element : elements) {
            TypeElement providerImplementer = (TypeElement)element;
            AnnotationMirror providerAnnotation = this.getAnnotationMirror(element, ServiceProvider.class);
            DeclaredType providerInterface = this.getProviderInterface(providerAnnotation);
            TypeElement providerType = (TypeElement)providerInterface.asElement();
            this.log("provider interface: " + providerType.getQualifiedName());
            this.log("provider implementer: " + providerImplementer.getQualifiedName());
            try {
                this.verifyImplementer(providerImplementer, providerType);
            }
            catch (VerifyException ex) {
                this.error(ex.getMessage(), element, providerAnnotation);
            }
            String providerTypeName = this.getBinaryName(providerType);
            String providerImplementerName = this.getBinaryName(providerImplementer);
            this.log("provider interface binary name: " + providerTypeName);
            this.log("provider implementer binary name: " + providerImplementerName);
            this.providers.put(providerTypeName, providerImplementerName);
        }
    }

    private void generateConfigFiles() {
        Filer filer = this.processingEnv.getFiler();
        for (String providerInterface : this.providers.keySet()) {
            String resourceFile = SERVICE_DIR + providerInterface;
            this.log("Working on resource file: " + resourceFile);
            try {
                HashSet<String> allServices = new HashSet<String>();
                try {
                    FileObject existingFile = filer.getResource(StandardLocation.CLASS_OUTPUT, "", resourceFile);
                    this.log("Looking for existing resource file at " + existingFile.toUri());
                    Set<String> oldServices = ServicesFile.readServiceFile(existingFile.openInputStream());
                    this.log("Existing service entries: " + oldServices);
                    allServices.addAll(oldServices);
                }
                catch (IOException e) {
                    this.log("Resource file did not already exist.");
                }
                HashSet<String> newServices = new HashSet<String>(this.providers.get(providerInterface));
                if (allServices.containsAll(newServices)) {
                    this.log("No new service entries being added.");
                    return;
                }
                allServices.addAll(newServices);
                this.log("New service file contents: " + allServices);
                FileObject fileObject = filer.createResource(StandardLocation.CLASS_OUTPUT, "", resourceFile, new Element[0]);
                OutputStream out = fileObject.openOutputStream();
                ServicesFile.writeServiceFile(allServices, out);
                out.close();
                this.log("Wrote to: " + fileObject.toUri());
            }
            catch (IOException e) {
                this.fatalError("Unable to create " + resourceFile + ", " + e);
                return;
            }
        }
    }

    private void verifyImplementer(TypeElement providerImplementer, TypeElement providerType) throws VerifyException {
        String verify = this.processingEnv.getOptions().get("verify");
        if (verify == null || !Boolean.valueOf(verify).booleanValue()) {
            return;
        }
        Types types = this.processingEnv.getTypeUtils();
        if (!types.isSubtype(providerImplementer.asType(), providerType.asType())) {
            throw new VerifyException("ServiceProviders must implement their service provider interface. " + providerImplementer.getQualifiedName() + " does not implement " + providerType.getQualifiedName());
        }
    }

    private String getBinaryName(TypeElement element) {
        return this.getBinaryNameImpl(element, element.getSimpleName().toString());
    }

    private String getBinaryNameImpl(TypeElement element, String className) {
        Element enclosingElement = element.getEnclosingElement();
        if (enclosingElement instanceof PackageElement) {
            PackageElement pkg = (PackageElement)enclosingElement;
            if (pkg.isUnnamed()) {
                return className;
            }
            return pkg.getQualifiedName() + "." + className;
        }
        TypeElement typeElement = (TypeElement)enclosingElement;
        return this.getBinaryNameImpl(typeElement, typeElement.getSimpleName() + "$" + className);
    }

    private DeclaredType getProviderInterface(AnnotationMirror providerAnnotation) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = providerAnnotation.getElementValues();
        this.log("annotation values: " + values);
        AnnotationValue value = values.values().iterator().next();
        return (DeclaredType)value.getValue();
    }

    private AnnotationMirror getAnnotationMirror(Element e, Class<? extends Annotation> klass) {
        List<? extends AnnotationMirror> annotationMirrors = e.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            this.log("mirror: " + annotationMirror);
            DeclaredType type = annotationMirror.getAnnotationType();
            TypeElement typeElement = (TypeElement)type.asElement();
            if (typeElement.getQualifiedName().contentEquals(klass.getName())) {
                return annotationMirror;
            }
            this.log("klass name: [" + klass.getName() + "]");
            this.log("type name: [" + typeElement.getQualifiedName() + "]");
        }
        return null;
    }

    private void log(String msg) {
        if (this.processingEnv.getOptions().containsKey("debug")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
        }
    }

    private void error(String msg, Element element, AnnotationMirror annotation) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element, annotation);
    }

    private void fatalError(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "FATAL ERROR: " + msg);
    }

    private static class VerifyException
    extends Exception {
        VerifyException(String message) {
            super(message);
        }
    }
}

