/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.Clock;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServerEnvironment;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.apphosting.api.ApiProxy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ApiProxyLocalImpl
implements ApiProxyLocal {
    private static final Class BYTE_ARRAY_CLASS = byte[].class;
    private static final int MAX_API_REQUEST_SIZE = 0x100000;
    private static final Logger logger = Logger.getLogger(ApiProxyLocalImpl.class.getName());
    private final Map<String, LocalRpcService> serviceCache = new ConcurrentHashMap<String, LocalRpcService>();
    private final Map<String, String> properties = new HashMap<String, String>();
    private final ExecutorService apiExecutor = Executors.newCachedThreadPool(new DaemonThreadFactory(Executors.defaultThreadFactory()));
    private final LocalServiceContext context;
    private Clock clock = Clock.DEFAULT;

    protected ApiProxyLocalImpl(LocalServerEnvironment environment) {
        this.context = new LocalServiceContextImpl(environment);
    }

    @Override
    public void log(ApiProxy.Environment environment, ApiProxy.LogRecord record) {
        logger.log(ApiProxyLocalImpl.toJavaLevel(record.getLevel()), record.getMessage());
    }

    @Override
    public byte[] makeSyncCall(ApiProxy.Environment environment, String packageName, String methodName, byte[] requestBytes) {
        Future<byte[]> future = this.doAsyncCall(environment, packageName, methodName, requestBytes);
        try {
            return future.get();
        }
        catch (InterruptedException ex) {
            throw new ApiProxy.CancelledException(packageName, methodName);
        }
        catch (CancellationException ex) {
            throw new ApiProxy.CancelledException(packageName, methodName);
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            if (ex.getCause() instanceof Error) {
                throw (Error)ex.getCause();
            }
            throw new ApiProxy.UnknownException(packageName, methodName, ex.getCause());
        }
    }

    @Override
    public Future<byte[]> makeAsyncCall(ApiProxy.Environment environment, String packageName, String methodName, byte[] requestBytes, ApiProxy.ApiConfig apiConfig) {
        return this.doAsyncCall(environment, packageName, methodName, requestBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<byte[]> doAsyncCall(ApiProxy.Environment environment, String packageName, String methodName, byte[] requestBytes) {
        Semaphore semaphore = (Semaphore)environment.getAttributes().get("com.google.appengine.tools.development.api_call_semaphore");
        if (semaphore != null) {
            try {
                semaphore.acquire();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Interrupted while waiting on semaphore:", ex);
            }
        }
        AsyncApiCall asyncApiCall = new AsyncApiCall(environment, packageName, methodName, requestBytes, semaphore);
        boolean success = false;
        try {
            Callable<byte[]> callable = Executors.privilegedCallable(asyncApiCall);
            Future<byte[]> result = AccessController.doPrivileged(new PrivilegedApiAction(callable, asyncApiCall));
            success = true;
            Future<byte[]> future = result;
            return future;
        }
        finally {
            if (!success) {
                asyncApiCall.tryReleaseSemaphore();
            }
        }
    }

    private <T> T convertBytesToPb(byte[] bytes, Class<T> requestClass) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        if (ProtocolMessage.class.isAssignableFrom(requestClass)) {
            ProtocolMessage proto = (ProtocolMessage)requestClass.newInstance();
            proto.mergeFrom(bytes);
            return requestClass.cast(proto);
        }
        if (Message.class.isAssignableFrom(requestClass)) {
            Method method = requestClass.getMethod("parseFrom", BYTE_ARRAY_CLASS);
            return requestClass.cast(method.invoke(null, new Object[]{bytes}));
        }
        throw new UnsupportedOperationException("Cannot convert byte[] to " + requestClass);
    }

    private byte[] convertPbToBytes(Object object) {
        if (object instanceof ProtocolMessage) {
            return ((ProtocolMessage)object).toByteArray();
        }
        if (object instanceof Message) {
            return ((Message)object).toByteArray();
        }
        throw new UnsupportedOperationException("Cannot convert " + object + " to byte[].");
    }

    @Override
    public void setProperty(String property, String value) {
        this.properties.put(property, value);
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.properties.clear();
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    @Override
    public void stop() {
        for (LocalRpcService service : this.serviceCache.values()) {
            service.stop();
        }
        this.serviceCache.clear();
    }

    int getMaxApiRequestSize(String packageName) {
        if ("images".equals(packageName)) {
            return 0x2000000;
        }
        if ("memcache".equals(packageName)) {
            return 0x2000000;
        }
        if ("mail".equals(packageName)) {
            return 0x2000000;
        }
        return 0x100000;
    }

    private Method getDispatchMethod(LocalRpcService service, String packageName, String methodName) {
        String dispatchName = Character.toLowerCase(methodName.charAt(0)) + methodName.substring(1);
        for (Method method : service.getClass().getMethods()) {
            if (!dispatchName.equals(method.getName())) continue;
            return method;
        }
        throw new ApiProxy.CallNotFoundException(packageName, methodName);
    }

    @Override
    public final synchronized LocalRpcService getService(final String pkg) {
        LocalRpcService cachedService = this.serviceCache.get(pkg);
        if (cachedService != null) {
            return cachedService;
        }
        return AccessController.doPrivileged(new PrivilegedAction<LocalRpcService>(){

            @Override
            public LocalRpcService run() {
                return ApiProxyLocalImpl.this.startServices(pkg);
            }
        });
    }

    private LocalRpcService startServices(String pkg) {
        Iterator services = Service.providers(LocalRpcService.class, (ClassLoader)ApiProxyLocalImpl.class.getClassLoader());
        while (services.hasNext()) {
            LocalRpcService service = (LocalRpcService)services.next();
            if (!service.getPackage().equals(pkg)) continue;
            service.init(this.context, this.properties);
            service.start();
            this.serviceCache.put(pkg, service);
            return service;
        }
        return null;
    }

    private static Level toJavaLevel(ApiProxy.LogRecord.Level apiProxyLevel) {
        switch (apiProxyLevel) {
            case debug: {
                return Level.FINE;
            }
            case info: {
                return Level.INFO;
            }
            case warn: {
                return Level.WARNING;
            }
            case error: {
                return Level.SEVERE;
            }
            case fatal: {
                return Level.SEVERE;
            }
        }
        return Level.WARNING;
    }

    @Override
    public Clock getClock() {
        return this.clock;
    }

    @Override
    public void setClock(Clock clock) {
        this.clock = clock;
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private final ThreadFactory parent;

        public DaemonThreadFactory(ThreadFactory parent) {
            this.parent = parent;
        }

        public Thread newThread(Runnable r) {
            Thread thread = this.parent.newThread(r);
            thread.setDaemon(true);
            return thread;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsyncApiCall
    implements Callable<byte[]> {
        private final ApiProxy.Environment environment;
        private final String packageName;
        private final String methodName;
        private final byte[] requestBytes;
        private final Semaphore semaphore;
        private boolean released;

        public AsyncApiCall(ApiProxy.Environment environment, String packageName, String methodName, byte[] requestBytes, Semaphore semaphore) {
            this.environment = environment;
            this.packageName = packageName;
            this.methodName = methodName;
            this.requestBytes = requestBytes;
            this.semaphore = semaphore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] call() {
            try {
                byte[] byArray = this.callInternal();
                return byArray;
            }
            finally {
                this.tryReleaseSemaphore();
            }
        }

        private byte[] callInternal() {
            LocalRpcService service = ApiProxyLocalImpl.this.getService(this.packageName);
            if (service == null) {
                throw new ApiProxy.CallNotFoundException(this.packageName, this.methodName);
            }
            if (this.requestBytes.length > ApiProxyLocalImpl.this.getMaxApiRequestSize(this.packageName)) {
                throw new ApiProxy.RequestTooLargeException(this.packageName, this.methodName);
            }
            Method method = ApiProxyLocalImpl.this.getDispatchMethod(service, this.packageName, this.methodName);
            LocalRpcService.Status status = new LocalRpcService.Status();
            ApiProxy.setEnvironmentForCurrentThread(this.environment);
            try {
                Class<?> requestClass = method.getParameterTypes()[1];
                Object request = ApiProxyLocalImpl.this.convertBytesToPb(this.requestBytes, requestClass);
                byte[] byArray = ApiProxyLocalImpl.this.convertPbToBytes(method.invoke((Object)service, status, request));
                return byArray;
            }
            catch (IllegalAccessException e) {
                throw new ApiProxy.UnknownException(this.packageName, this.methodName, e);
            }
            catch (InstantiationException e) {
                throw new ApiProxy.UnknownException(this.packageName, this.methodName, e);
            }
            catch (NoSuchMethodException e) {
                throw new ApiProxy.UnknownException(this.packageName, this.methodName, e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new ApiProxy.UnknownException(this.packageName, this.methodName, e.getCause());
            }
            finally {
                ApiProxy.clearEnvironmentForCurrentThread();
            }
        }

        synchronized void tryReleaseSemaphore() {
            if (!this.released && this.semaphore != null) {
                this.semaphore.release();
                this.released = true;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PrivilegedApiAction
    implements PrivilegedAction<Future<byte[]>> {
        private final Callable<byte[]> callable;
        private final AsyncApiCall asyncApiCall;

        PrivilegedApiAction(Callable<byte[]> callable, AsyncApiCall asyncApiCall) {
            this.callable = callable;
            this.asyncApiCall = asyncApiCall;
        }

        @Override
        public Future<byte[]> run() {
            final Future<byte[]> result = ApiProxyLocalImpl.this.apiExecutor.submit(this.callable);
            return new Future<byte[]>(){

                @Override
                public boolean cancel(final boolean mayInterruptIfRunning) {
                    return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                        @Override
                        public Boolean run() {
                            PrivilegedApiAction.this.asyncApiCall.tryReleaseSemaphore();
                            return result.cancel(mayInterruptIfRunning);
                        }
                    });
                }

                @Override
                public boolean isCancelled() {
                    return result.isCancelled();
                }

                @Override
                public boolean isDone() {
                    return result.isDone();
                }

                @Override
                public byte[] get() throws InterruptedException, ExecutionException {
                    return (byte[])result.get();
                }

                @Override
                public byte[] get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    return (byte[])result.get(timeout, unit);
                }
            };
        }
    }

    private class LocalServiceContextImpl
    implements LocalServiceContext {
        private final LocalServerEnvironment localServerEnvironment;

        public LocalServiceContextImpl(LocalServerEnvironment localServerEnvironment) {
            this.localServerEnvironment = localServerEnvironment;
        }

        public LocalServerEnvironment getLocalServerEnvironment() {
            return this.localServerEnvironment;
        }

        public Clock getClock() {
            return ApiProxyLocalImpl.this.clock;
        }
    }
}

