/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlException;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.QueueXml;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;

public class QueueYamlReader {
    private static final String FILENAME = "queue.yaml";
    private String appDir;

    public QueueYamlReader(String appDir) {
        if (appDir.length() > 0 && appDir.charAt(appDir.length() - 1) != File.separatorChar) {
            appDir = appDir + File.separatorChar;
        }
        this.appDir = appDir;
    }

    public String getFilename() {
        return this.appDir + FILENAME;
    }

    public QueueXml parse() {
        if (new File(this.getFilename()).exists()) {
            try {
                return QueueYamlReader.parse(new FileReader(this.getFilename()));
            }
            catch (FileNotFoundException ex) {
                throw new AppEngineConfigException("Cannot find file " + this.getFilename());
            }
        }
        return null;
    }

    public static QueueXml parse(Reader yaml) {
        YamlReader reader = new YamlReader(yaml);
        reader.getConfig().setPropertyElementType(QueueYaml.class, "queue", QueueYaml.Entry.class);
        try {
            QueueYaml queueYaml = (QueueYaml)reader.read(QueueYaml.class);
            if (queueYaml == null) {
                throw new AppEngineConfigException("Empty queue configuration.");
            }
            return queueYaml.toXml();
        }
        catch (YamlException ex) {
            throw new AppEngineConfigException(ex.getMessage());
        }
    }

    public static QueueXml parse(String yaml) {
        return QueueYamlReader.parse(new StringReader(yaml));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QueueYaml {
        private List<Entry> entries;
        public String total_storage_limit;

        public List<Entry> getQueue() {
            return this.entries;
        }

        public void setQueue(List<Entry> entries) {
            this.entries = entries;
        }

        public QueueXml toXml() {
            QueueXml xml = new QueueXml();
            if (this.total_storage_limit != null) {
                xml.setTotalStorageLimit(this.total_storage_limit);
            }
            if (this.entries != null) {
                for (Entry entry : this.entries) {
                    xml.addEntry(entry.toXml());
                }
            }
            return xml;
        }

        public static class Entry {
            private QueueXml.Entry entry = new QueueXml.Entry();
            private RetryParameters retryParameters;

            public void setName(String name) {
                this.entry.setName(name);
            }

            public String getName() {
                return this.entry.getName();
            }

            public void setRate(String rate) {
                this.entry.setRate(rate);
            }

            public String getRate() {
                return this.entry.getRate() + "/" + this.entry.getRateUnit().getIdent();
            }

            public void setBucket_size(int size) {
                this.entry.setBucketSize(size);
            }

            public int getBucket_size() {
                return this.entry.getBucketSize();
            }

            public void setMax_concurrent_requests(int size) {
                this.entry.setMaxConcurrentRequests(size);
            }

            public int getMax_concurrent_requests() {
                return this.entry.getMaxConcurrentRequests();
            }

            public void setRetry_parameters(RetryParameters retryParameters) {
                this.entry.setRetryParameters(retryParameters.toXml());
                this.retryParameters = retryParameters;
            }

            public RetryParameters getRetry_parameters() {
                return this.retryParameters;
            }

            public QueueXml.Entry toXml() {
                return this.entry;
            }
        }

        public static class RetryParameters {
            private QueueXml.RetryParameters retryParameters = new QueueXml.RetryParameters();

            public void setTask_retry_limit(int limit) {
                this.retryParameters.setRetryLimit(limit);
            }

            public int getTask_retry_limit() {
                return this.retryParameters.getRetryLimit();
            }

            public void setTask_age_limit(String ageLimit) {
                this.retryParameters.setAgeLimitSec(ageLimit);
            }

            public String getTask_age_limit() {
                return this.retryParameters.getAgeLimitSec().toString() + "s";
            }

            public void setMin_backoff_seconds(double backoff) {
                this.retryParameters.setMinBackoffSec(backoff);
            }

            public double getMin_backoff_seconds() {
                return this.retryParameters.getMinBackoffSec();
            }

            public void setMax_backoff_seconds(double backoff) {
                this.retryParameters.setMaxBackoffSec(backoff);
            }

            public double getMax_backoff_seconds() {
                return this.retryParameters.getMaxBackoffSec();
            }

            public void setMax_doublings(int doublings) {
                this.retryParameters.setMaxDoublings(doublings);
            }

            public int getMax_doublings() {
                return this.retryParameters.getMaxDoublings();
            }

            public QueueXml.RetryParameters toXml() {
                return this.retryParameters;
            }
        }
    }
}

