/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.net.base;

import com.google.appengine.repackaged.com.google.common.base.Pair;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.net.InetAddresses;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CidrAddressBlock {
    private static final Logger logger = Logger.getLogger(CidrAddressBlock.class.getName());
    private final InetAddress ip;
    private final int netmask;

    public CidrAddressBlock(String s) throws IllegalArgumentException {
        this(CidrAddressBlock.parseString(s));
    }

    public CidrAddressBlock(String ip, int netmask) throws IllegalArgumentException {
        this(InetAddresses.forString(ip), netmask);
    }

    private CidrAddressBlock(Pair<InetAddress, Integer> cidrPair) throws IllegalArgumentException {
        this(cidrPair.getFirst(), (int)cidrPair.getSecond());
    }

    public CidrAddressBlock(InetAddress ip) throws IllegalArgumentException {
        this(ip, ip instanceof Inet4Address ? 32 : 128);
    }

    public CidrAddressBlock(InetAddress ip, int netmask) throws IllegalArgumentException {
        try {
            Preconditions.checkNotNull(ip);
        }
        catch (NullPointerException npe) {
            throw new IllegalArgumentException("Null InetAddress");
        }
        byte[] bytes = ip.getAddress();
        Preconditions.checkArgument(netmask >= 0 && netmask <= bytes.length * 8, "CIDR netmask '%d' is out of range: 0 <= netmask <= %d.", netmask, bytes.length * 8);
        this.ip = ip;
        this.netmask = netmask;
        InetAddress truncatedIp = CidrAddressBlock.applyNetmask(this.ip, this.netmask);
        if (!truncatedIp.equals(this.ip)) {
            throw new IllegalArgumentException("CIDR block: " + CidrAddressBlock.getCidrString(this.ip, this.netmask) + " is not properly truncated, should have been: " + CidrAddressBlock.getCidrString(truncatedIp, this.netmask));
        }
    }

    public static CidrAddressBlock create(InetAddress ip, int netmask) throws IllegalArgumentException, NullPointerException {
        Preconditions.checkNotNull(ip);
        return new CidrAddressBlock(CidrAddressBlock.applyNetmask(ip, netmask), netmask);
    }

    public static CidrAddressBlock create(String s) throws IllegalArgumentException, NullPointerException {
        Preconditions.checkNotNull(s);
        Pair<InetAddress, Integer> cidrPair = CidrAddressBlock.parseString(s);
        return CidrAddressBlock.create(cidrPair.getFirst(), cidrPair.getSecond());
    }

    private static String getCidrString(InetAddress ip, int netmask) {
        return ip.getHostAddress() + "/" + netmask;
    }

    private static Pair<InetAddress, Integer> parseString(String s) throws IllegalArgumentException {
        int netmask;
        InetAddress ip;
        Preconditions.checkArgument(s != null, "Null argument passed to constructor");
        int slash = s.indexOf(47);
        if (slash > -1) {
            ip = InetAddresses.forString(s.substring(0, slash));
            try {
                netmask = Integer.parseInt(s.substring(slash + 1));
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Invalid netmask: " + s.substring(slash + 1));
            }
        } else {
            ip = InetAddresses.forString(s);
            netmask = ip instanceof Inet4Address ? 32 : 128;
        }
        return Pair.of(ip, netmask);
    }

    private static InetAddress applyNetmask(InetAddress ip, int netmask) throws IllegalArgumentException {
        InetAddress truncatedIp;
        byte[] bytes = ip.getAddress();
        Preconditions.checkArgument(netmask >= 0 && netmask <= bytes.length * 8, "CIDR netmask '%d' is out of range: 0 <= netmask <= %d.", netmask, bytes.length * 8);
        int cidrByte = netmask == 0 ? 0 : (netmask - 1) / 8;
        int numBits = netmask - cidrByte * 8;
        int bitMask = -1 << 8 - numBits;
        bytes[cidrByte] = (byte)(bytes[cidrByte] & bitMask);
        for (int i = cidrByte + 1; i < bytes.length; ++i) {
            bytes[i] = 0;
        }
        try {
            truncatedIp = InetAddress.getByAddress(bytes);
        }
        catch (UnknownHostException uhe) {
            throw new IllegalArgumentException(String.format("Error creating InetAddress from byte array '%s'.", Arrays.toString(bytes)), uhe);
        }
        return truncatedIp;
    }

    public String getIp() {
        return this.ip.getHostAddress();
    }

    public InetAddress getInetAddress() {
        return this.ip;
    }

    public int getNumBlockBits() {
        return this.netmask;
    }

    public int getNetmask() {
        return this.netmask;
    }

    public boolean contains(InetAddress ipAddr) {
        InetAddress truncated;
        if (ipAddr == null) {
            return false;
        }
        if (ipAddr.getClass() != this.ip.getClass()) {
            return false;
        }
        try {
            truncated = CidrAddressBlock.applyNetmask(ipAddr, this.netmask);
        }
        catch (IllegalArgumentException iae) {
            logger.warning(iae.getMessage());
            return false;
        }
        return this.ip.equals(truncated);
    }

    public boolean contains(CidrAddressBlock cidr) {
        if (cidr == null) {
            return false;
        }
        if (cidr.netmask < this.netmask) {
            return false;
        }
        return this.contains(cidr.getInetAddress());
    }

    public boolean contains(String s) {
        CidrAddressBlock cidr;
        if (s == null) {
            return false;
        }
        try {
            cidr = CidrAddressBlock.create(s);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        return this.contains(cidr);
    }

    public int hashCode() {
        return InetAddresses.coerceToInteger(this.ip);
    }

    public boolean equals(Object o) {
        if (!(o instanceof CidrAddressBlock)) {
            return false;
        }
        CidrAddressBlock cidr = (CidrAddressBlock)o;
        return this.ip.equals(cidr.ip) && this.netmask == cidr.netmask;
    }

    public String toString() {
        return CidrAddressBlock.getCidrString(this.ip, this.netmask);
    }
}

