/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.apphosting.utils.config.AppEngineConfigException;
import java.security.Permissions;
import java.security.UnresolvedPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppEngineWebXml {
    private final Map<String, String> systemProperties = Maps.newHashMap();
    private final Map<String, String> envVariables = Maps.newHashMap();
    private final List<UserPermission> userPermissions = new ArrayList<UserPermission>();
    static final String WARMUP_SERVICE = "warmup";
    private String appId;
    private String majorVersionId;
    private boolean sslEnabled = true;
    private boolean useSessions = false;
    private final List<StaticFileInclude> staticFileIncludes;
    private final List<String> staticFileExcludes;
    private final List<String> resourceFileIncludes;
    private final List<String> resourceFileExcludes;
    private Pattern staticIncludePattern;
    private Pattern staticExcludePattern;
    private Pattern resourceIncludePattern;
    private Pattern resourceExcludePattern;
    private String publicRoot = "";
    private String appRoot;
    private final Set<String> inboundServices;
    private boolean precompilationEnabled = true;
    private final List<AdminConsolePage> adminConsolePages = new ArrayList<AdminConsolePage>();
    private final List<ErrorHandler> errorHandlers = new ArrayList<ErrorHandler>();

    public AppEngineWebXml() {
        this.staticFileIncludes = new ArrayList<StaticFileInclude>();
        this.staticFileExcludes = new ArrayList<String>();
        this.staticFileExcludes.add("WEB-INF/**");
        this.staticFileExcludes.add("**.jsp");
        this.resourceFileIncludes = new ArrayList<String>();
        this.resourceFileExcludes = new ArrayList<String>();
        this.inboundServices = new LinkedHashSet<String>();
    }

    public Map<String, String> getSystemProperties() {
        return Collections.unmodifiableMap(this.systemProperties);
    }

    public void addSystemProperty(String key, String value) {
        this.systemProperties.put(key, value);
    }

    public Map<String, String> getEnvironmentVariables() {
        return Collections.unmodifiableMap(this.envVariables);
    }

    public void addEnvironmentVariable(String key, String value) {
        this.envVariables.put(key, value);
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getMajorVersionId() {
        return this.majorVersionId;
    }

    public void setMajorVersionId(String majorVersionId) {
        this.majorVersionId = majorVersionId;
    }

    public void setSslEnabled(boolean ssl) {
        this.sslEnabled = ssl;
    }

    public boolean getSslEnabled() {
        return this.sslEnabled;
    }

    public void setSessionsEnabled(boolean sessions) {
        this.useSessions = sessions;
    }

    public boolean getSessionsEnabled() {
        return this.useSessions;
    }

    public List<StaticFileInclude> getStaticFileIncludes() {
        return this.staticFileIncludes;
    }

    public List<String> getStaticFileExcludes() {
        return this.staticFileExcludes;
    }

    public void includeStaticPattern(String pattern, String expiration) {
        this.staticIncludePattern = null;
        this.staticFileIncludes.add(new StaticFileInclude(pattern, expiration));
    }

    public void excludeStaticPattern(String url) {
        this.staticExcludePattern = null;
        this.staticFileExcludes.add(url);
    }

    public List<String> getResourcePatterns() {
        return this.resourceFileIncludes;
    }

    public List<String> getResourceFileExcludes() {
        return this.resourceFileExcludes;
    }

    public void includeResourcePattern(String url) {
        this.resourceExcludePattern = null;
        this.resourceFileIncludes.add(url);
    }

    public void excludeResourcePattern(String url) {
        this.resourceIncludePattern = null;
        this.resourceFileExcludes.add(url);
    }

    public void addUserPermission(String className, String name, String actions) {
        if (className.startsWith("java.")) {
            throw new AppEngineConfigException("Cannot specify user-permissions for classes in java.* packages.");
        }
        this.userPermissions.add(new UserPermission(className, name, actions));
    }

    public Permissions getUserPermissions() {
        Permissions permissions = new Permissions();
        for (UserPermission permission : this.userPermissions) {
            permissions.add(new UnresolvedPermission(permission.getClassName(), permission.getName(), permission.getActions(), null));
        }
        permissions.setReadOnly();
        return permissions;
    }

    public void setPublicRoot(String root) {
        if (root.indexOf(42) != -1) {
            throw new AppEngineConfigException("public-root cannot contain wildcards");
        }
        if (root.endsWith("/")) {
            root = root.substring(0, root.length() - 1);
        }
        if (root.length() > 0 && !root.startsWith("/")) {
            root = "/" + root;
        }
        this.staticIncludePattern = null;
        this.publicRoot = root;
    }

    public String getPublicRoot() {
        return this.publicRoot;
    }

    public void addInboundService(String service) {
        this.inboundServices.add(service);
    }

    public Set<String> getInboundServices() {
        return this.inboundServices;
    }

    public boolean getPrecompilationEnabled() {
        return this.precompilationEnabled;
    }

    public void setPrecompilationEnabled(boolean precompilationEnabled) {
        this.precompilationEnabled = precompilationEnabled;
    }

    public boolean getWarmupRequestsEnabled() {
        return this.inboundServices.contains(WARMUP_SERVICE);
    }

    public void setWarmupRequestsEnabled(boolean warmupRequestsEnabled) {
        if (warmupRequestsEnabled) {
            this.inboundServices.add(WARMUP_SERVICE);
        } else {
            this.inboundServices.remove(WARMUP_SERVICE);
        }
    }

    public List<AdminConsolePage> getAdminConsolePages() {
        return Collections.unmodifiableList(this.adminConsolePages);
    }

    public void addAdminConsolePage(AdminConsolePage page) {
        this.adminConsolePages.add(page);
    }

    public List<ErrorHandler> getErrorHandlers() {
        return Collections.unmodifiableList(this.errorHandlers);
    }

    public void addErrorHandler(ErrorHandler handler) {
        this.errorHandlers.add(handler);
    }

    public String toString() {
        return "App Id: " + this.appId + "\nApp Version: " + this.majorVersionId + "\nSystem props: " + this.systemProperties.toString() + "\nEnv variables: " + this.envVariables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppEngineWebXml that = (AppEngineWebXml)o;
        if (this.appId != null ? !this.appId.equals(that.appId) : that.appId != null) {
            return false;
        }
        if (!((Object)this.envVariables).equals(that.envVariables)) {
            return false;
        }
        if (!((Object)this.systemProperties).equals(that.systemProperties)) {
            return false;
        }
        if (!((Object)this.userPermissions).equals(that.userPermissions)) {
            return false;
        }
        if (this.majorVersionId != null ? !this.majorVersionId.equals(that.majorVersionId) : that.majorVersionId != null) {
            return false;
        }
        if (this.precompilationEnabled != that.precompilationEnabled) {
            return false;
        }
        if (!((Object)this.adminConsolePages).equals(that.adminConsolePages)) {
            return false;
        }
        return ((Object)this.errorHandlers).equals(that.errorHandlers);
    }

    public int hashCode() {
        int result = ((Object)this.systemProperties).hashCode();
        result = 31 * result + ((Object)this.envVariables).hashCode();
        result = 31 * result + (this.appId != null ? this.appId.hashCode() : 0);
        result = 31 * result + (this.majorVersionId != null ? this.majorVersionId.hashCode() : 0);
        return result;
    }

    public boolean includesResource(String path) {
        if (this.resourceIncludePattern == null) {
            this.resourceIncludePattern = this.resourceFileIncludes.size() == 0 ? Pattern.compile(".*") : Pattern.compile(this.makeRegexp(this.resourceFileIncludes));
        }
        if (this.resourceExcludePattern == null && this.resourceFileExcludes.size() > 0) {
            this.resourceExcludePattern = Pattern.compile(this.makeRegexp(this.resourceFileExcludes));
        }
        return this.includes(path, this.resourceIncludePattern, this.resourceExcludePattern);
    }

    public boolean includesStatic(String path) {
        if (this.staticIncludePattern == null) {
            if (this.staticFileIncludes.size() == 0) {
                String staticRoot = this.publicRoot.length() > 0 ? this.publicRoot + "/**" : "**";
                this.staticIncludePattern = Pattern.compile(this.makeRegexp(Collections.singletonList(staticRoot)));
            } else {
                ArrayList<String> patterns = new ArrayList<String>();
                for (StaticFileInclude include : this.staticFileIncludes) {
                    patterns.add(include.getPattern());
                }
                this.staticIncludePattern = Pattern.compile(this.makeRegexp(patterns));
            }
        }
        if (this.staticExcludePattern == null && this.staticFileExcludes.size() > 0) {
            this.staticExcludePattern = Pattern.compile(this.makeRegexp(this.staticFileExcludes));
        }
        return this.includes(path, this.staticIncludePattern, this.staticExcludePattern);
    }

    public boolean includes(String path, Pattern includes, Pattern excludes) {
        assert (includes != null);
        if (!includes.matcher(path).matches()) {
            return false;
        }
        return excludes == null || !excludes.matcher(path).matches();
    }

    public String makeRegexp(List<String> patterns) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String item : patterns) {
            if (first) {
                first = false;
            } else {
                builder.append('|');
            }
            while (item.charAt(0) == '/') {
                item = item.substring(1);
            }
            builder.append('(');
            if (this.appRoot != null) {
                builder.append(AppEngineWebXml.makeFileRegex(this.appRoot));
            }
            builder.append("/");
            builder.append(AppEngineWebXml.makeFileRegex(item));
            builder.append(')');
        }
        return builder.toString();
    }

    static String makeFileRegex(String fileGlob) {
        fileGlob = fileGlob.replaceAll("([^A-Za-z0-9\\-_/])", "\\\\$1");
        fileGlob = fileGlob.replaceAll("\\\\\\*\\\\\\*", ".*");
        fileGlob = fileGlob.replaceAll("\\\\\\*", "[^/]*");
        return fileGlob;
    }

    public void setSourcePrefix(String appRoot) {
        this.appRoot = appRoot;
    }

    public static class ErrorHandler {
        private final String file;
        private final String errorCode;

        public ErrorHandler(String file, String errorCode) {
            this.file = file;
            this.errorCode = errorCode;
        }

        public String getFile() {
            return this.file;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
            result = 31 * result + (this.errorCode == null ? 0 : this.errorCode.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ErrorHandler)) {
                return false;
            }
            ErrorHandler handler = (ErrorHandler)obj;
            if (!this.file.equals(handler.file)) {
                return false;
            }
            return !(this.errorCode == null ? handler.errorCode != null : !this.errorCode.equals(handler.errorCode));
        }
    }

    public static class AdminConsolePage {
        private final String name;
        private final String url;

        public AdminConsolePage(String name, String url) {
            this.name = name;
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AdminConsolePage other = (AdminConsolePage)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.url == null ? other.url != null : !this.url.equals(other.url));
        }
    }

    public static class StaticFileInclude {
        private final String pattern;
        private final String expiration;

        public StaticFileInclude(String pattern, String expiration) {
            this.pattern = pattern;
            this.expiration = expiration;
        }

        public String getPattern() {
            return this.pattern;
        }

        public String getExpiration() {
            return this.expiration;
        }

        public int hashCode() {
            return this.pattern.hashCode() * 31 + this.expiration.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof StaticFileInclude) {
                StaticFileInclude include = (StaticFileInclude)obj;
                if (this.pattern.equals(include.pattern) && (this.expiration == null ? include.expiration == null : this.expiration.equals(include.expiration))) {
                    return true;
                }
            }
            return false;
        }
    }

    private static class UserPermission {
        private final String className;
        private final String name;
        private final String actions;
        private boolean hasHashCode = false;
        private int hashCode;

        public UserPermission(String className, String name, String actions) {
            this.className = className;
            this.name = name;
            this.actions = actions;
        }

        public String getClassName() {
            return this.className;
        }

        public String getName() {
            return this.name;
        }

        public String getActions() {
            return this.actions;
        }

        public int hashCode() {
            if (this.hasHashCode) {
                return this.hashCode;
            }
            int hash = this.className.hashCode();
            hash = 31 * hash + this.name.hashCode();
            if (this.actions != null) {
                hash = 31 * hash + this.actions.hashCode();
            }
            this.hashCode = hash;
            this.hasHashCode = true;
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof UserPermission) {
                UserPermission perm = (UserPermission)obj;
                if (this.className.equals(perm.className) && this.name.equals(perm.name) && (this.actions == null ? perm.actions == null : this.actions.equals(perm.actions))) {
                    return true;
                }
            }
            return false;
        }
    }
}

