/*
 * Decompiled with CFR 0.152.
 */
package play.modules.gae;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.appengine.api.urlfetch.URLFetchServiceFactory;
import com.google.appengine.api.users.User;
import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import play.mvc.Http;
import play.mvc.Router;
import play.mvc.results.Redirect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GAE {
    public static DatastoreService getDatastore() {
        return DatastoreServiceFactory.getDatastoreService();
    }

    public static UserService getUserService() {
        return UserServiceFactory.getUserService();
    }

    public static URLFetchService getURLFetchService() {
        return URLFetchServiceFactory.getURLFetchService();
    }

    public static void login(String returnAction, Map<String, Object> returnParams, String federatedIdentity) {
        GAE.login(returnAction, returnParams, federatedIdentity, new HashSet<String>());
    }

    public static void login(String returnAction, String federatedIdentity) {
        GAE.login(returnAction, null, federatedIdentity, new HashSet<String>());
    }

    public static void login(String returnAction, String federatedIdentity, Set<String> attributesRequest) {
        GAE.login(returnAction, null, federatedIdentity, attributesRequest);
    }

    public static void login(String returnAction, Map<String, Object> returnParams, String federatedIdentity, Set<String> attributesRequest) {
        if (returnAction == null || returnAction.isEmpty()) {
            throw new IllegalArgumentException("Empty action");
        }
        if (returnParams == null || returnParams.isEmpty()) {
            returnParams = new HashMap<String, Object>();
        }
        String returnURL = Router.getFullUrl((String)returnAction, returnParams);
        String url = null;
        url = federatedIdentity != null ? GAE.getUserService().createLoginURL(returnURL, null, federatedIdentity, attributesRequest) : GAE.getUserService().createLoginURL(returnURL);
        throw new Redirect(url);
    }

    public static void login(String returnAction, Map<String, Object> returnParams) {
        GAE.login(returnAction, returnParams, null, null);
    }

    public static void login(String returnAction) {
        GAE.login(returnAction, null, null, null);
    }

    public static void login() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (Map.Entry param : Http.Request.current().routeArgs.entrySet()) {
            params.put((String)param.getKey(), param.getValue());
        }
        GAE.login(Http.Request.current().action, params);
    }

    public static User getUser() {
        return GAE.getUserService().getCurrentUser();
    }

    public static boolean isLoggedIn() {
        return GAE.getUserService().isUserLoggedIn();
    }

    public static boolean isAdmin() {
        return GAE.getUserService().isUserAdmin();
    }

    public static void logout(String returnAction) {
        String returnURL = Router.getFullUrl((String)returnAction);
        String url = GAE.getUserService().createLogoutURL(returnURL);
        throw new Redirect(url);
    }

    public static void logout() {
        GAE.logout(Http.Request.current().action);
    }
}

