/*
 * Decompiled with CFR 0.152.
 */
package play.modules.gae;

import com.google.apphosting.api.ApiProxy;
import java.io.File;
import java.util.Properties;
import javax.mail.Session;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.cache.Cache;
import play.jobs.JobsPlugin;
import play.libs.IO;
import play.libs.Mail;
import play.modules.gae.GAECache;
import play.modules.gae.PlayDevEnvironment;
import play.mvc.Router;

public class GAEPlugin
extends PlayPlugin {
    public PlayDevEnvironment devEnvironment = null;
    public boolean prodGAE;

    public void onLoad() {
        Play.pluginCollection.disablePlugin(JobsPlugin.class);
        if (ApiProxy.getCurrentEnvironment() == null) {
            File webInf;
            Logger.warn((String)"", (Object[])new Object[0]);
            Logger.warn((String)"Google App Engine module", (Object[])new Object[0]);
            Logger.warn((String)"~~~~~~~~~~~~~~~~~~~~~~~", (Object[])new Object[0]);
            Logger.warn((String)"No Google App Engine environment found. Setting up a development environement", (Object[])new Object[0]);
            this.devEnvironment = PlayDevEnvironment.create();
            System.setProperty("appengine.orm.disable.duplicate.emf.exception", "yes");
            File warExt = Play.getFile((String)"war");
            if (!warExt.exists()) {
                warExt.mkdir();
            }
            if (!(webInf = Play.getFile((String)"war/WEB-INF")).exists()) {
                webInf.mkdir();
            }
            File xml = Play.getFile((String)"war/WEB-INF/appengine-web.xml");
            try {
                if (!xml.exists()) {
                    IO.writeContent((CharSequence)"<appengine-web-app xmlns=\"http://appengine.google.com/ns/1.0\">\n\t<application><!-- Replace this with your application id from http://appengine.google.com --></application>\n\t<version>1</version>\n\t<threadsafe>true</threadsafe>\n</appengine-web-app>\n", (File)xml);
                }
                if (IO.readContentAsString((File)xml).contains("<!-- Replace this with your application id from http://appengine.google.com -->")) {
                    Logger.warn((String)"Don't forget to define your GAE application id in the 'war/WEB-INF/appengine-web.xml' file", (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                Logger.error((Throwable)e, (String)"Cannot init GAE files", (Object[])new Object[0]);
            }
            Logger.warn((String)"", (Object[])new Object[0]);
        } else {
            Play.mode = Play.Mode.PROD;
            this.prodGAE = true;
        }
    }

    public void onRoutesLoaded() {
        Router.addRoute((String)"GET", (String)"/_ah/login", (String)"GAEActions.login");
        Router.addRoute((String)"POST", (String)"/_ah/login", (String)"GAEActions.doLogin");
        Router.addRoute((String)"GET", (String)"/_ah/logout", (String)"GAEActions.logout");
    }

    public void onApplicationStart() {
        if (this.devEnvironment == null) {
            Cache.forcedCacheImpl = new GAECache();
        }
        Mail.session = Session.getDefaultInstance((Properties)new Properties(), null);
        Mail.asynchronousSend = false;
    }

    public void beforeInvocation() {
        if (this.devEnvironment != null) {
            ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)new PlayDevEnvironment());
        }
    }

    public void onConfigurationRead() {
        if (this.devEnvironment == null) {
            Play.configuration.remove("smtp.mock");
            Play.configuration.setProperty("application.log", "DEBUG");
        }
        Play.configuration.setProperty("webservice", "urlfetch");
        Play.configuration.setProperty("upload.threshold", "2147483647");
    }
}

