/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.rdbms.dev;

import com.google.cloud.sql.jdbc.internal.ConnectionProperty;
import com.google.cloud.sql.jdbc.internal.DataTypeConverter;
import com.google.cloud.sql.jdbc.internal.JdbcType;
import com.google.protos.cloud.sql.Client;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Util {
    private static final Logger logger = Logger.getLogger(Util.class.getCanonicalName());

    private Util() {
    }

    static Properties getUserNameAndPasswordProperties(Map<String, String> map) {
        String password;
        Properties p = new Properties();
        String user = map.get(ConnectionProperty.USER.key());
        if (user != null) {
            p.put(ConnectionProperty.USER.key(), user);
        }
        if ((password = map.get(ConnectionProperty.PASSWORD.key())) != null) {
            p.put(ConnectionProperty.PASSWORD.key(), password);
        }
        return p;
    }

    static String getDatabase(Map<String, String> map) {
        return map.get(ConnectionProperty.DATABASE.key());
    }

    static Map<String, String> toPropertyMap(List<Client.Property> properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Client.Property p : properties) {
            map.put(p.getKey(), p.getValue());
        }
        return map;
    }

    static Map<String, String> concat(Map<String, String> map1, Map<String, String> map2) {
        HashMap<String, String> result = new HashMap<String, String>(map1);
        result.putAll(map2);
        return result;
    }

    static Map<String, String> copyAndAdd(String key, String value, Map<String, String> map) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(key, value);
        result.putAll(map);
        return result;
    }

    static Client.SqlException toClientSqlException(SQLException e) {
        Client.SqlException.Builder builder = Client.SqlException.newBuilder();
        builder.setCode(e.getErrorCode());
        if (e.getSQLState() != null) {
            builder.setSqlState(e.getSQLState());
        }
        if (e.getMessage() != null) {
            builder.setMessage(e.getMessage());
        }
        return builder.build();
    }

    static <T> T bindVariableToObject(Client.BindVariableProto bv, Class<T> clazz) throws SQLException {
        DataTypeConverter converter = JdbcType.fromCode((int)bv.getType()).getConverter();
        if (bv.hasValue()) {
            return clazz.cast(converter.toObject(bv.getValue()));
        }
        return null;
    }

    static SQLException closeAll(Statement statement, ResultSet rs) {
        SQLException exception = Util.close(rs);
        SQLException closeException = Util.close(statement);
        if (exception == null) {
            exception = closeException;
        }
        return exception;
    }

    static SQLException close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.log(Level.SEVERE, "Could not close the ResultSet", e);
                return e;
            }
        }
        return null;
    }

    static SQLException close(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                logger.log(Level.SEVERE, "Could not close the Statement", e);
                return e;
            }
        }
        return null;
    }
}

