/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.SearchQueryException;
import com.google.appengine.api.search.query.QueryParserFactory;
import com.google.appengine.api.search.query.QueryTreeBuilder;
import com.google.appengine.repackaged.org.antlr.runtime.RecognitionException;
import com.google.appengine.repackaged.org.antlr.runtime.Token;
import com.google.appengine.repackaged.org.antlr.runtime.tree.CommonTree;
import com.google.appengine.repackaged.org.antlr.runtime.tree.Tree;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class SnippetExpressionQueryParser {
    private final List<String> tokens = new ArrayList<String>();
    private final String fieldName;

    public SnippetExpressionQueryParser(String fieldName) {
        this.fieldName = fieldName == null ? "" : fieldName;
    }

    public List<String> parse(String query) {
        try {
            CommonTree tree = new QueryTreeBuilder(new QueryParserFactory()).parse(query);
            if (!tree.isNil()) {
                throw new SearchQueryException("AST is missing nil root " + query);
            }
            if (tree.getChildCount() == 0) {
                return null;
            }
            this.getTokens(tree.getChild(0));
            return this.tokens;
        }
        catch (RecognitionException e) {
            throw new SearchQueryException("Failed to parse " + query);
        }
    }

    private void textQuery(Tree tree) {
        int type = tree.getChild(0).getType();
        String textToMatch = tree.getChild(1).getText();
        if (13 != type) {
            this.tokens.add(textToMatch);
        } else {
            StringTokenizer st = new StringTokenizer(textToMatch);
            while (st.hasMoreTokens()) {
                this.tokens.add(st.nextToken());
            }
        }
    }

    private void getTokens(Tree tree) {
        if (tree == null) {
            throw new SearchQueryException("Unexpected null node encountered");
        }
        switch (tree.getType()) {
            case 4: 
            case 5: 
            case 9: {
                for (int i = 0; i < tree.getChildCount(); ++i) {
                    this.getTokens(tree.getChild(i));
                }
                break;
            }
            case 12: {
                if (tree.getChildCount() != 2) {
                    throw new SearchQueryException("Invalid restriction found");
                }
                Token restriction = ((CommonTree)tree.getChild(0)).getToken();
                if (restriction.getType() == 10) {
                    this.getTokens(tree.getChild(1));
                    break;
                }
                if (!this.fieldName.equals(restriction.getText())) break;
                this.getTokens(tree.getChild(1));
                break;
            }
            case 15: {
                this.textQuery(tree);
                break;
            }
            case 7: 
            case 16: {
                this.getTokens(tree.getChild(0));
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            default: {
                throw new SearchQueryException("Not yet implemented: " + tree.getType());
            }
        }
    }
}

