/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.BlobstoreFailureException;
import com.google.appengine.api.blobstore.BlobstoreService;
import com.google.appengine.api.blobstore.BlobstoreServicePb;
import com.google.appengine.api.blobstore.ByteRange;
import com.google.appengine.api.blobstore.UnsupportedRangeFormatException;
import com.google.appengine.api.blobstore.UploadOptions;
import com.google.apphosting.api.ApiProxy;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class BlobstoreServiceImpl
implements BlobstoreService {
    static final String PACKAGE = "blobstore";
    static final String SERVE_HEADER = "X-AppEngine-BlobKey";
    static final String UPLOADED_BLOBKEY_ATTR = "com.google.appengine.api.blobstore.upload.blobkeys";
    static final String BLOB_RANGE_HEADER = "X-AppEngine-BlobRange";

    BlobstoreServiceImpl() {
    }

    @Override
    public String createUploadUrl(String successPath) {
        return this.createUploadUrl(successPath, UploadOptions.Builder.withDefaults());
    }

    @Override
    public String createUploadUrl(String successPath, UploadOptions uploadOptions) {
        byte[] responseBytes;
        if (successPath == null) {
            throw new NullPointerException("Success path must not be null.");
        }
        BlobstoreServicePb.CreateUploadURLRequest request = new BlobstoreServicePb.CreateUploadURLRequest();
        request.setSuccessPath(successPath);
        if (uploadOptions.hasMaxUploadSizeBytesPerBlob()) {
            request.setMaxUploadSizePerBlobBytes(uploadOptions.getMaxUploadSizeBytesPerBlob());
        }
        if (uploadOptions.hasMaxUploadSizeBytes()) {
            request.setMaxUploadSizeBytes(uploadOptions.getMaxUploadSizeBytes());
        }
        try {
            responseBytes = ApiProxy.makeSyncCall(PACKAGE, "CreateUploadURL", request.toByteArray());
        }
        catch (ApiProxy.ApplicationException ex) {
            switch (BlobstoreServicePb.BlobstoreServiceError.ErrorCode.valueOf(ex.getApplicationError())) {
                case URL_TOO_LONG: {
                    throw new IllegalArgumentException("The resulting URL was too long.");
                }
                case INTERNAL_ERROR: {
                    throw new BlobstoreFailureException("An internal blobstore error occured.");
                }
            }
            throw new BlobstoreFailureException("An unexpected error occurred.", ex);
        }
        BlobstoreServicePb.CreateUploadURLResponse response = new BlobstoreServicePb.CreateUploadURLResponse();
        response.mergeFrom(responseBytes);
        return response.getUrl();
    }

    @Override
    public void serve(BlobKey blobKey, HttpServletResponse response) {
        this.serve(blobKey, (ByteRange)null, response);
    }

    @Override
    public void serve(BlobKey blobKey, String rangeHeader, HttpServletResponse response) {
        this.serve(blobKey, ByteRange.parse(rangeHeader), response);
    }

    @Override
    public void serve(BlobKey blobKey, ByteRange byteRange, HttpServletResponse response) {
        if (response.isCommitted()) {
            throw new IllegalStateException("Response was already committed.");
        }
        response.setStatus(200);
        response.setHeader(SERVE_HEADER, blobKey.getKeyString());
        if (byteRange != null) {
            response.setHeader(BLOB_RANGE_HEADER, byteRange.toString());
        }
    }

    @Override
    public ByteRange getByteRange(HttpServletRequest request) {
        Enumeration rangeHeaders = request.getHeaders("range");
        if (!rangeHeaders.hasMoreElements()) {
            return null;
        }
        String rangeHeader = (String)rangeHeaders.nextElement();
        if (rangeHeaders.hasMoreElements()) {
            throw new UnsupportedRangeFormatException("Cannot accept multiple range headers.");
        }
        return ByteRange.parse(rangeHeader);
    }

    @Override
    public void delete(BlobKey ... blobKeys) {
        BlobstoreServicePb.DeleteBlobRequest request = new BlobstoreServicePb.DeleteBlobRequest();
        for (BlobKey blobKey : blobKeys) {
            request.addBlobKey(blobKey.getKeyString());
        }
        if (request.blobKeySize() == 0) {
            return;
        }
        try {
            byte[] responseBytes = ApiProxy.makeSyncCall(PACKAGE, "DeleteBlob", request.toByteArray());
        }
        catch (ApiProxy.ApplicationException ex) {
            switch (BlobstoreServicePb.BlobstoreServiceError.ErrorCode.valueOf(ex.getApplicationError())) {
                case INTERNAL_ERROR: {
                    throw new BlobstoreFailureException("An internal blobstore error occured.");
                }
            }
            throw new BlobstoreFailureException("An unexpected error occurred.", ex);
        }
    }

    @Override
    public Map<String, BlobKey> getUploadedBlobs(HttpServletRequest request) {
        Map attributes = (Map)request.getAttribute(UPLOADED_BLOBKEY_ATTR);
        if (attributes == null) {
            throw new IllegalStateException("Must be called from a blob upload callback request.");
        }
        HashMap<String, BlobKey> blobKeys = new HashMap<String, BlobKey>(attributes.size());
        for (Map.Entry attr : attributes.entrySet()) {
            blobKeys.put((String)attr.getKey(), new BlobKey((String)attr.getValue()));
        }
        return blobKeys;
    }

    @Override
    public byte[] fetchData(BlobKey blobKey, long startIndex, long endIndex) {
        byte[] responseBytes;
        if (startIndex < 0L) {
            throw new IllegalArgumentException("Start index must be >= 0.");
        }
        if (endIndex < startIndex) {
            throw new IllegalArgumentException("End index must be >= startIndex.");
        }
        long fetchSize = endIndex - startIndex + 1L;
        if (fetchSize > 1015808L) {
            throw new IllegalArgumentException("Blob fetch size " + fetchSize + " it larger " + "than maximum size " + 1015808 + " bytes.");
        }
        BlobstoreServicePb.FetchDataRequest request = new BlobstoreServicePb.FetchDataRequest();
        request.setBlobKey(blobKey.getKeyString());
        request.setStartIndex(startIndex);
        request.setEndIndex(endIndex);
        try {
            responseBytes = ApiProxy.makeSyncCall(PACKAGE, "FetchData", request.toByteArray());
        }
        catch (ApiProxy.ApplicationException ex) {
            switch (BlobstoreServicePb.BlobstoreServiceError.ErrorCode.valueOf(ex.getApplicationError())) {
                case PERMISSION_DENIED: {
                    throw new SecurityException("This application does not have access to that blob.");
                }
                case BLOB_NOT_FOUND: {
                    throw new IllegalArgumentException("Blob not found.");
                }
                case INTERNAL_ERROR: {
                    throw new BlobstoreFailureException("An internal blobstore error occured.");
                }
            }
            throw new BlobstoreFailureException("An unexpected error occurred.", ex);
        }
        BlobstoreServicePb.FetchDataResponse response = new BlobstoreServicePb.FetchDataResponse();
        response.mergeFrom(responseBytes);
        return response.getDataAsBytes();
    }
}

