/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.log;

import com.google.appengine.api.log.LogQuery;
import com.google.appengine.api.log.LogServiceImpl;
import com.google.appengine.api.log.RequestLogs;
import com.google.appengine.repackaged.com.google.common.collect.AbstractIterator;
import com.google.apphosting.api.logservice.LogServicePb;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class LogQueryResult
implements Serializable,
Iterable<RequestLogs> {
    private final List<RequestLogs> logs = new ArrayList<RequestLogs>();
    private final String cursor;
    private final LogQuery query;

    protected LogQueryResult(LogServicePb.LogReadResponse response, LogQuery originalQuery) {
        for (LogServicePb.RequestLog log : response.logs()) {
            this.logs.add(new RequestLogs(log));
        }
        this.cursor = response.getOffset().getRequestId();
        this.query = originalQuery.clone();
    }

    private List<RequestLogs> getLogs() {
        return Collections.unmodifiableList(this.logs);
    }

    private String getCursor() {
        return this.cursor;
    }

    @Override
    public Iterator<RequestLogs> iterator() {
        return new AbstractIterator<RequestLogs>(){
            List<RequestLogs> iterLogs;
            String iterCursor;
            int index;
            int lengthLogs;
            {
                this.iterLogs = LogQueryResult.this.logs;
                this.iterCursor = LogQueryResult.this.cursor;
                this.index = 0;
                this.lengthLogs = this.iterLogs.size();
            }

            @Override
            protected RequestLogs computeNext() {
                if (this.index >= this.lengthLogs) {
                    if (this.iterCursor.length() == 0) {
                        return (RequestLogs)this.endOfData();
                    }
                    LogQueryResult.this.query.offset(this.iterCursor);
                    LogQueryResult nextResults = new LogServiceImpl().fetch(LogQueryResult.this.query);
                    this.iterLogs = nextResults.getLogs();
                    this.iterCursor = nextResults.getCursor();
                    this.lengthLogs = this.iterLogs.size();
                    this.index = 0;
                    if (this.lengthLogs == 0) {
                        return (RequestLogs)this.endOfData();
                    }
                }
                return this.iterLogs.get(this.index++);
            }
        };
    }
}

