/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.search.Consistency;
import com.google.appengine.api.search.FutureHelper;
import com.google.appengine.api.search.Index;
import com.google.appengine.api.search.IndexImpl;
import com.google.appengine.api.search.IndexManager;
import com.google.appengine.api.search.IndexSpec;
import com.google.appengine.api.search.ListIndexesException;
import com.google.appengine.api.search.ListIndexesRequest;
import com.google.appengine.api.search.ListIndexesResponse;
import com.google.appengine.api.search.OperationResult;
import com.google.appengine.api.search.Preconditions;
import com.google.appengine.api.search.SearchApiHelper;
import com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.api.search.StatusCode;
import com.google.appengine.api.utils.FutureWrapper;
import java.util.ArrayList;
import java.util.concurrent.Future;

final class IndexManagerImpl
implements IndexManager {
    private final SearchApiHelper apiHelper;
    private final String namespace;

    IndexManagerImpl(SearchApiHelper apiHelper, String namespace) {
        this.apiHelper = apiHelper;
        this.namespace = IndexManagerImpl.getAppNamespace(namespace);
    }

    @Override
    public ListIndexesResponse listIndexes(ListIndexesRequest request) {
        return FutureHelper.quietGet(this.listIndexesAsync(request));
    }

    @Override
    public Future<ListIndexesResponse> listIndexesAsync(ListIndexesRequest request) {
        SearchServicePb.ListIndexesParams.Builder paramsBuilder = request.copyToProtocolBuffer().setNamespace(this.namespace);
        SearchServicePb.ListIndexesRequest pbRequest = SearchServicePb.ListIndexesRequest.newBuilder().setParams(paramsBuilder).build();
        SearchServicePb.ListIndexesResponse.Builder responseBuilder = SearchServicePb.ListIndexesResponse.newBuilder();
        Future<SearchServicePb.ListIndexesResponse.Builder> future = this.apiHelper.makeAsyncCall("ListIndexes", pbRequest, responseBuilder);
        return new FutureWrapper<SearchServicePb.ListIndexesResponse.Builder, ListIndexesResponse>(future){

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }

            @Override
            protected ListIndexesResponse wrap(SearchServicePb.ListIndexesResponse.Builder key) throws Exception {
                SearchServicePb.ListIndexesResponse response = key.build();
                OperationResult operationResult = new OperationResult(response.getStatus());
                if (operationResult.getCode() != StatusCode.OK) {
                    throw new ListIndexesException(operationResult);
                }
                ArrayList<Index> indexes = new ArrayList<Index>(response.getIndexMetadataCount());
                for (SearchServicePb.IndexMetadata metadata : response.getIndexMetadataList()) {
                    SearchServicePb.IndexSpec indexSpec = metadata.getIndexSpec();
                    IndexSpec.Builder builder = IndexSpec.newBuilder().setName(indexSpec.getName()).setConsistency(Consistency.fromProto(indexSpec.getConsistency()));
                    if (indexSpec.hasNamespace()) {
                        Preconditions.checkArgument(indexSpec.getNamespace().equals(IndexManagerImpl.this.namespace), String.format("Index with incorrect namespace received '%s' != '%s'", indexSpec.getNamespace(), IndexManagerImpl.this.namespace));
                    } else if (!IndexManagerImpl.this.namespace.isEmpty()) {
                        Preconditions.checkArgument(indexSpec.getNamespace().equals(IndexManagerImpl.this.namespace), String.format("Index with incorrect namespace received '' != '%s'", IndexManagerImpl.this.namespace));
                    }
                    indexes.add(IndexManagerImpl.this.getIndex(builder.build()));
                }
                return new ListIndexesResponse(indexes);
            }
        };
    }

    @Override
    public Index getIndex(IndexSpec.Builder builder) {
        return this.getIndex(builder.build());
    }

    @Override
    public Index getIndex(IndexSpec indexSpec) {
        return new IndexImpl(this.apiHelper, this.namespace, indexSpec);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    private static String getAppNamespace(String namespaceGiven) {
        if (namespaceGiven != null) {
            return namespaceGiven;
        }
        String currentNamespace = NamespaceManager.get();
        return currentNamespace == null ? "" : currentNamespace;
    }
}

