/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.search.IndexChecker;
import com.google.appengine.api.search.Preconditions;
import com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.api.search.Util;

public class ListIndexesRequestChecker {
    public static final int MAXIMUM_OFFSET = 1000;
    public static final int MAXIMUM_LIMIT = 800;
    public static final int DEFAULT_LIMIT = 20;

    public static int checkLimit(int limit) {
        Preconditions.checkArgument(limit >= 1 && limit <= 800, String.format("The limit %d must be between 1 and %d", limit, 800));
        return limit;
    }

    public static int checkOffset(int offset) {
        Preconditions.checkArgument(offset >= 0 && offset <= 1000, String.format("The limit %d must be between 1 and %d", offset, 1000));
        return offset;
    }

    public static String checkIndexNamePrefix(String indexNamePrefix) {
        if (Util.isNullOrEmpty(indexNamePrefix)) {
            return indexNamePrefix;
        }
        return IndexChecker.checkName(indexNamePrefix);
    }

    public static String checkStartIndexName(String startIndexName) {
        if (Util.isNullOrEmpty(startIndexName)) {
            return startIndexName;
        }
        return IndexChecker.checkName(startIndexName);
    }

    public static SearchServicePb.ListIndexesParams checkListIndexesParams(SearchServicePb.ListIndexesParams params) {
        if (params.hasLimit()) {
            ListIndexesRequestChecker.checkLimit(params.getLimit());
        }
        if (params.hasNamespace()) {
            NamespaceManager.validateNamespace(params.getNamespace());
        }
        if (params.hasStartIndexName()) {
            ListIndexesRequestChecker.checkStartIndexName(params.getStartIndexName());
        }
        if (params.hasIndexNamePrefix()) {
            ListIndexesRequestChecker.checkIndexNamePrefix(params.getIndexNamePrefix());
        }
        if (params.hasOffset()) {
            ListIndexesRequestChecker.checkOffset(params.getOffset());
        }
        return params;
    }
}

