/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.api.search.StatusCode;
import java.io.Serializable;

public class OperationResult
implements Serializable {
    private static final long serialVersionUID = 3608247775865189592L;
    private final StatusCode code;
    private final String message;

    public OperationResult(SearchServicePb.RequestStatus status) {
        this(status.getCode(), status.hasErrorDetail() ? status.getErrorDetail() : null);
    }

    public OperationResult(SearchServicePb.SearchServiceError.ErrorCode code, String errorDetail) {
        this(StatusCode.fromErrorCode(code), errorDetail);
    }

    public OperationResult(StatusCode code, String errorDetail) {
        this.code = code;
        this.message = errorDetail;
    }

    public StatusCode getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        if (this.message == null) {
            return this.code.name();
        }
        return this.code.name() + ": " + this.message;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.getClass().isAssignableFrom(object.getClass())) {
            return false;
        }
        OperationResult result = (OperationResult)object;
        boolean sameMessages = this.message == null && result.message == null || this.message != null && this.message.equals(result.message);
        return this.code.equals((Object)result.code) && sameMessages;
    }
}

