/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.Document;
import com.google.appengine.api.search.Field;
import com.google.appengine.api.search.Preconditions;
import com.google.appengine.api.search.Util;
import java.util.Collections;
import java.util.List;

public final class SearchResult {
    private final Document document;
    private final List<Double> scores;
    private final List<Field> expressions;
    private final String cursor;

    SearchResult(Document document, List<Double> scores, List<Field> expressions, String cursor) {
        this.document = Preconditions.checkNotNull(document, "document cannot be null");
        this.scores = Collections.unmodifiableList(Preconditions.checkNotNull(scores, "list of scores cannot be null"));
        this.expressions = Collections.unmodifiableList(Preconditions.checkNotNull(expressions, "expressions cannot be null"));
        this.cursor = cursor;
    }

    public Document getDocument() {
        return this.document;
    }

    public List<Double> getSortScores() {
        return this.scores;
    }

    public List<Field> getExpressions() {
        return this.expressions;
    }

    public String getCursor() {
        return this.cursor;
    }

    public String toString() {
        return String.format("SearchResult(document=%s, scores=%s, expressions=%s", this.document.toString(), Util.iterableToString(this.scores), Util.iterableToString(this.expressions));
    }
}

