/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

public final class Util {
    private Util() {
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean equalObjects(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static <T> T defaultIfNull(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static <T> String iterableToString(Iterable<T> objects) {
        StringBuilder builder = new StringBuilder().append("[");
        String sep = "";
        for (T o : objects) {
            builder.append(sep).append(o.toString());
            sep = ", ";
        }
        return builder.append("]").toString();
    }

    public static <T> String iterableFieldToString(String fieldName, Iterable<T> objects) {
        if (!objects.iterator().hasNext()) {
            return "";
        }
        return String.format(", %s=%s", fieldName, Util.iterableToString(objects));
    }

    public static String fieldToString(String name, Object value) {
        if (value == null) {
            return "";
        }
        return String.format(", %s=%s", name, value);
    }
}

