/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import javax.annotation.Nullable;

@GoogleInternal
@GwtCompatible
public final class Holder<T> {
    @Nullable
    private T instance;

    public static <T> Holder<T> absent() {
        return Holder.fromNullable(null);
    }

    public static <T> Holder<T> of(T initialReference) {
        return Holder.fromNullable(Preconditions.checkNotNull(initialReference));
    }

    public static <T> Holder<T> fromNullable(@Nullable T nullableReference) {
        return new Holder<T>(nullableReference);
    }

    private Holder(@Nullable T initialReference) {
        this.instance = initialReference;
    }

    public boolean isPresent() {
        return this.instance != null;
    }

    public T get() {
        Preconditions.checkState(this.isPresent());
        return this.instance;
    }

    public T or(T defaultValue) {
        Preconditions.checkNotNull(defaultValue, "use orNull() instead of or(null)");
        return this.isPresent() ? this.instance : defaultValue;
    }

    @Nullable
    public T orNull() {
        return this.instance;
    }

    public void set(T instance) {
        this.setNullable(Preconditions.checkNotNull(instance));
    }

    public void clear() {
        this.setNullable(null);
    }

    public void setNullable(@Nullable T instance) {
        this.instance = instance;
    }

    public String toString() {
        return this.isPresent() ? "Holder.of(" + this.instance + ")" : "Holder.absent()";
    }

    public static <T> Holder<T> unset() {
        return Holder.absent();
    }

    public boolean isSet() {
        return this.isPresent();
    }
}

