/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.util.Arrays;
import javax.annotation.Nullable;

@GwtCompatible
public final class Objects {
    private Objects() {
    }

    public static boolean equal(@Nullable Object a, @Nullable Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static int hashCode(Object ... objects) {
        return Arrays.hashCode(objects);
    }

    public static ToStringHelper toStringHelper(Object self) {
        return new ToStringHelper(Objects.simpleName(self.getClass()));
    }

    public static ToStringHelper toStringHelper(Class<?> clazz) {
        return new ToStringHelper(Objects.simpleName(clazz));
    }

    public static ToStringHelper toStringHelper(String className) {
        return new ToStringHelper(className);
    }

    private static String simpleName(Class<?> clazz) {
        String name = clazz.getName();
        int start = (name = name.replaceAll("\\$[0-9]+", "\\$")).lastIndexOf(36);
        if (start == -1) {
            start = name.lastIndexOf(46);
        }
        return name.substring(start + 1);
    }

    @GoogleInternal
    public static <T> T nonNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    @GoogleInternal
    public static <T> T nonNull(T obj, @Nullable String message) {
        if (obj == null) {
            throw new NullPointerException(message);
        }
        return obj;
    }

    public static <T> T firstNonNull(@Nullable T first, @Nullable T second) {
        return first != null ? first : Preconditions.checkNotNull(second);
    }

    @GoogleInternal
    public static boolean deepEquals(@Nullable Object a, @Nullable Object b) {
        return Arrays.deepEquals(new Object[]{a}, new Object[]{b});
    }

    @GoogleInternal
    public static int deepHashCode(@Nullable Object obj) {
        return Arrays.deepHashCode(new Object[]{obj}) - 31;
    }

    @GoogleInternal
    public static String deepToString(@Nullable Object obj) {
        String s = Arrays.deepToString(new Object[]{obj});
        return s.substring(1, s.length() - 1);
    }

    public static final class ToStringHelper {
        private final StringBuilder builder;
        private boolean needsSeparator = false;

        private ToStringHelper(String className) {
            Preconditions.checkNotNull(className);
            this.builder = new StringBuilder(32).append(className).append('{');
        }

        public ToStringHelper add(String name, @Nullable Object value) {
            this.checkNameAndAppend(name).append(value);
            return this;
        }

        public ToStringHelper add(String name, boolean value) {
            this.checkNameAndAppend(name).append(value);
            return this;
        }

        public ToStringHelper add(String name, char value) {
            this.checkNameAndAppend(name).append(value);
            return this;
        }

        public ToStringHelper add(String name, double value) {
            this.checkNameAndAppend(name).append(value);
            return this;
        }

        public ToStringHelper add(String name, float value) {
            this.checkNameAndAppend(name).append(value);
            return this;
        }

        public ToStringHelper add(String name, int value) {
            this.checkNameAndAppend(name).append(value);
            return this;
        }

        public ToStringHelper add(String name, long value) {
            this.checkNameAndAppend(name).append(value);
            return this;
        }

        private StringBuilder checkNameAndAppend(String name) {
            Preconditions.checkNotNull(name);
            return this.maybeAppendSeparator().append(name).append('=');
        }

        public ToStringHelper addValue(@Nullable Object value) {
            this.maybeAppendSeparator().append(value);
            return this;
        }

        public ToStringHelper addValue(boolean value) {
            this.maybeAppendSeparator().append(value);
            return this;
        }

        public ToStringHelper addValue(char value) {
            this.maybeAppendSeparator().append(value);
            return this;
        }

        public ToStringHelper addValue(double value) {
            this.maybeAppendSeparator().append(value);
            return this;
        }

        public ToStringHelper addValue(float value) {
            this.maybeAppendSeparator().append(value);
            return this;
        }

        public ToStringHelper addValue(int value) {
            this.maybeAppendSeparator().append(value);
            return this;
        }

        public ToStringHelper addValue(long value) {
            this.maybeAppendSeparator().append(value);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            try {
                String string = this.builder.append('}').toString();
                return string;
            }
            finally {
                this.builder.setLength(this.builder.length() - 1);
            }
        }

        private StringBuilder maybeAppendSeparator() {
            if (this.needsSeparator) {
                return this.builder.append(", ");
            }
            this.needsSeparator = true;
            return this.builder;
        }
    }
}

