/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.AppEngineWebXmlProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AppEngineWebXmlReader {
    private static final Logger logger = Logger.getLogger(AppEngineWebXmlReader.class.getName());
    public static final String DEFAULT_RELATIVE_FILENAME = "WEB-INF/appengine-web.xml";
    private final String filename;

    public AppEngineWebXmlReader(String appDir, String relativeFilename) {
        if (appDir.length() > 0 && appDir.charAt(appDir.length() - 1) != File.separatorChar) {
            appDir = appDir + File.separatorChar;
        }
        this.filename = appDir + relativeFilename;
    }

    public AppEngineWebXmlReader(String appDir) {
        this(appDir, DEFAULT_RELATIVE_FILENAME);
    }

    public AppEngineWebXml readAppEngineWebXml() {
        AppEngineWebXml appEngineWebXml;
        InputStream is = null;
        try {
            is = this.getInputStream();
            appEngineWebXml = this.processXml(is);
            logger.info("Successfully processed " + this.getFilename());
        }
        catch (Exception e) {
            String msg = "Received exception processing " + this.getFilename();
            logger.log(Level.SEVERE, msg, e);
            if (e instanceof AppEngineConfigException) {
                throw (AppEngineConfigException)e;
            }
            throw new AppEngineConfigException(msg, e);
        }
        finally {
            this.close(is);
        }
        return appEngineWebXml;
    }

    public String getFilename() {
        return this.filename;
    }

    private void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new AppEngineConfigException(e);
            }
        }
    }

    protected AppEngineWebXml processXml(InputStream is) {
        return new AppEngineWebXmlProcessor().processXml(is);
    }

    protected InputStream getInputStream() {
        try {
            return new FileInputStream(this.getFilename());
        }
        catch (FileNotFoundException fnfe) {
            throw new AppEngineConfigException("Could not locate " + new File(this.getFilename()).getAbsolutePath(), fnfe);
        }
    }
}

