/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.tools.admin.ConfirmationCallback;
import com.google.appengine.tools.admin.GenericApplication;
import com.google.appengine.tools.admin.ServerConnection;
import com.google.appengine.tools.admin.UpdateListener;
import com.google.appengine.tools.admin.UpdateProgressEvent;
import com.google.appengine.tools.admin.UpdateSuccessEvent;
import com.google.apphosting.utils.config.IndexYamlReader;
import com.google.apphosting.utils.config.IndexesXml;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

public class IndexDeleter {
    private final ServerConnection connection;
    private final GenericApplication application;
    private final PrintWriter errorWriter;
    private final ConfirmationCallback<DeleteIndexAction> confirmationCallback;
    private final UpdateListener updateListener;

    IndexDeleter(ServerConnection conn, GenericApplication app, ConfirmationCallback<DeleteIndexAction> callback, PrintWriter errorWriter, UpdateListener listener) {
        this.connection = conn;
        this.application = app;
        this.confirmationCallback = callback;
        this.errorWriter = errorWriter;
        this.updateListener = listener;
    }

    private DiffResponse diffIndexesOnServer(IndexesXml indexes) throws IOException {
        String response = this.post("/api/datastore/index/diff", indexes.toYaml());
        List<IndexesXml> parsedResponse = IndexYamlReader.parseMultiple(response);
        if (parsedResponse.size() != 2) {
            throw new RuntimeException("Response from diff could not be parsed as two index definitions");
        }
        DiffResponse pair = new DiffResponse();
        pair.missingFromServer = parsedResponse.get(0);
        pair.missingFromClient = parsedResponse.get(1);
        return pair;
    }

    private IndexesXml deleteIndexesOnServer(IndexesXml indexes) throws IOException {
        String response = this.post("/api/datastore/index/delete", indexes.toYaml());
        return IndexYamlReader.parse(response);
    }

    private String post(String path, String payload) throws IOException {
        return this.connection.post(path, payload, "app_id", this.application.getAppId());
    }

    private IndexesXml confirmDeletes(IndexesXml toDelete) {
        IndexesXml confirmedToDelete = new IndexesXml();
        boolean yesToTheRest = false;
        block6: for (IndexesXml.Index index : toDelete) {
            if (yesToTheRest) {
                confirmedToDelete.addNewIndex(index);
                continue;
            }
            ConfirmationCallback.Response response = ConfirmationCallback.Response.YES_ALL;
            if (null != this.confirmationCallback) {
                response = this.confirmationCallback.confirmAction(new DeleteIndexAction(index));
            }
            switch (response) {
                case YES: {
                    confirmedToDelete.addNewIndex(index);
                    break;
                }
                case NO: {
                    break;
                }
                case YES_ALL: {
                    confirmedToDelete.addNewIndex(index);
                    yesToTheRest = true;
                    break;
                }
                case NO_ALL: {
                    break block6;
                }
                default: {
                    throw new RuntimeException("Unrecognized response: " + (Object)((Object)response));
                }
            }
        }
        return confirmedToDelete;
    }

    private void logFailedDeletes(IndexesXml notDeleted) {
        int numNotDeleted = notDeleted.size();
        if (numNotDeleted > 0) {
            if (1 == numNotDeleted) {
                this.errorWriter.println("An index was not deleted.  Most likely this is  because it no longer exists.");
            } else {
                this.errorWriter.println(numNotDeleted + " indexes were not deleted.  Most likely this is because they no longer exist.");
            }
            for (IndexesXml.Index index : notDeleted) {
                this.errorWriter.println(index.toXmlString());
            }
            this.errorWriter.flush();
        }
    }

    public void deleteUnusedIndexes() throws IOException {
        IndexesXml allLocalIndexDefs = this.application.getIndexesXml();
        int numLocalIndexDefs = allLocalIndexDefs.size();
        String message = "Found " + numLocalIndexDefs + " local index definition" + (1 == numLocalIndexDefs ? "." : "s.");
        this.updateListener.onProgress(new UpdateProgressEvent(Thread.currentThread(), message, 10));
        DiffResponse pair = this.diffIndexesOnServer(allLocalIndexDefs);
        IndexesXml unusedDefs = pair.missingFromClient;
        int numUnused = unusedDefs.size();
        message = "Found " + numUnused + " unused " + (1 == numUnused ? "index" : "indexes") + " on the server.";
        this.updateListener.onProgress(new UpdateProgressEvent(Thread.currentThread(), message, 50));
        IndexesXml toDelete = this.confirmDeletes(unusedDefs);
        int numToDelete = toDelete.size();
        if (0 == numToDelete) {
            this.updateListener.onSuccess(new UpdateSuccessEvent("No indexes were deleted."));
        } else {
            message = "Deleting " + numToDelete + (1 == numUnused ? " index." : " indexes.");
            this.updateListener.onProgress(new UpdateProgressEvent(Thread.currentThread(), message, 60));
            IndexesXml notDeleted = this.deleteIndexesOnServer(toDelete);
            this.logFailedDeletes(notDeleted);
            int numNotDeleted = notDeleted.size();
            int numDeleted = numToDelete - numNotDeleted;
            message = "Deleted " + numDeleted + (1 == numDeleted ? " index." : " indexes.");
            this.updateListener.onSuccess(new UpdateSuccessEvent(message));
        }
    }

    public static class DeleteIndexAction
    extends ConfirmationCallback.Action {
        private IndexesXml.Index index;
        private static final String PROMPT1 = "This index is no longer in your datastore-indexes.xml file:";
        private static final String PROMPT2 = "Are you sure you want to delete this index?";

        public DeleteIndexAction(IndexesXml.Index index) {
            super(DeleteIndexAction.buildPrompt(index));
            this.index = index;
        }

        public IndexesXml.Index getIndex() {
            return this.index;
        }

        private static String buildPrompt(IndexesXml.Index index) {
            StringBuilder builder = new StringBuilder(1024);
            builder.append(PROMPT1).append("\n\n").append(index.toXmlString()).append("\n").append(PROMPT2);
            return builder.toString();
        }
    }

    private static class DiffResponse {
        IndexesXml missingFromServer;
        IndexesXml missingFromClient;

        private DiffResponse() {
        }
    }
}

