/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.info;

import com.google.appengine.tools.info.SdkInfo;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.List;

public class SdkImplInfo {
    private static List<File> allLibFiles = Collections.unmodifiableList(SdkInfo.getLibsRecursive(SdkInfo.getSdkRoot(), ""));
    private static List<URL> allLibs = Collections.unmodifiableList(SdkInfo.toURLs(allLibFiles));
    private static List<File> implLibFiles = Collections.unmodifiableList(SdkInfo.getLibs(SdkInfo.getSdkRoot(), "impl"));
    private static List<URL> implLibs = Collections.unmodifiableList(SdkInfo.toURLs(implLibFiles));
    private static List<File> agentRuntimeLibFiles = Collections.unmodifiableList(SdkInfo.getLibsRecursive(SdkInfo.getSdkRoot(), "impl/agent"));
    private static List<URL> agentRuntimeLibs = Collections.unmodifiableList(SdkInfo.toURLs(agentRuntimeLibFiles));
    private static List<URL> toolOrmUrls;
    private static List<File> userJspLibFiles;
    private static List<URL> userJspLibs;
    private static List<File> sharedJspLibFiles;
    private static List<URL> sharedJspLibs;

    public static List<URL> getOrmToolLibs() {
        if (toolOrmUrls == null) {
            List<File> toolOrmFiles = Collections.unmodifiableList(SdkInfo.getLibsRecursive(SdkInfo.getSdkRoot(), "tools/orm"));
            toolOrmUrls = Collections.unmodifiableList(SdkInfo.toURLs(toolOrmFiles));
        }
        return toolOrmUrls;
    }

    public static List<URL> getAgentRuntimeLibs() {
        return agentRuntimeLibs;
    }

    public static List<URL> getImplLibs() {
        return implLibs;
    }

    public static List<URL> getUserJspLibs() {
        return userJspLibs;
    }

    public static List<File> getUserJspLibFiles() {
        return userJspLibFiles;
    }

    public static List<URL> getSharedJspLibs() {
        return sharedJspLibs;
    }

    public static List<File> getSharedJspLibFiles() {
        return sharedJspLibFiles;
    }

    public static File getLoggingProperties() {
        return new File(SdkInfo.getSdkRoot() + File.separator + "config" + File.separator + "sdk" + File.separator + "logging.properties");
    }

    public static URL getToolsApiJar() {
        File f = new File(SdkInfo.getSdkRoot() + File.separator + "lib" + File.separator + "appengine-tools-api.jar");
        return SdkInfo.toURL(f);
    }

    public static List<File> getAllLibFiles() {
        return allLibFiles;
    }

    static {
        userJspLibFiles = Collections.unmodifiableList(SdkInfo.getLibsRecursive(SdkInfo.getSdkRoot(), "tools/jsp"));
        userJspLibs = Collections.unmodifiableList(SdkInfo.toURLs(userJspLibFiles));
        sharedJspLibFiles = Collections.unmodifiableList(SdkInfo.getLibsRecursive(SdkInfo.getSdkRoot(), "shared/jsp"));
        sharedJspLibs = Collections.unmodifiableList(SdkInfo.toURLs(sharedJspLibFiles));
    }
}

