/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.api.backends.dev.LocalServerController;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMapBuilder;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpClient;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpMethod;
import com.google.appengine.repackaged.org.apache.commons.httpclient.methods.GetMethod;
import com.google.appengine.tools.development.AbstractContainerService;
import com.google.appengine.tools.development.BackendContainer;
import com.google.appengine.tools.development.ContainerService;
import com.google.appengine.tools.development.ContainerUtils;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.config.BackendsXml;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.webapp.WebAppContext;

public class BackendServers
implements BackendContainer,
LocalServerController {
    private static final String X_GOOGLE_DEV_APPSERVER_SKIPADMINCHECK = "X-Google-DevAppserver-SkipAdminCheck";
    public static final String SYSTEM_PROPERTY_STATIC_PORT_NUM_PREFIX = "com.google.appengine.devappserver.";
    private static final int AH_REQUEST_DEFAULT_TIMEOUT = 30000;
    private static final int AH_REQUEST_INFINITE_TIMEOUT = 0;
    private static final Integer DEFAULT_INSTANCES = 1;
    private static final String DEFAULT_INSTANCE_CLASS = "B1";
    private static final Integer DEFAULT_MAX_CONCURRENT_REQUESTS = 10;
    private static final int MAX_PENDING_QUEUE_LENGTH = 20;
    private static final int MAX_PENDING_QUEUE_TIME_MS = 10000;
    private static final int MAX_START_QUEUE_TIME_MS = 30000;
    private static BackendServers instance = new BackendServers();
    private String address;
    private File appDir;
    private File webXmlLocation;
    private File appEngineWebXmlLocation;
    private Map<String, Object> containerConfigProperties;
    private Map<ServerInstanceEntry, ServerWrapper> backendServers = ImmutableMapBuilder.fromMap(new HashMap()).getMap();
    private Map<String, String> portMapping = ImmutableMapBuilder.fromMap(new HashMap()).getMap();
    private Logger logger = Logger.getLogger(BackendServers.class.getName());
    private Map<String, String> serviceProperties = new HashMap<String, String>();

    public static BackendServers getInstance() {
        return instance;
    }

    @VisibleForTesting
    BackendServers() {
    }

    @Override
    public void init(File appDir, File webXmlLocation, File appEngineWebXmlLocation, String address, Map<String, Object> containerConfigProperties) {
        this.appDir = appDir;
        this.webXmlLocation = webXmlLocation;
        this.appEngineWebXmlLocation = appEngineWebXmlLocation;
        this.address = address;
        this.containerConfigProperties = containerConfigProperties;
    }

    @Override
    public void setServiceProperties(Map<String, String> properties) {
        this.serviceProperties = properties;
    }

    @Override
    public void shutdownAll() throws Exception {
        for (ServerWrapper server : this.backendServers.values()) {
            this.logger.finer("server shutdown: " + server);
            server.shutdown();
        }
        this.backendServers = ImmutableMapBuilder.fromMap(new HashMap()).getMap();
    }

    public TreeMap<String, LocalServerController.BackendStateInfo> getBackendState(String requestHostName) {
        TreeMap<String, LocalServerController.BackendStateInfo> serverInfoMap = new TreeMap<String, LocalServerController.BackendStateInfo>();
        for (ServerWrapper serverWrapper : this.backendServers.values()) {
            String name = serverWrapper.serverEntry.getName();
            String listenAddress = requestHostName == null ? this.portMapping.get(serverWrapper.getDnsPrefix()) : requestHostName + ":" + serverWrapper.port;
            LocalServerController.BackendStateInfo ssi = serverInfoMap.get(name);
            if (ssi == null) {
                ssi = new LocalServerController.BackendStateInfo(serverWrapper.serverEntry);
                serverInfoMap.put(name, ssi);
            }
            if (serverWrapper.isLoadBalanceServer()) {
                ssi.setState(serverWrapper.serverState.name().toLowerCase());
                ssi.setAddress(listenAddress);
                continue;
            }
            ssi.add(new LocalServerController.InstanceStateInfo(serverWrapper.serverInstance, listenAddress, serverWrapper.serverState.name().toLowerCase()));
        }
        return serverInfoMap;
    }

    public synchronized void startBackend(String serverToStart) throws IllegalStateException {
        if (!this.checkServerExists(serverToStart)) {
            String message = String.format("Tried to start unknown server %s", serverToStart);
            this.logger.warning(message);
            throw new IllegalStateException(message);
        }
        for (ServerWrapper server : this.backendServers.values()) {
            if (!server.getName().equals(serverToStart) || server.getState() != BackendServerState.STOPPED) continue;
            if (server.isLoadBalanceServer()) {
                server.compareAndSetServerState(BackendServerState.RUNNING, new BackendServerState[]{BackendServerState.STOPPED});
                continue;
            }
            server.compareAndSetServerState(BackendServerState.SLEEPING, new BackendServerState[]{BackendServerState.STOPPED});
            server.sendStartRequest();
        }
    }

    public synchronized void stopBackend(String serverToStop) throws IllegalStateException, Exception {
        if (!this.checkServerExists(serverToStop)) {
            String message = String.format("Tried to stop unknown server %s", serverToStop);
            this.logger.warning(message);
            throw new IllegalStateException(message);
        }
        for (ServerWrapper server : this.backendServers.values()) {
            if (!server.getName().equals(serverToStop) || server.getState() == BackendServerState.STOPPED) continue;
            if (server.isLoadBalanceServer()) {
                server.compareAndSetServerState(BackendServerState.STOPPED, new BackendServerState[]{BackendServerState.RUNNING});
                continue;
            }
            this.logger.fine("Stopping server: " + server.getDnsPrefix());
            server.shutdown();
            server.startup(true);
        }
    }

    @Override
    public void startupAll(BackendsXml backendsXml) throws Exception {
        if (backendsXml == null) {
            this.logger.fine("Got null backendsXml config.");
            return;
        }
        List<BackendsXml.Entry> servers = backendsXml.getBackends();
        if (servers.size() == 0) {
            this.logger.fine("No backends configured.");
            return;
        }
        if (this.backendServers.size() != 0) {
            throw new Exception("Tried to start backendservers but some are already running.");
        }
        this.logger.finer("Found " + servers.size() + " configured backends.");
        HashMap<ServerInstanceEntry, ServerWrapper> serverMap = Maps.newHashMap();
        for (BackendsXml.Entry entry : servers) {
            entry = this.resolveDefaults(entry);
            for (int serverInstance = -1; serverInstance < entry.getInstances(); ++serverInstance) {
                int port = this.checkForStaticPort(entry.getName(), serverInstance);
                ServerWrapper serverWrapper = new ServerWrapper(ContainerUtils.loadContainer(), entry, serverInstance, port);
                serverMap.put(new ServerInstanceEntry(entry.getName(), serverInstance), serverWrapper);
            }
        }
        this.backendServers = ImmutableMapBuilder.fromMap(serverMap).getMap();
        String prettyAddress = this.address;
        if ("0.0.0.0".equals(this.address)) {
            prettyAddress = "127.0.0.1";
        }
        HashMap<String, String> portMap = Maps.newHashMap();
        for (ServerWrapper serverWrapper : this.backendServers.values()) {
            this.logger.finer("starting server: " + serverWrapper.serverInstance + "." + serverWrapper.getName() + " on " + this.address + ":" + serverWrapper.port);
            serverWrapper.startup(false);
            portMap.put(serverWrapper.getDnsPrefix(), prettyAddress + ":" + serverWrapper.port);
        }
        this.portMapping = ImmutableMapBuilder.fromMap(portMap).getMap();
        for (ServerWrapper serverWrapper : this.backendServers.values()) {
            if (serverWrapper.isLoadBalanceServer()) continue;
            serverWrapper.sendStartRequest();
        }
    }

    private BackendsXml.Entry resolveDefaults(BackendsXml.Entry entry) {
        return new BackendsXml.Entry(entry.getName(), entry.getInstances() == null ? DEFAULT_INSTANCES : entry.getInstances(), entry.getInstanceClass() == null ? DEFAULT_INSTANCE_CLASS : entry.getInstanceClass(), entry.getMaxConcurrentRequests() == null ? DEFAULT_MAX_CONCURRENT_REQUESTS : entry.getMaxConcurrentRequests(), entry.getOptions(), entry.getState() == null ? BackendsXml.State.STOP : entry.getState());
    }

    void forwardToServer(String requestedServer, int instance, HttpServletRequest hrequest, HttpServletResponse hresponse) throws IOException, ServletException {
        ServerWrapper server = this.getServerWrapper(requestedServer, instance);
        this.logger.finest("forwarding request to server: " + server);
        WebAppContext jettyContext = (WebAppContext)server.container.getAppContext().getContainerContext();
        RequestDispatcher requestDispatcher = jettyContext.getServletContext().getRequestDispatcher(hrequest.getRequestURI());
        requestDispatcher.forward((ServletRequest)hrequest, (ServletResponse)hresponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean acquireServingPermit(String serverName, int instanceNumber, boolean allowQueueOnBackends) {
        this.logger.finest(String.format("trying to get serving permit for server %d.%s", instanceNumber, serverName));
        try {
            ServerWrapper server = this.getServerWrapper(serverName, instanceNumber);
            int maxQueueTime = 0;
            ServerWrapper serverWrapper = server;
            synchronized (serverWrapper) {
                if (!server.acceptsConnections()) {
                    this.logger.finest(server + ": got request but server is not in a serving state");
                    return false;
                }
                if (server.getApproximateQueueLength() > 20) {
                    this.logger.finest(server + ": server queue is full");
                    return false;
                }
                if (server.getState() == BackendServerState.SLEEPING) {
                    this.logger.finest(server + ": waking up sleeping server");
                    server.sendStartRequest();
                }
                if (server.getState() == BackendServerState.RUNNING_START_REQUEST) {
                    maxQueueTime = 30000;
                } else if (allowQueueOnBackends && server.getMaxPendingQueueSize() > 0) {
                    maxQueueTime = 10000;
                }
            }
            boolean gotPermit = server.acquireServingPermit(maxQueueTime);
            this.logger.finest(server + ": tried to get server permit, timeout=" + maxQueueTime + " success=" + gotPermit);
            return gotPermit;
        }
        catch (InterruptedException e) {
            this.logger.finest(instanceNumber + "." + serverName + ": got interrupted while waiting for serving permit");
            return false;
        }
    }

    int getAndReserveFreeInstance(String requestedServer) {
        this.logger.finest("trying to get serving permit for server " + requestedServer);
        ServerWrapper server = this.getServerWrapper(requestedServer, -1);
        if (server == null) {
            return -1;
        }
        if (!server.acceptsConnections()) {
            return -1;
        }
        int instanceNum = server.getInstances();
        for (int i = 0; i < instanceNum; ++i) {
            if (!this.acquireServingPermit(requestedServer, i, false)) continue;
            return i;
        }
        if (server.getMaxPendingQueueSize() > 0) {
            return this.addToShortestInstanceQueue(requestedServer);
        }
        this.logger.finest("no servers free");
        return -1;
    }

    int addToShortestInstanceQueue(String requestedServer) {
        this.logger.finest(requestedServer + ": no instances free, trying to find a queue");
        int shortestQueue = 20;
        ServerWrapper instanceWithShortestQueue = null;
        for (ServerWrapper server : this.backendServers.values()) {
            int serverQueue;
            if (!server.acceptsConnections() || shortestQueue <= (serverQueue = server.getApproximateQueueLength())) continue;
            instanceWithShortestQueue = server;
            shortestQueue = serverQueue;
        }
        try {
            if (shortestQueue < 20) {
                this.logger.finest("adding request to queue on instance: " + instanceWithShortestQueue);
                if (instanceWithShortestQueue.acquireServingPermit(10000)) {
                    this.logger.finest("ready to serve request on instance: " + instanceWithShortestQueue);
                    return instanceWithShortestQueue.serverInstance;
                }
            }
        }
        catch (InterruptedException e) {
            this.logger.finer("interupted while queued at server " + instanceWithShortestQueue);
        }
        return -1;
    }

    void returnServingPermit(String serverName, int instance) {
        ServerWrapper server = this.getServerWrapper(serverName, instance);
        server.releaseServingPermit();
    }

    boolean checkInstanceExists(String serverName, int instance) {
        return this.getServerWrapper(serverName, instance) != null;
    }

    boolean checkServerExists(String serverName) {
        return this.checkInstanceExists(serverName, -1);
    }

    boolean checkServerStopped(String serverName) {
        return this.checkInstanceStopped(serverName, -1);
    }

    boolean checkInstanceStopped(String serverName, int instance) {
        return !this.getServerWrapper(serverName, instance).acceptsConnections();
    }

    Map<String, String> getPortMapping() {
        return this.portMapping;
    }

    int getServerInstanceFromPort(int port) {
        ServerWrapper server = this.getServerWrapperFromPort(port);
        if (server != null) {
            return server.serverInstance;
        }
        return -1;
    }

    String getServerNameFromPort(int port) {
        ServerWrapper server = this.getServerWrapperFromPort(port);
        if (server != null) {
            return server.getName();
        }
        return null;
    }

    private ServerWrapper getServerWrapperFromPort(int port) {
        for (Map.Entry<ServerInstanceEntry, ServerWrapper> entry : this.backendServers.entrySet()) {
            if (entry.getValue().port != port) continue;
            return entry.getValue();
        }
        return null;
    }

    private ServerWrapper getServerWrapper(String serverName, int instanceNumber) {
        return this.backendServers.get(new ServerInstanceEntry(serverName, instanceNumber));
    }

    private int checkForStaticPort(String server, int instance) {
        StringBuilder key = new StringBuilder();
        key.append(SYSTEM_PROPERTY_STATIC_PORT_NUM_PREFIX);
        key.append(server);
        if (instance >= 0) {
            key.append("." + instance);
        }
        key.append(".port");
        String configuredPort = this.serviceProperties.get(key.toString());
        if (configuredPort != null) {
            return Integer.parseInt(configuredPort);
        }
        return 0;
    }

    private class ServerWrapper {
        private final ContainerService container;
        private final int serverInstance;
        private int port;
        private final BackendsXml.Entry serverEntry;
        private BackendServerState serverState = BackendServerState.SHUTDOWN;
        private final Semaphore servingQueue = new Semaphore(0, true);

        public ServerWrapper(ContainerService containerService, BackendsXml.Entry serverEntry, int instance, int port) {
            this.container = containerService;
            this.serverEntry = serverEntry;
            this.serverInstance = instance;
            this.port = port;
            containerService.setEnvironmentVariableMismatchSeverity(ContainerService.EnvironmentVariableMismatchSeverity.IGNORE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendStartRequest(int timeoutInMs) {
            try {
                String urlString = String.format("http://%s:%d/_ah/start", BackendServers.this.address, this.port);
                BackendServers.this.logger.finer("sending start request to: " + urlString);
                HttpClient httpClient = new HttpClient();
                httpClient.getParams().setConnectionManagerTimeout((long)timeoutInMs);
                GetMethod request = new GetMethod(urlString);
                request.addRequestHeader(BackendServers.X_GOOGLE_DEV_APPSERVER_SKIPADMINCHECK, "true");
                try {
                    int returnCode = httpClient.executeMethod((HttpMethod)request);
                    byte[] buffer = new byte[1024];
                    InputStream in = request.getResponseBodyAsStream();
                    while (in.read(buffer) != -1) {
                    }
                    if (returnCode >= 200 && returnCode < 300 || returnCode == 404) {
                        BackendServers.this.logger.fine(String.format("backend server %d.%s request to /_ah/start completed, code=%d", this.serverInstance, this.serverEntry.getName(), returnCode));
                        this.compareAndSetServerState(BackendServerState.RUNNING, BackendServerState.RUNNING_START_REQUEST);
                        this.servingQueue.release(this.serverEntry.getMaxConcurrentRequests());
                    } else {
                        BackendServers.this.logger.warning("Start request to /_ah/start on server " + this.serverInstance + "." + this.serverEntry.getName() + " failed (HTTP status code=" + returnCode + "). Retrying...");
                        Thread.sleep(1000L);
                        this.sendStartRequest(timeoutInMs);
                    }
                }
                finally {
                    request.releaseConnection();
                }
            }
            catch (MalformedURLException e) {
                BackendServers.this.logger.severe(String.format("Unable to send start request to server: %d.%s, MalformedURLException: %s", this.serverInstance, this.serverEntry.getName(), e.getMessage()));
            }
            catch (Exception e) {
                BackendServers.this.logger.warning(String.format("Got exception while performing /_ah/start request on server: %d.%s, %s: %s", this.serverInstance, this.serverEntry.getName(), e.getClass().getName(), e.getMessage()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() throws Exception {
            ServerWrapper serverWrapper = this;
            synchronized (serverWrapper) {
                if (this.serverState == BackendServerState.RUNNING || this.serverState == BackendServerState.RUNNING_START_REQUEST) {
                    this.triggerLifecycleShutdownHook();
                }
                this.container.shutdown();
                this.serverState = BackendServerState.SHUTDOWN;
            }
        }

        void startup(boolean setStateToStopped) throws Exception {
            this.compareAndSetServerState(BackendServerState.INITIALIZING, BackendServerState.SHUTDOWN);
            this.container.configure(ContainerUtils.getServerInfo(), BackendServers.this.appDir, BackendServers.this.webXmlLocation, BackendServers.this.appEngineWebXmlLocation, BackendServers.this.address, this.port, BackendServers.this.containerConfigProperties);
            this.container.startup();
            this.port = this.container.getPort();
            if (setStateToStopped) {
                this.compareAndSetServerState(BackendServerState.STOPPED, BackendServerState.INITIALIZING);
            } else {
                BackendServers.this.logger.info("server: " + this.serverInstance + "." + this.serverEntry.getName() + " is running on port " + this.port);
                if (this.isLoadBalanceServer()) {
                    this.compareAndSetServerState(BackendServerState.RUNNING, BackendServerState.INITIALIZING);
                } else {
                    this.compareAndSetServerState(BackendServerState.SLEEPING, BackendServerState.INITIALIZING);
                }
            }
        }

        void sendStartRequest() {
            this.compareAndSetServerState(BackendServerState.RUNNING_START_REQUEST, BackendServerState.SLEEPING);
            if (this.serverInstance >= 0) {
                Thread requestThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ServerWrapper.this.sendStartRequest(0);
                    }
                });
                requestThread.setDaemon(true);
                requestThread.setName("BackendServersStartRequestThread." + this.serverInstance + "." + this.serverEntry.getName());
                requestThread.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void triggerLifecycleShutdownHook() {
            ApiProxy.Environment prevEnvironment = ApiProxy.getCurrentEnvironment();
            try {
                ClassLoader serverClassLoader = this.container.getAppContext().getClassLoader();
                Class<?> lifeCycleManagerClass = Class.forName("com.google.appengine.api.LifecycleManager", true, serverClassLoader);
                Method lifeCycleManagerGetter = lifeCycleManagerClass.getMethod("getInstance", new Class[0]);
                Object userThreadLifeCycleManager = lifeCycleManagerGetter.invoke(null, new Object[0]);
                Method beginShutdown = lifeCycleManagerClass.getMethod("beginShutdown", Long.TYPE);
                ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)new AbstractContainerService.LocalInitializationEnvironment(this.container.getAppEngineWebXmlConfig()));
                try {
                    beginShutdown.invoke(userThreadLifeCycleManager, 30000);
                }
                catch (Exception e) {
                    BackendServers.this.logger.warning(String.format("got exception when running shutdown hook on server %d.%s", this.serverInstance, this.serverEntry.getName()));
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                BackendServers.this.logger.severe(String.format("Exception during reflective call to LifecycleManager.beginShutdown on server %d.%s, got %s: %s", this.serverInstance, this.serverEntry.getName(), e.getClass().getName(), e.getMessage()));
            }
            finally {
                ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)prevEnvironment);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean acceptsConnections() {
            ServerWrapper serverWrapper = this;
            synchronized (serverWrapper) {
                return this.serverState == BackendServerState.RUNNING || this.serverState == BackendServerState.RUNNING_START_REQUEST || this.serverState == BackendServerState.SLEEPING;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void compareAndSetServerState(BackendServerState newState, BackendServerState ... acceptablePreviousStates) throws IllegalStateException {
            ServerWrapper serverWrapper = this;
            synchronized (serverWrapper) {
                for (BackendServerState acceptableStates : acceptablePreviousStates) {
                    if (this.serverState != acceptableStates) continue;
                    this.serverState = newState;
                    return;
                }
            }
            StringBuilder error = new StringBuilder();
            error.append("Tried to change state to " + (Object)((Object)newState));
            error.append(" on server " + this.toString());
            error.append(" but previous state is not ");
            for (int i = 0; i < acceptablePreviousStates.length; ++i) {
                error.append(acceptablePreviousStates[i].name() + " | ");
            }
            throw new IllegalStateException(error.toString());
        }

        boolean acquireServingPermit(int maxWaitTimeInMs) throws InterruptedException {
            BackendServers.this.logger.finest(this + ": accuiring serving permit, available: " + this.servingQueue.availablePermits());
            return this.servingQueue.tryAcquire(maxWaitTimeInMs, TimeUnit.MILLISECONDS);
        }

        void releaseServingPermit() {
            this.servingQueue.release();
            BackendServers.this.logger.finest(this + ": returned serving permit, available: " + this.servingQueue.availablePermits());
        }

        int getApproximateQueueLength() {
            return this.servingQueue.getQueueLength();
        }

        int getMaxPendingQueueSize() {
            return this.serverEntry.isFailFast() ? 0 : 20;
        }

        public String getDnsPrefix() {
            if (!this.isLoadBalanceServer()) {
                return this.serverInstance + "." + this.getName();
            }
            return this.getName();
        }

        String getName() {
            return this.serverEntry.getName();
        }

        public int getInstances() {
            return this.serverEntry.getInstances();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        BackendServerState getState() {
            ServerWrapper serverWrapper = this;
            synchronized (serverWrapper) {
                return this.serverState;
            }
        }

        boolean isLoadBalanceServer() {
            return this.serverInstance == -1;
        }

        public String toString() {
            return this.serverInstance + "." + this.serverEntry.getName() + " state=" + (Object)((Object)this.serverState);
        }
    }

    static class ServerInstanceEntry {
        private final int instanceNumber;
        private final String serverName;

        public ServerInstanceEntry(String serverName, int instanceNumber) {
            this.serverName = serverName;
            this.instanceNumber = instanceNumber;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ServerInstanceEntry)) {
                return false;
            }
            ServerInstanceEntry that = (ServerInstanceEntry)o;
            if (this.serverName != null ? !this.serverName.equals(that.serverName) : that.serverName != null) {
                return false;
            }
            return this.instanceNumber == that.instanceNumber;
        }

        public int hashCode() {
            int hash = 17;
            hash = 31 * hash + this.instanceNumber;
            if (this.serverName != null) {
                hash = 31 * hash + this.serverName.hashCode();
            }
            return hash;
        }

        public String toString() {
            return this.instanceNumber + "." + this.serverName;
        }
    }

    private static enum BackendServerState {
        INITIALIZING,
        SLEEPING,
        RUNNING_START_REQUEST,
        RUNNING,
        STOPPING,
        STOPPED,
        SHUTDOWN;

    }
}

