/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.LocalEnvironment;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.config.AppEngineWebXml;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BackgroundThreadFactory
implements ThreadFactory {
    private static final Logger logger = Logger.getLogger(BackgroundThreadFactory.class.getName());
    private static final int API_CALL_LATENCY_MS = 20;
    private static final int THREAD_STARTUP_LATENCY_MS = 20;
    private final AppEngineWebXml appEngineWebXml;

    public BackgroundThreadFactory(AppEngineWebXml appEngineWebXml) {
        this.appEngineWebXml = appEngineWebXml;
    }

    @Override
    public Thread newThread(final Runnable runnable) {
        final LocalBackgroundEnvironment environment = new LocalBackgroundEnvironment(this.appEngineWebXml);
        this.sleepUninterruptably(20L);
        return AccessController.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                Thread thread = new Thread(runnable){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        BackgroundThreadFactory.this.sleepUninterruptably(20L);
                        ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)environment);
                        try {
                            runnable.run();
                        }
                        finally {
                            environment.callRequestEndListeners();
                        }
                    }
                };
                System.setProperty("devappserver-thread-" + thread.getName(), "true");
                return thread;
            }
        });
    }

    private void sleepUninterruptably(long sleepMillis) {
        try {
            Thread.sleep(sleepMillis);
        }
        catch (InterruptedException ex) {
            logger.log(Level.INFO, "Interrupted simulating latency:", ex);
            Thread.currentThread().interrupt();
        }
    }

    private static class LocalBackgroundEnvironment
    extends LocalEnvironment {
        public LocalBackgroundEnvironment(AppEngineWebXml appEngineWebXml) {
            super(appEngineWebXml);
        }

        public String getEmail() {
            return null;
        }

        public boolean isLoggedIn() {
            return false;
        }

        public boolean isAdmin() {
            return false;
        }
    }
}

