/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.ApiProxyLocalFactory;
import com.google.appengine.tools.development.LocalHttpRequestEnvironment;
import com.google.appengine.tools.development.LocalServerEnvironment;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.AppEngineWebXmlReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class LocalApiProxyServletFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(LocalApiProxyServletFilter.class.getName());
    private static final String AE_WEB_XML = "/WEB-INF/appengine-web.xml";
    private AppEngineWebXml appEngineWebXml;

    public void init(FilterConfig config) {
        logger.info("Filter initialization invoked -- registering ApiProxy delegate.");
        ApiProxyLocalFactory factory = new ApiProxyLocalFactory();
        ApiProxy.setDelegate((ApiProxy.Delegate)factory.create(this.getLocalServerEnvironment(config)));
        logger.info("Parsing custom deployment descriptor (/WEB-INF/appengine-web.xml).");
        ServletAppEngineWebXmlReader reader = new ServletAppEngineWebXmlReader(config.getServletContext());
        this.appEngineWebXml = reader.readAppEngineWebXml();
        logger.info("Application identifier is: " + this.appEngineWebXml.getAppId());
    }

    private LocalServerEnvironment getLocalServerEnvironment(FilterConfig config) {
        return new LocalServerEnvironment(){

            @Override
            public File getAppDir() {
                return new File(".");
            }

            @Override
            public String getAddress() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getPort() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getHostName() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void waitForServerToStart() {
            }

            @Override
            public boolean simulateProductionLatencies() {
                return true;
            }

            @Override
            public boolean enforceApiDeadlines() {
                return false;
            }
        };
    }

    public void destroy() {
        logger.info("Filter destruction invoked -- removing delegate.");
        ApiProxy.setDelegate(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        logger.fine("Filter received a request, setting environment ThreadLocal.");
        ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)new LocalHttpRequestEnvironment(this.appEngineWebXml, httpRequest));
        try {
            chain.doFilter(request, response);
        }
        finally {
            logger.fine("Request has completed.  Removing environment ThreadLocal.");
            ApiProxy.clearEnvironmentForCurrentThread();
        }
    }

    private static class ServletAppEngineWebXmlReader
    extends AppEngineWebXmlReader {
        private final ServletContext context;

        public ServletAppEngineWebXmlReader(ServletContext context) {
            super("");
            this.context = context;
        }

        @Override
        protected InputStream getInputStream() {
            return this.context.getResourceAsStream(LocalApiProxyServletFilter.AE_WEB_XML);
        }
    }
}

