/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.agent.impl;

import com.google.appengine.repackaged.org.objectweb.asm.ClassReader;
import com.google.appengine.repackaged.org.objectweb.asm.ClassVisitor;
import com.google.appengine.repackaged.org.objectweb.asm.ClassWriter;
import com.google.appengine.tools.development.agent.impl.AgentImpl;
import com.google.appengine.tools.development.agent.impl.ClassLoaderVisitor;
import com.google.appengine.tools.development.agent.impl.ObjectAccessVisitor;
import com.google.appengine.tools.development.agent.impl.ReflectionVisitor;
import com.google.appengine.tools.development.agent.impl.StripLocalVariablesVisitor;
import com.google.appengine.tools.info.SdkImplInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Transformer
implements ClassFileTransformer {
    private static final Logger logger = Logger.getLogger(Transformer.class.getName());
    private static final String APP_CLASS_LOADER = "com.google.appengine.tools.development.IsolatedAppClassLoader";
    private AgentImpl agent = AgentImpl.getInstance();
    private Set<URL> agentRuntimeLibs;
    private static final String DUMP_CLASSES_PROPERTY = "com.google.appengine.dumpclasses";
    private static final boolean dumpClasses = Boolean.getBoolean("com.google.appengine.dumpclasses");
    private static File dumpDir;

    private static String getClassPackage(String className) {
        int lastPackageIndex = className.lastIndexOf(46);
        if (lastPackageIndex == -1) {
            return "";
        }
        return className.substring(0, lastPackageIndex).replace('.', '/');
    }

    private static String getSimpleName(String className) {
        return className.substring(className.lastIndexOf(46) + 1);
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain domain, byte[] classBuffer) throws IllegalClassFormatException {
        className = className.replace('/', '.');
        if (!this.isAppLoader(loader) || this.isRuntimeCode(domain)) {
            return null;
        }
        try {
            return this.rewrite(className, classBuffer, false);
        }
        catch (Throwable t) {
            try {
                return this.rewrite(className, classBuffer, true);
            }
            catch (Throwable t2) {
                logger.log(Level.SEVERE, "Unable to instrument " + className + ". Security restrictions " + "may not be entirely emulated.", t);
                return null;
            }
        }
    }

    private byte[] rewrite(String className, byte[] classBuffer, boolean stripLocalVars) throws IOException {
        ClassWriter cw;
        ClassReader cr = new ClassReader(new ByteArrayInputStream(classBuffer));
        ClassVisitor visitor = cw = new ClassWriter(1);
        visitor = new ObjectAccessVisitor(visitor);
        visitor = new ReflectionVisitor(visitor);
        visitor = new ClassLoaderVisitor(visitor);
        if (stripLocalVars) {
            visitor = new StripLocalVariablesVisitor(visitor);
        }
        cr.accept(visitor, 4);
        byte[] bytes = cw.toByteArray();
        if (dumpClasses) {
            this.dumpClass(className, bytes);
        }
        return bytes;
    }

    private void dumpClass(final String className, final byte[] bytes) throws IOException {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                String dir = dumpDir + File.separator + Transformer.getClassPackage(className);
                new File(dir).mkdirs();
                try {
                    FileOutputStream fileOutput = new FileOutputStream(dir + File.separator + Transformer.getSimpleName(className) + ".class");
                    fileOutput.write(bytes);
                    fileOutput.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Unable to dump class bytes for " + className, e);
                }
                return null;
            }
        });
    }

    private boolean isRuntimeCode(ProtectionDomain domain) {
        return this.getAgentRuntimeLibs().contains(domain.getCodeSource().getLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<URL> getAgentRuntimeLibs() {
        Transformer transformer = this;
        synchronized (transformer) {
            if (this.agentRuntimeLibs == null) {
                this.agentRuntimeLibs = new HashSet<URL>(SdkImplInfo.getAgentRuntimeLibs());
            }
        }
        return this.agentRuntimeLibs;
    }

    private boolean isAppLoader(ClassLoader loader) {
        if (loader == null) {
            return false;
        }
        if (loader.getClass().getName().equals(APP_CLASS_LOADER)) {
            return true;
        }
        if (this.agent.isAppConstructedURLClassLoader(loader)) {
            return true;
        }
        return this.isAppLoader(loader.getClass().getClassLoader());
    }

    static {
        if (dumpClasses) {
            try {
                dumpDir = File.createTempFile("transformed-classes", "");
                dumpDir.delete();
                logger.log(Level.INFO, "Dumping transformed classes to, " + dumpDir);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

