/*
 * Decompiled with CFR 0.152.
 */
package play.modules.gae;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import play.Logger;
import play.libs.Codec;
import play.libs.IO;
import play.mvc.Http;
import play.utils.NoOpEntityResolver;

public class WS {
    public static String encode(String part) {
        try {
            return URLEncoder.encode(part, "utf-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static WSRequest url(String url) {
        return new WSRequest(url);
    }

    public static WSRequest url(String url, String ... params) {
        Object[] encodedParams = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            encodedParams[i] = WS.encode(params[i]);
        }
        return new WSRequest(String.format(url, encodedParams));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HttpResponse {
        private HttpURLConnection connection;

        public HttpResponse(HttpURLConnection connection) {
            this.connection = connection;
            connection.setDoInput(true);
        }

        public Integer getStatus() {
            try {
                return this.connection.getResponseCode();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String getContentType() {
            return this.getHeader("content-type");
        }

        public String getHeader(String key) {
            return this.connection.getHeaderField(key);
        }

        public List<Http.Header> getHeaders() {
            Map<String, List<String>> hdrs = this.connection.getHeaderFields();
            ArrayList<Http.Header> result = new ArrayList<Http.Header>();
            for (String key : hdrs.keySet()) {
                result.add(new Http.Header(key, hdrs.get(key)));
            }
            return result;
        }

        public Document getXml() {
            return this.getXml("UTF-8");
        }

        public Document getXml(String encoding) {
            try {
                InputSource source = new InputSource(this.connection.getInputStream());
                source.setEncoding(encoding);
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                builder.setEntityResolver((EntityResolver)new NoOpEntityResolver());
                return builder.parse(source);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String getString() {
            try {
                return IO.readContentAsString((InputStream)this.connection.getInputStream());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public InputStream getStream() {
            try {
                return this.connection.getInputStream();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public JsonElement getJson() {
            String json = "";
            try {
                json = this.getString();
                return new JsonParser().parse(json);
            }
            catch (Exception e) {
                Logger.error((String)"Bad JSON: \n%s", (Object[])new Object[]{json});
                throw new RuntimeException("Cannot parse JSON (check logs)", e);
            }
        }
    }

    public static class FileParam {
        File file;
        String paramName;

        public FileParam(File file, String name) {
            this.file = file;
            this.paramName = name;
        }

        public static FileParam[] getFileParams(File[] files) {
            FileParam[] filesp = new FileParam[files.length];
            for (int i = 0; i < files.length; ++i) {
                filesp[i] = new FileParam(files[i], files[i].getName());
            }
            return filesp;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WSRequest {
        public String url;
        public String username;
        public String password;
        public String body;
        public FileParam[] fileParams;
        public Map<String, String> headers = new HashMap<String, String>();
        public Map<String, Object> parameters = new HashMap<String, Object>();
        public String mimeType;
        public Integer timeout;

        private WSRequest(String url) {
            this.url = url;
        }

        public WSRequest mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public WSRequest authenticate(String username, String password) {
            this.username = username;
            this.password = password;
            return this;
        }

        public WSRequest files(File ... files) {
            this.fileParams = FileParam.getFileParams(files);
            return this;
        }

        public WSRequest files(FileParam ... fileParams) {
            this.fileParams = fileParams;
            return this;
        }

        public WSRequest body(Object body) {
            this.body = body == null ? "" : body.toString();
            return this;
        }

        public WSRequest setHeader(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public WSRequest setParameter(String name, String value) {
            this.parameters.put(name, value);
            return this;
        }

        public WSRequest setParameter(String name, Object value) {
            this.parameters.put(name, value);
            return this;
        }

        public WSRequest headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public WSRequest params(Map<String, Object> parameters) {
            this.parameters = parameters;
            return this;
        }

        public WSRequest setParameters(Map<String, String> parameters) {
            this.parameters.putAll(parameters);
            return this;
        }

        public HttpResponse get() {
            try {
                return new HttpResponse(this.prepare(new URL(this.url), "GET"));
            }
            catch (Exception e) {
                Logger.error((String)e.toString(), (Object[])new Object[0]);
                throw new RuntimeException(e);
            }
        }

        public HttpResponse post() {
            try {
                return new HttpResponse(this.prepare(new URL(this.url), "POST"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public HttpResponse put() {
            try {
                return new HttpResponse(this.prepare(new URL(this.url), "PUT"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public HttpResponse delete() {
            try {
                return new HttpResponse(this.prepare(new URL(this.url), "DELETE"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public HttpResponse options() {
            try {
                return new HttpResponse(this.prepare(new URL(this.url), "OPTIONS"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public HttpResponse head() {
            try {
                return new HttpResponse(this.prepare(new URL(this.url), "HEAD"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public HttpResponse trace() {
            try {
                return new HttpResponse(this.prepare(new URL(this.url), "TRACE"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private HttpURLConnection prepare(URL url, String method) {
            if (this.username != null && this.password != null) {
                this.headers.put("Authorization", "Basic " + Codec.encodeBASE64((String)(this.username + ":" + this.password)));
            }
            try {
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                this.checkFileBody(connection);
                connection.setRequestMethod(method);
                for (String key : this.headers.keySet()) {
                    connection.setRequestProperty(key, this.headers.get(key));
                }
                return connection;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void checkFileBody(HttpURLConnection connection) throws IOException {
            OutputStreamWriter writer;
            if (this.parameters != null && !this.parameters.isEmpty()) {
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                connection.setDoOutput(true);
                writer = new OutputStreamWriter(connection.getOutputStream());
                writer.write(this.createQueryString());
                writer.close();
            }
            if (this.body != null) {
                if (this.parameters != null && !this.parameters.isEmpty()) {
                    throw new RuntimeException("POST or PUT method with parameters AND body are not supported.");
                }
                connection.setDoOutput(true);
                writer = new OutputStreamWriter(connection.getOutputStream());
                writer.write(this.body);
                writer.close();
                if (this.mimeType != null) {
                    connection.setRequestProperty("Content-Type", this.mimeType);
                }
            }
        }

        private String createQueryString() {
            StringBuilder sb = new StringBuilder();
            for (String key : this.parameters.keySet()) {
                Object value;
                if (sb.length() > 0) {
                    sb.append("&");
                }
                if ((value = this.parameters.get(key)) == null) continue;
                if (value instanceof Collection || value.getClass().isArray()) {
                    List<Object> values = value.getClass().isArray() ? Arrays.asList((Object[])value) : (List<Object>)value;
                    boolean first = true;
                    for (Object e : values) {
                        if (!first) {
                            sb.append("&");
                        }
                        first = false;
                        sb.append(WS.encode(key)).append("=").append(WS.encode(e.toString()));
                    }
                    continue;
                }
                sb.append(WS.encode(key)).append("=").append(WS.encode(this.parameters.get(key).toString()));
            }
            return sb.toString();
        }
    }
}

