/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.files;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.blobstore.BlobInfo;
import com.google.appengine.api.blobstore.BlobInfoFactory;
import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.files.AppEngineFile;
import com.google.appengine.api.files.FileReadChannel;
import com.google.appengine.api.files.FileReadChannelImpl;
import com.google.appengine.api.files.FileService;
import com.google.appengine.api.files.FileServicePb;
import com.google.appengine.api.files.FileWriteChannel;
import com.google.appengine.api.files.FileWriteChannelImpl;
import com.google.appengine.api.files.FinalizationException;
import com.google.appengine.api.files.GSFileOptions;
import com.google.appengine.api.files.KeyOrderingException;
import com.google.appengine.api.files.LockException;
import com.google.appengine.api.files.RecordReadChannel;
import com.google.appengine.api.files.RecordReadChannelImpl;
import com.google.appengine.api.files.RecordWriteChannel;
import com.google.appengine.api.files.RecordWriteChannelImpl;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.apphosting.api.ApiProxy;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.TreeMap;

class FileServiceImpl
implements FileService {
    static final String PACKAGE = "file";
    static final String FILESYSTEM_BLOBSTORE = AppEngineFile.FileSystem.BLOBSTORE.getName();
    static final String PARAMETER_MIME_TYPE = "content_type";
    static final String PARAMETER_BLOB_INFO_UPLOADED_FILE_NAME = "file_name";
    static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    static final String FILESYSTEM_GS = AppEngineFile.FileSystem.GS.getName();
    static final String GS_FILESYSTEM_PREFIX = "/gs/";
    static final String GS_PARAMETER_MIME_TYPE = "content_type";
    static final String GS_PARAMETER_FILENAME = "filename";
    static final String GS_PARAMETER_CANNED_ACL = "acl";
    static final String GS_PARAMETER_CONTENT_ENCODING = "content_encoding";
    static final String GS_PARAMETER_CONTENT_DISPOSITION = "content_disposition";
    static final String GS_PARAMETER_CACHE_CONTROL = "cache_control";
    static final String GS_USER_METADATA_PREFIX = "x-goog-meta-";
    static final String GS_DEFAULT_MIME_TYPE = "application/octet-stream";
    static final String GS_DEFAULT_ACL = "private";
    private static final String BLOB_INFO_CREATION_HANDLE_PROPERTY = "creation_handle";
    static final String GS_CREATION_HANDLE_PREFIX = "writable:";
    static final String CREATION_HANDLE_PREFIX = "writable:";
    private static final String BLOB_FILE_INDEX_KIND = "__BlobFileIndex__";
    private static final String BLOB_KEY_PROPERTY_NAME = "blob_key";

    FileServiceImpl() {
    }

    @Override
    public AppEngineFile createNewBlobFile(String mimeType) throws IOException {
        return this.createNewBlobFile(mimeType, "");
    }

    @Override
    public AppEngineFile createNewBlobFile(String mimeType, String blobInfoUploadedFileName) throws IOException {
        String filePath;
        AppEngineFile file;
        if (mimeType == null || mimeType.trim().isEmpty()) {
            mimeType = "application/octet-stream";
        }
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("content_type", mimeType);
        if (blobInfoUploadedFileName != null && !blobInfoUploadedFileName.isEmpty()) {
            params.put(PARAMETER_BLOB_INFO_UPLOADED_FILE_NAME, blobInfoUploadedFileName);
        }
        if (!(file = new AppEngineFile(filePath = this.create(FILESYSTEM_BLOBSTORE, null, FileServicePb.FileContentType.ContentType.RAW, params))).getNamePart().startsWith("writable:")) {
            throw new RuntimeException("Expected creation handle: " + file.getFullPath());
        }
        return file;
    }

    @Override
    public AppEngineFile createNewGSFile(GSFileOptions options) throws IOException {
        AppEngineFile file;
        if (options.fileName == null || options.fileName.isEmpty() || !options.fileName.startsWith(GS_FILESYSTEM_PREFIX)) {
            throw new IllegalArgumentException("Invalid fileName, should be of the form: /gs/bucket/key");
        }
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put(GS_PARAMETER_FILENAME, options.fileName.substring(GS_FILESYSTEM_PREFIX.length() - 1));
        params.put("content_type", options.mimeType);
        params.put(GS_PARAMETER_CANNED_ACL, options.acl);
        if (options.cacheControl != null && !options.cacheControl.trim().isEmpty()) {
            params.put(GS_PARAMETER_CACHE_CONTROL, options.cacheControl);
        }
        if (options.contentEncoding != null && !options.contentEncoding.trim().isEmpty()) {
            params.put(GS_PARAMETER_CONTENT_ENCODING, options.contentEncoding);
        }
        if (options.contentDisposition != null && !options.contentDisposition.trim().isEmpty()) {
            params.put(GS_PARAMETER_CONTENT_DISPOSITION, options.contentDisposition);
        }
        if (options.userMetadata != null) {
            for (String key : options.userMetadata.keySet()) {
                if (key == null || key.isEmpty()) {
                    throw new IllegalArgumentException("Empty or null key in userMetadata");
                }
                String value = options.userMetadata.get(key);
                if (value == null || value.isEmpty()) {
                    throw new IllegalArgumentException("Empty or null value in userMetadata for key: " + key);
                }
                params.put(GS_USER_METADATA_PREFIX + key, value);
            }
        }
        if (!(file = new AppEngineFile(this.create(FILESYSTEM_GS, options.fileName, FileServicePb.FileContentType.ContentType.RAW, params))).getNamePart().startsWith("writable:")) {
            throw new RuntimeException("Expected creation handle: " + file.getFullPath());
        }
        return file;
    }

    @Override
    public FileWriteChannel openWriteChannel(AppEngineFile file, boolean lock) throws FileNotFoundException, FinalizationException, LockException, IOException {
        FileWriteChannelImpl channel = new FileWriteChannelImpl(file, lock, this);
        this.openForAppend(file, lock);
        return channel;
    }

    void openForAppend(AppEngineFile file, boolean lock) throws FileNotFoundException, FinalizationException, LockException, IOException {
        this.openForAppend(file.getFullPath(), FileServicePb.FileContentType.ContentType.RAW, lock);
    }

    @Override
    public FileReadChannel openReadChannel(AppEngineFile file, boolean lock) throws FileNotFoundException, LockException, IOException {
        FileReadChannelImpl channel = new FileReadChannelImpl(file, this);
        this.openForRead(file, lock);
        return channel;
    }

    @Override
    public RecordReadChannel openRecordReadChannel(AppEngineFile file, boolean lock) throws FileNotFoundException, LockException, IOException {
        RecordReadChannelImpl channel = new RecordReadChannelImpl(this.openReadChannel(file, lock));
        return channel;
    }

    @Override
    public RecordWriteChannel openRecordWriteChannel(AppEngineFile file, boolean lock) throws FileNotFoundException, LockException, IOException {
        RecordWriteChannelImpl channel = new RecordWriteChannelImpl(this.openWriteChannel(file, lock));
        return channel;
    }

    public void delete(AppEngineFile file) throws IOException {
        this.delete(file.getFullPath());
    }

    int append(AppEngineFile file, ByteBuffer buffer, String sequenceKey) throws IOException {
        if (null == buffer) {
            throw new NullPointerException("buffer is null");
        }
        if (null == file) {
            throw new NullPointerException("file is null");
        }
        ByteString data = ByteString.copyFrom(buffer);
        this.append(file.getFullPath(), data, sequenceKey);
        return data.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlobKey getBlobKey(AppEngineFile file) {
        Entity blobInfoEntity;
        String creationHandle;
        if (null == file) {
            throw new NullPointerException("file is null");
        }
        if (file.getFileSystem() != AppEngineFile.FileSystem.BLOBSTORE) {
            throw new IllegalArgumentException("file is not of type BLOBSTORE");
        }
        BlobKey cached = file.getCachedBlobKey();
        if (null != cached) {
            return cached;
        }
        String namePart = file.getNamePart();
        String string = creationHandle = namePart.startsWith("writable:") ? namePart : null;
        if (null == creationHandle) {
            return new BlobKey(namePart);
        }
        DatastoreService datastore = DatastoreServiceFactory.getDatastoreService();
        String origNamespace = NamespaceManager.get();
        try {
            NamespaceManager.set("");
            try {
                Entity blobFileIndexEntity = datastore.get(KeyFactory.createKey(BLOB_FILE_INDEX_KIND, creationHandle));
                String blobKey = (String)blobFileIndexEntity.getProperty(BLOB_KEY_PROPERTY_NAME);
                blobInfoEntity = datastore.get(KeyFactory.createKey("__BlobInfo__", blobKey));
            }
            catch (EntityNotFoundException ex) {
                Query query = new Query("__BlobInfo__");
                query.addFilter(BLOB_INFO_CREATION_HANDLE_PROPERTY, Query.FilterOperator.EQUAL, creationHandle);
                blobInfoEntity = datastore.prepare(query).asSingleEntity();
            }
        }
        finally {
            NamespaceManager.set(origNamespace);
        }
        if (null == blobInfoEntity) {
            return null;
        }
        BlobInfo blobInfo = new BlobInfoFactory().createBlobInfo(blobInfoEntity);
        return blobInfo.getBlobKey();
    }

    @Override
    public AppEngineFile getBlobFile(BlobKey blobKey) throws FileNotFoundException {
        Entity entity;
        if (null == blobKey) {
            throw new NullPointerException("blobKey is null");
        }
        DatastoreService datastore = DatastoreServiceFactory.getDatastoreService();
        try {
            entity = datastore.get(this.getMetadataKeyForBlobKey(blobKey));
        }
        catch (EntityNotFoundException ex) {
            throw new FileNotFoundException();
        }
        String creationHandle = (String)entity.getProperty(BLOB_INFO_CREATION_HANDLE_PROPERTY);
        String namePart = null == creationHandle ? blobKey.getKeyString() : creationHandle;
        AppEngineFile file = new AppEngineFile(AppEngineFile.FileSystem.BLOBSTORE, namePart);
        file.setCachedBlobKey(blobKey);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Key getMetadataKeyForBlobKey(BlobKey blobKey) {
        String origNamespace = NamespaceManager.get();
        try {
            NamespaceManager.set("");
            Key key = KeyFactory.createKey(null, "__BlobInfo__", blobKey.getKeyString());
            return key;
        }
        finally {
            NamespaceManager.set(origNamespace);
        }
    }

    int read(AppEngineFile file, ByteBuffer buffer, long startingPos) throws IOException {
        if (startingPos < 0L) {
            throw new IllegalArgumentException("startingPos is negative: " + startingPos);
        }
        if (buffer == null) {
            throw new NullPointerException("buffer is null");
        }
        long remaining = buffer.remaining();
        if (buffer.remaining() < 1) {
            return 0;
        }
        ByteString byteString = this.read(file.getFullPath(), startingPos, remaining);
        byteString.copyTo(buffer);
        int numBytesRead = byteString.size();
        if (numBytesRead <= 0) {
            numBytesRead = -1;
        }
        return numBytesRead;
    }

    void close(AppEngineFile file, boolean finalize) throws IOException {
        try {
            this.close(file.getFullPath(), finalize);
        }
        catch (LockException e) {
            if (finalize) {
                throw new IllegalStateException("The current request does not hold the exclusive lock.");
            }
            throw e;
        }
    }

    private void openForAppend(String fileName, FileServicePb.FileContentType.ContentType contentType, boolean lock) throws IOException {
        this.open(fileName, contentType, FileServicePb.OpenRequest.OpenMode.APPEND, lock);
    }

    private void openForRead(AppEngineFile file, boolean lock) throws FileNotFoundException, LockException, IOException {
        if (null == file) {
            throw new NullPointerException("file is null");
        }
        this.openForRead(file.getFullPath(), FileServicePb.FileContentType.ContentType.RAW, lock);
    }

    private void openForRead(String fileName, FileServicePb.FileContentType.ContentType contentType, boolean lock) throws IOException {
        this.open(fileName, contentType, FileServicePb.OpenRequest.OpenMode.READ, lock);
    }

    private String create(String fileSystem, String fileName, FileServicePb.FileContentType.ContentType contentType, Map<String, String> parameters) throws IOException {
        FileServicePb.CreateRequest.Builder request = FileServicePb.CreateRequest.newBuilder();
        request.setFilesystem(fileSystem);
        if (fileName != null && !fileName.isEmpty()) {
            request.setFilename(fileName);
        }
        request.setContentType(contentType);
        if (parameters != null) {
            for (Map.Entry<String, String> e : parameters.entrySet()) {
                FileServicePb.CreateRequest.Parameter.Builder parameter = request.addParametersBuilder();
                parameter.setName(e.getKey());
                parameter.setValue(e.getValue());
            }
        }
        FileServicePb.CreateResponse.Builder response = FileServicePb.CreateResponse.newBuilder();
        this.makeSyncCall("Create", request, response);
        return response.build().getFilename();
    }

    private void open(String fileName, FileServicePb.FileContentType.ContentType contentType, FileServicePb.OpenRequest.OpenMode openMode, boolean lock) throws IOException {
        FileServicePb.OpenRequest.Builder openRequest = FileServicePb.OpenRequest.newBuilder();
        openRequest.setFilename(fileName);
        openRequest.setContentType(contentType);
        openRequest.setOpenMode(openMode);
        openRequest.setExclusiveLock(lock);
        FileServicePb.OpenResponse.Builder openResponse = FileServicePb.OpenResponse.newBuilder();
        this.makeSyncCall("Open", openRequest, openResponse);
    }

    private void append(String fileName, ByteString data, String sequenceKey) throws IOException {
        FileServicePb.AppendRequest.Builder appendRequest = FileServicePb.AppendRequest.newBuilder();
        appendRequest.setFilename(fileName);
        appendRequest.setData(data);
        if (null != sequenceKey) {
            appendRequest.setSequenceKey(sequenceKey);
        }
        FileServicePb.AppendResponse.Builder appendResponse = FileServicePb.AppendResponse.newBuilder();
        this.makeSyncCall("Append", appendRequest, appendResponse);
    }

    private ByteString read(String fileName, long pos, long maxBytes) throws IOException {
        FileServicePb.ReadRequest.Builder readRequest = FileServicePb.ReadRequest.newBuilder();
        readRequest.setFilename(fileName);
        readRequest.setMaxBytes(maxBytes);
        readRequest.setPos(pos);
        FileServicePb.ReadResponse.Builder readResponse = FileServicePb.ReadResponse.newBuilder();
        this.makeSyncCall("Read", readRequest, readResponse);
        return readResponse.build().getData();
    }

    private void close(String fileName, boolean finalize) throws IOException {
        FileServicePb.CloseRequest.Builder closeRequest = FileServicePb.CloseRequest.newBuilder();
        closeRequest.setFilename(fileName);
        closeRequest.setFinalize(finalize);
        FileServicePb.CloseResponse.Builder closeResponse = FileServicePb.CloseResponse.newBuilder();
        this.makeSyncCall("Close", closeRequest, closeResponse);
    }

    private void delete(String fileName) throws IOException {
        FileServicePb.DeleteRequest.Builder deleteRequest = FileServicePb.DeleteRequest.newBuilder();
        deleteRequest.setFilename(fileName);
        FileServicePb.DeleteResponse.Builder deleteResponse = FileServicePb.DeleteResponse.newBuilder();
        this.makeSyncCall("Delete", deleteRequest, deleteResponse);
    }

    private void makeSyncCall(String callName, Message.Builder request, Message.Builder response) throws IOException {
        try {
            byte[] responseBytes = ApiProxy.makeSyncCall(PACKAGE, callName, request.build().toByteArray());
            response.mergeFrom(responseBytes);
        }
        catch (ApiProxy.ApplicationException ex) {
            throw FileServiceImpl.translateException(ex, null);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Internal logic error: Response PB could not be parsed.", e);
        }
    }

    private static IOException translateException(ApiProxy.ApplicationException ex, String message) {
        int errorCode = ex.getApplicationError();
        FileServicePb.FileServiceErrors.ErrorCode errorCodeEnum = FileServicePb.FileServiceErrors.ErrorCode.valueOf(errorCode);
        switch (errorCodeEnum) {
            case EXCLUSIVE_LOCK_FAILED: {
                return new LockException(message, ex);
            }
            case EXISTENCE_ERROR: 
            case EXISTENCE_ERROR_METADATA_NOT_FOUND: 
            case EXISTENCE_ERROR_METADATA_FOUND: 
            case EXISTENCE_ERROR_SHARDING_MISMATCH: {
                return new FileNotFoundException();
            }
            case FINALIZATION_ERROR: {
                return new FinalizationException(message, ex);
            }
            case SEQUENCE_KEY_OUT_OF_ORDER: {
                return new KeyOrderingException(message, ex);
            }
        }
        return new IOException(message, ex);
    }
}

