/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.ExpressionTreeBuilder;
import com.google.appengine.api.search.Preconditions;
import com.google.appengine.api.search.Util;
import com.google.appengine.repackaged.org.antlr.runtime.RecognitionException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public final class FieldChecker {
    public static final int MAXIMUM_NAME_LENGTH = 500;
    public static final int MAXIMUM_TEXT_LENGTH = 0x100000;
    public static final int MAXIMUM_ATOM_LENGTH = 500;
    public static final String FIELD_NAME_PATTERN = "^[A-Za-z][A-Za-z0-9_]*$";

    public static String checkFieldName(String name) {
        return FieldChecker.checkFieldName(name, "field name");
    }

    public static String checkFieldName(String name, String fieldName) {
        Preconditions.checkArgument(name != null, "%s cannot be null", fieldName);
        Preconditions.checkArgument(!Util.isNullOrEmpty(name), "%s cannot be null or empty", fieldName);
        Preconditions.checkArgument(name.length() <= 500, "%s longer than %d : %s", fieldName, 500, name);
        Preconditions.checkArgument(name.matches(FIELD_NAME_PATTERN), "%s should match pattern %s: %s", fieldName, FIELD_NAME_PATTERN, name);
        return name;
    }

    static boolean nameMatchesPattern(String name) {
        return name.matches(FIELD_NAME_PATTERN);
    }

    public static String checkText(String text) {
        if (text != null) {
            Preconditions.checkArgument(text.length() <= 0x100000, "Field text longer than maximum length %d", 0x100000);
        }
        return text;
    }

    public static String checkHTML(String html) {
        if (html != null) {
            Preconditions.checkArgument(html.length() <= 0x100000, "html longer than maximum length %d", 0x100000);
        }
        return html;
    }

    public static String checkAtom(String atom) {
        if (atom != null) {
            Preconditions.checkArgument(!atom.isEmpty(), "atom cannot be empty");
            Preconditions.checkArgument(atom.length() <= 500, "Field atom longer than maximum length %d", 500);
        }
        return atom;
    }

    public static Date checkDate(Date date) throws IllegalArgumentException {
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            if (cal.get(10) != 0 || cal.get(12) != 0 || cal.get(13) != 0 || cal.get(14) != 0) {
                throw new IllegalArgumentException(String.format("date %s must not contain time component", date));
            }
        }
        return date;
    }

    public static String checkExpression(String expression) {
        Preconditions.checkNotNull(expression, "expression cannot be null");
        try {
            new ExpressionTreeBuilder().parse(expression);
        }
        catch (RecognitionException e) {
            throw new IllegalArgumentException("Unable to parse expression: " + e.getMessage());
        }
        return expression;
    }

    static Locale parseLocale(String locale) {
        if (locale == null) {
            return null;
        }
        String[] parts = locale.split("_", 3);
        if (parts.length == 1) {
            return new Locale(parts[0]);
        }
        if (parts.length == 2) {
            return new Locale(parts[0], parts[1]);
        }
        if (parts.length == 3) {
            return new Locale(parts[0], parts[1], parts[2]);
        }
        throw new IllegalArgumentException("Cannot parse locale " + locale);
    }
}

