/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.Preconditions;
import com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.api.search.Util;

public class IndexChecker {
    public static final int MAXIMUM_INDEX_NAME_LENGTH = 100;

    public static String checkName(String indexName) {
        Preconditions.checkArgument(!Util.isNullOrEmpty(indexName), "Index name null or empty");
        Preconditions.checkArgument(indexName.length() <= 100, "Index name longer than %d characters: %s", 100, indexName);
        Preconditions.checkArgument(IndexChecker.isAsciiPrintable(indexName), "indexName must be ASCII printable: %s", indexName);
        Preconditions.checkArgument(!IndexChecker.isReserved(indexName), "indexName must not start with !: %s", indexName);
        return indexName;
    }

    static boolean isAsciiPrintable(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) >= ' ' && str.charAt(i) <= '~') continue;
            return false;
        }
        return true;
    }

    static boolean isReserved(String str) {
        return str.startsWith("!");
    }

    public static SearchServicePb.IndexSpec checkValid(SearchServicePb.IndexSpec spec) {
        IndexChecker.checkName(spec.getName());
        return spec;
    }
}

