/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.FieldChecker;
import com.google.appengine.api.search.Preconditions;
import com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.api.search.SortSpecChecker;
import com.google.appengine.api.search.Util;

public final class SortSpec {
    private final SortType sortType;
    private final boolean sortDescending;
    private final String expression;
    private final int limit;
    private final String defaultValue;
    private final Double defaultValueNumeric;

    private SortSpec(Builder builder) {
        this.sortType = Util.defaultIfNull(builder.sortType, SortType.CUSTOM);
        this.limit = Util.defaultIfNull(builder.limit, 1000);
        this.expression = builder.expression;
        this.sortDescending = Util.defaultIfNull(builder.sortDescending, true);
        this.defaultValue = builder.defaultValue;
        this.defaultValueNumeric = builder.defaultValueNumeric;
        this.checkValid();
    }

    public SortType getType() {
        return this.sortType;
    }

    public int getLimit() {
        return this.limit;
    }

    public String getExpression() {
        return this.expression;
    }

    public boolean isSortDescending() {
        return this.sortDescending;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Double getDefaultValueNumeric() {
        return this.defaultValueNumeric;
    }

    private SortSpec checkValid() {
        if (this.getType() == SortType.CUSTOM) {
            Preconditions.checkNotNull(this.expression, "expression cannot be null");
            if (this.defaultValue != null) {
                FieldChecker.checkText(this.defaultValue);
            }
        } else {
            SortSpecChecker.checkLimit(this.limit);
            Preconditions.checkArgument(this.expression == null, "expression can not be defined if using a scorer");
            Preconditions.checkArgument(this.defaultValue == null, "defaultValue can not be defined if using a scorer");
        }
        return this;
    }

    SearchServicePb.SortSpec copyToProtocolBuffer() {
        SearchServicePb.SortSpec.Builder builder = SearchServicePb.SortSpec.newBuilder().setSortDescending(this.isSortDescending());
        builder.setSortExpression(this.getExpression());
        if (this.getDefaultValue() != null) {
            builder.setDefaultValueText(this.getDefaultValue());
        }
        if (this.getDefaultValueNumeric() != null) {
            builder.setDefaultValueNumeric(this.getDefaultValueNumeric());
        }
        return builder.build();
    }

    SearchServicePb.ScorerSpec copyToScorerSpecProtocolBuffer() {
        SearchServicePb.ScorerSpec.Builder builder = SearchServicePb.ScorerSpec.newBuilder();
        builder.setLimit(this.limit);
        switch (this.sortType) {
            case MATCH_SCORER: {
                break;
            }
            case RESCORING_MATCH_SCORER: {
                builder.setScorer(SearchServicePb.ScorerSpec.Scorer.RESCORING_MATCH_SCORER);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("unknown sort type %s", this.sortType.name()));
            }
        }
        return builder.build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return String.format("SortSpec(sortType=%s, limit=%d, sortDescending=%s%s%s%s)", new Object[]{this.sortType, this.limit, this.sortDescending, Util.fieldToString("expression", this.expression), Util.fieldToString("defaultValue", this.defaultValue), Util.fieldToString("defaultValueNumeric", this.defaultValueNumeric)});
    }

    public static enum SortType {
        CUSTOM,
        RESCORING_MATCH_SCORER,
        MATCH_SCORER;

    }

    public static final class Builder {
        private SortType sortType;
        private Integer limit;
        private String expression;
        private Boolean sortDescending;
        private String defaultValue;
        private Double defaultValueNumeric;

        private Builder() {
        }

        public Builder setType(SortType type) {
            this.sortType = Preconditions.checkNotNull(type, "sort type cannot be null");
            return this;
        }

        public Builder setLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public Builder setExpression(String expression) {
            this.expression = FieldChecker.checkExpression(expression);
            return this;
        }

        public Builder setSortDescending(boolean sortDescending) {
            this.sortDescending = sortDescending;
            return this;
        }

        public Builder setDefaultValue(String defaultValue) {
            this.defaultValue = FieldChecker.checkText(defaultValue);
            return this;
        }

        public Builder setDefaultValueNumeric(double defaultValue) {
            this.defaultValueNumeric = defaultValue;
            return this;
        }

        public SortSpec build() {
            return new SortSpec(this);
        }
    }
}

